/*
 * Decompiled with CFR 0.152.
 */
package com.totvscrm.pentaho.step.opensocket;

import com.totvscrm.pentaho.step.opensocket.OpenSocketData;
import com.totvscrm.pentaho.step.opensocket.OpenSocketMeta;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.List;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;

public class OpenSocket
extends BaseStep
implements StepInterface {
    public OpenSocketMeta meta;
    public OpenSocketData data;

    public OpenSocket(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        Object[] rowData;
        if (this.data.readsRows) {
            rowData = this.getRow();
            if (rowData == null) {
                this.setOutputDone();
                return false;
            }
        } else {
            rowData = RowDataUtil.allocateRowData((int)0);
            this.incrementLinesRead();
        }
        if (this.first && rowData != null) {
            this.first = false;
            this.data.inputRowMeta = this.data.readsRows ? this.getInputRowMeta() : new RowMeta();
            this.data.outputRowMeta = this.data.inputRowMeta.clone();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, (VariableSpace)this, this.repository, this.metaStore);
            this.data.conversionMeta = this.data.outputRowMeta.cloneToType(2);
            int fieldsLength = 1;
            this.data.extraData = new Object[fieldsLength];
            String newValue = "0";
            int porta = 0;
            for (int i = 0; i < fieldsLength; ++i) {
                try {
                    porta = Integer.parseInt(this.environmentSubstitute(this.meta.getPorta()));
                    ServerSocket ss = new ServerSocket(porta);
                    this.logBasic("Porta " + porta + " alocada/n" + String.valueOf(ss));
                    newValue = this.environmentSubstitute(this.meta.getPorta());
                }
                catch (NumberFormatException e) {
                    if (this.meta.isKill()) {
                        this.logError("PORTA " + this.meta.getPorta() + " INVALIDA!");
                        e.printStackTrace();
                        System.exit(404);
                    }
                    this.logError("PORTA " + this.meta.getPorta() + " INVALIDA!");
                    e.printStackTrace();
                    return false;
                }
                catch (IOException e) {
                    if (this.meta.isKill()) {
                        this.logError("Porta " + porta + " sendo usada");
                        e.printStackTrace();
                        System.exit(404);
                    }
                    this.logError("Porta " + porta + " sendo usada");
                    e.printStackTrace();
                    return false;
                }
                if (this.log.isDetailed()) {
                    this.logDetailed("field [ porta ] has value [" + newValue + "]");
                }
                ValueMetaInterface targetMeta = this.data.outputRowMeta.getValueMeta(this.data.inputRowMeta.size() + i);
                ValueMetaInterface sourceMeta = this.data.conversionMeta.getValueMeta(this.data.inputRowMeta.size() + i);
                this.data.extraData[i] = targetMeta.convertData(sourceMeta, (Object)newValue);
            }
        }
        rowData = RowDataUtil.addRowData((Object[])rowData, (int)this.data.inputRowMeta.size(), (Object[])this.data.extraData);
        this.putRow(this.data.outputRowMeta, rowData);
        if (!this.data.readsRows) {
            this.setOutputDone();
            return false;
        }
        return true;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (OpenSocketMeta)smi;
        this.data = (OpenSocketData)sdi;
        if (super.init(smi, sdi)) {
            this.data.readsRows = this.getStepMeta().getRemoteInputSteps().size() > 0;
            List previous = this.getTransMeta().findPreviousSteps(this.getStepMeta());
            if (previous != null && previous.size() > 0) {
                this.data.readsRows = true;
            }
            return true;
        }
        return false;
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        super.dispose(smi, sdi);
    }
}

