/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.textfileinput;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.ByteOrderMark;
import org.pentaho.di.core.util.Utils;

@Deprecated
public enum EncodingType {
    SINGLE(1, 0, 13, 10),
    DOUBLE_BIG_ENDIAN(2, 65279, 13, 10),
    DOUBLE_LITTLE_ENDIAN(2, 65534, 3328, 2560);

    private static final String UTF_8_BOM;
    private int length;
    private int bom;
    private int carriageReturnChar;
    private int lineFeedChar;

    private EncodingType(int length, int bom, int carriageReturnChar, int lineFeedChar) {
        this.length = length;
        this.bom = bom;
        this.carriageReturnChar = carriageReturnChar;
        this.lineFeedChar = lineFeedChar;
    }

    public int getLength() {
        return this.length;
    }

    public int getBom() {
        return this.bom;
    }

    public int getCarriageReturnChar() {
        return this.carriageReturnChar;
    }

    public int getLineFeedChar() {
        return this.lineFeedChar;
    }

    public boolean isReturn(int c) {
        return c == this.carriageReturnChar || c == 13;
    }

    public boolean isLinefeed(int c) {
        return c == this.lineFeedChar || c == 10;
    }

    public static EncodingType guessEncodingType(String encoding) {
        EncodingType encodingType = Utils.isEmpty((CharSequence)encoding) ? SINGLE : (encoding.startsWith("UnicodeBig") || encoding.equals("UTF-16BE") ? DOUBLE_BIG_ENDIAN : (encoding.startsWith("UnicodeLittle") || encoding.equals("UTF-16LE") ? DOUBLE_LITTLE_ENDIAN : (encoding.equals("UTF-16") ? DOUBLE_BIG_ENDIAN : SINGLE)));
        return encodingType;
    }

    public static String removeBOMIfPresent(String string) {
        if (string == null) {
            return null;
        }
        return string.replaceFirst(UTF_8_BOM, "");
    }

    public byte[] getBytes(String string, String encoding) throws UnsupportedEncodingException {
        byte[] withBom = Utils.isEmpty((CharSequence)encoding) ? string.getBytes() : string.getBytes(encoding);
        switch (this.length) {
            case 1: {
                return withBom;
            }
            case 2: {
                if (withBom.length < 2) {
                    return withBom;
                }
                if (withBom[0] < 0 && withBom[1] < 0) {
                    byte[] b = new byte[withBom.length - 2];
                    for (int i = 0; i < withBom.length - 2; ++i) {
                        b[i] = withBom[i + 2];
                    }
                    return b;
                }
                return withBom;
            }
        }
        return withBom;
    }

    static {
        UTF_8_BOM = new String(ByteOrderMark.UTF_8.getBytes(), StandardCharsets.UTF_8);
    }
}

