/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.stringoperations;

import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.injection.Injection;
import org.pentaho.di.core.injection.InjectionSupported;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.stringoperations.StringOperations;
import org.pentaho.di.trans.steps.stringoperations.StringOperationsData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

@InjectionSupported(localizationPrefix="StringOperations.Injection.")
public class StringOperationsMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = StringOperationsMeta.class;
    @Injection(name="FIELD_IN_STREAM")
    private String[] fieldInStream;
    @Injection(name="FIELD_OUT_STREAM")
    private String[] fieldOutStream;
    @Injection(name="TRIM_TYPE")
    private String[] trimType;
    @Injection(name="LOWER_UPPER")
    private String[] lowerUpper;
    @Injection(name="INIT_CAP")
    private String[] initCap;
    @Injection(name="ESCAPE")
    private String[] maskXML;
    @Injection(name="DIGITS")
    private String[] digits;
    @Injection(name="REMOVE_SPECIAL_CHARACTERS")
    private String[] remove_special_characters;
    @Injection(name="PADDING_TYPE")
    private String[] padding_type;
    @Injection(name="PADDING_LENGTH")
    private String[] padLen;
    @Injection(name="PADDING_CHAR")
    private String[] padChar;
    public static final String[] trimTypeCode = new String[]{"none", "left", "right", "both"};
    public static final int TRIM_NONE = 0;
    public static final int TRIM_LEFT = 1;
    public static final int TRIM_RIGHT = 2;
    public static final int TRIM_BOTH = 3;
    public static final String[] trimTypeDesc = new String[]{BaseMessages.getString(PKG, (String)"StringOperationsMeta.TrimType.None", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StringOperationsMeta.TrimType.Left", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StringOperationsMeta.TrimType.Right", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StringOperationsMeta.TrimType.Both", (String[])new String[0])};
    public static final String[] lowerUpperCode = new String[]{"none", "lower", "upper"};
    public static final int LOWER_UPPER_NONE = 0;
    public static final int LOWER_UPPER_LOWER = 1;
    public static final int LOWER_UPPER_UPPER = 2;
    public static final String[] lowerUpperDesc = new String[]{BaseMessages.getString(PKG, (String)"StringOperationsMeta.LowerUpper.None", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StringOperationsMeta.LowerUpper.Lower", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StringOperationsMeta.LowerUpper.Upper", (String[])new String[0])};
    public static final String[] initCapDesc = new String[]{BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0])};
    public static final String[] initCapCode = new String[]{"no", "yes"};
    private static final String[] initCapCodeMDI = new String[]{"n", "y"};
    public static final int INIT_CAP_NO = 0;
    public static final int INIT_CAP_YES = 1;
    public static final String[] digitsCode = new String[]{"none", "digits_only", "remove_digits"};
    private static final String[] digitsCodeMDI = new String[]{BaseMessages.getString(PKG, (String)"StringOperationsMeta.Digits.None", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StringOperationsMeta.Digits.Only", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StringOperationsMeta.Digits.Remove", (String[])new String[0])};
    public static final int DIGITS_NONE = 0;
    public static final int DIGITS_ONLY = 1;
    public static final int DIGITS_REMOVE = 2;
    public static final String[] digitsDesc = new String[]{BaseMessages.getString(PKG, (String)"StringOperationsMeta.Digits.None", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StringOperationsMeta.Digits.Only", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StringOperationsMeta.Digits.Remove", (String[])new String[0])};
    public static final String[] maskXMLDesc = new String[]{BaseMessages.getString(PKG, (String)"StringOperationsMeta.MaskXML.None", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StringOperationsMeta.MaskXML.EscapeXML", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StringOperationsMeta.MaskXML.CDATA", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StringOperationsMeta.MaskXML.UnEscapeXML", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StringOperationsMeta.MaskXML.EscapeSQL", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StringOperationsMeta.MaskXML.EscapeHTML", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StringOperationsMeta.MaskXML.UnEscapeHTML", (String[])new String[0])};
    public static final String[] maskXMLCode = new String[]{"none", "escapexml", "cdata", "unescapexml", "escapesql", "escapehtml", "unescapehtml"};
    private static final String[] maskXMLCodeMDI = new String[]{BaseMessages.getString(PKG, (String)"StringOperationsMeta.MaskXML.None", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StringOperations.MDI.Mask.EscapeXML", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StringOperations.MDI.Mask.CDATA", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StringOperations.MDI.Mask.UnescapeXML", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StringOperations.MDI.Mask.EscapeSQL", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StringOperations.MDI.Mask.EscapeHTML", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StringOperations.MDI.Mask.UnescapeHTML", (String[])new String[0])};
    public static final int MASK_NONE = 0;
    public static final int MASK_ESCAPE_XML = 1;
    public static final int MASK_CDATA = 2;
    public static final int MASK_UNESCAPE_XML = 3;
    public static final int MASK_ESCAPE_SQL = 4;
    public static final int MASK_ESCAPE_HTML = 5;
    public static final int MASK_UNESCAPE_HTML = 6;
    public static final String[] removeSpecialCharactersCode = new String[]{"none", "cr", "lf", "crlf", "tab", "espace"};
    private static final String[] removeSpecialCharactersCodeMDI = new String[]{BaseMessages.getString(PKG, (String)"StringOperationsMeta.RemoveSpecialCharacters.None", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StringOperations.MDI.RemoveSpecialCharacters.CR", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StringOperations.MDI.RemoveSpecialCharacters.LF", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StringOperations.MDI.RemoveSpecialCharacters.CRLF", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StringOperations.MDI.RemoveSpecialCharacters.TAB", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StringOperations.MDI.RemoveSpecialCharacters.Space", (String[])new String[0])};
    public static final int REMOVE_SPECIAL_CHARACTERS_NONE = 0;
    public static final int REMOVE_SPECIAL_CHARACTERS_CR = 1;
    public static final int REMOVE_SPECIAL_CHARACTERS_LF = 2;
    public static final int REMOVE_SPECIAL_CHARACTERS_CRLF = 3;
    public static final int REMOVE_SPECIAL_CHARACTERS_TAB = 4;
    public static final int REMOVE_SPECIAL_CHARACTERS_ESPACE = 5;
    public static final String[] removeSpecialCharactersDesc = new String[]{BaseMessages.getString(PKG, (String)"StringOperationsMeta.RemoveSpecialCharacters.None", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StringOperationsMeta.RemoveSpecialCharacters.CR", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StringOperationsMeta.RemoveSpecialCharacters.LF", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StringOperationsMeta.RemoveSpecialCharacters.CRLF", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StringOperationsMeta.RemoveSpecialCharacters.TAB", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StringOperationsMeta.RemoveSpecialCharacters.Space", (String[])new String[0])};
    public static final String[] paddingDesc = new String[]{BaseMessages.getString(PKG, (String)"StringOperationsMeta.Padding.None", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StringOperationsMeta.Padding.Left", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StringOperationsMeta.Padding.Right", (String[])new String[0])};
    public static final String[] paddingCode = new String[]{"none", "left", "right"};
    public static final int PADDING_NONE = 0;
    public static final int PADDING_LEFT = 1;
    public static final int PADDING_RIGHT = 2;

    public String[] getFieldInStream() {
        return this.fieldInStream;
    }

    public void setFieldInStream(String[] keyStream) {
        this.fieldInStream = keyStream;
    }

    public String[] getFieldOutStream() {
        return this.fieldOutStream;
    }

    public void setFieldOutStream(String[] keyStream) {
        this.fieldOutStream = keyStream;
    }

    public String[] getPadLen() {
        return this.padLen;
    }

    public void setPadLen(String[] value) {
        this.padLen = value;
    }

    public String[] getPadChar() {
        return this.padChar;
    }

    public void setPadChar(String[] value) {
        this.padChar = value;
    }

    public String[] getTrimType() {
        return this.trimType;
    }

    public void setTrimType(String[] trimType) {
        this.trimType = trimType;
    }

    public String[] getLowerUpper() {
        return this.lowerUpper;
    }

    public void setLowerUpper(String[] lowerUpper) {
        this.lowerUpper = lowerUpper;
    }

    public String[] getInitCap() {
        return this.initCap;
    }

    public void setInitCap(String[] value) {
        this.initCap = value;
    }

    public String[] getMaskXML() {
        return this.maskXML;
    }

    public void setMaskXML(String[] value) {
        this.maskXML = value;
    }

    public String[] getDigits() {
        return this.digits;
    }

    public void setDigits(String[] value) {
        this.digits = value;
    }

    public String[] getRemoveSpecialCharacters() {
        return this.remove_special_characters;
    }

    public void setRemoveSpecialCharacters(String[] value) {
        this.remove_special_characters = value;
    }

    public String[] getPaddingType() {
        return this.padding_type;
    }

    public void setPaddingType(String[] value) {
        this.padding_type = value;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode);
    }

    public void allocate(int nrkeys) {
        this.fieldInStream = new String[nrkeys];
        this.fieldOutStream = new String[nrkeys];
        this.trimType = new String[nrkeys];
        this.lowerUpper = new String[nrkeys];
        this.padding_type = new String[nrkeys];
        this.padChar = new String[nrkeys];
        this.padLen = new String[nrkeys];
        this.initCap = new String[nrkeys];
        this.maskXML = new String[nrkeys];
        this.digits = new String[nrkeys];
        this.remove_special_characters = new String[nrkeys];
    }

    @Override
    public Object clone() {
        StringOperationsMeta retval = (StringOperationsMeta)super.clone();
        int nrkeys = this.fieldInStream.length;
        retval.allocate(nrkeys);
        System.arraycopy(this.fieldInStream, 0, retval.fieldInStream, 0, nrkeys);
        System.arraycopy(this.fieldOutStream, 0, retval.fieldOutStream, 0, nrkeys);
        System.arraycopy(this.trimType, 0, retval.trimType, 0, nrkeys);
        System.arraycopy(this.lowerUpper, 0, retval.lowerUpper, 0, nrkeys);
        System.arraycopy(this.padding_type, 0, retval.padding_type, 0, nrkeys);
        System.arraycopy(this.padChar, 0, retval.padChar, 0, nrkeys);
        System.arraycopy(this.padLen, 0, retval.padLen, 0, nrkeys);
        System.arraycopy(this.initCap, 0, retval.initCap, 0, nrkeys);
        System.arraycopy(this.maskXML, 0, retval.maskXML, 0, nrkeys);
        System.arraycopy(this.digits, 0, retval.digits, 0, nrkeys);
        System.arraycopy(this.remove_special_characters, 0, retval.remove_special_characters, 0, nrkeys);
        return retval;
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            Node lookup = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int nrkeys = XMLHandler.countNodes((Node)lookup, (String)"field");
            this.allocate(nrkeys);
            for (int i = 0; i < nrkeys; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)lookup, (String)"field", (int)i);
                this.fieldInStream[i] = Const.NVL((String)XMLHandler.getTagValue((Node)fnode, (String)"in_stream_name"), (String)"");
                this.fieldOutStream[i] = Const.NVL((String)XMLHandler.getTagValue((Node)fnode, (String)"out_stream_name"), (String)"");
                this.trimType[i] = Const.NVL((String)XMLHandler.getTagValue((Node)fnode, (String)"trim_type"), (String)"");
                this.lowerUpper[i] = Const.NVL((String)XMLHandler.getTagValue((Node)fnode, (String)"lower_upper"), (String)"");
                this.padding_type[i] = Const.NVL((String)XMLHandler.getTagValue((Node)fnode, (String)"padding_type"), (String)"");
                this.padChar[i] = Const.NVL((String)XMLHandler.getTagValue((Node)fnode, (String)"pad_char"), (String)"");
                this.padLen[i] = Const.NVL((String)XMLHandler.getTagValue((Node)fnode, (String)"pad_len"), (String)"");
                this.initCap[i] = Const.NVL((String)XMLHandler.getTagValue((Node)fnode, (String)"init_cap"), (String)"");
                this.maskXML[i] = Const.NVL((String)XMLHandler.getTagValue((Node)fnode, (String)"mask_xml"), (String)"");
                this.digits[i] = Const.NVL((String)XMLHandler.getTagValue((Node)fnode, (String)"digits"), (String)"");
                this.remove_special_characters[i] = Const.NVL((String)XMLHandler.getTagValue((Node)fnode, (String)"remove_special_characters"), (String)"");
            }
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"StringOperationsMeta.Exception.UnableToReadStepInfoFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        this.fieldInStream = null;
        this.fieldOutStream = null;
        int nrkeys = 0;
        this.allocate(nrkeys);
    }

    @Override
    public String getXML() {
        StringBuilder retval = new StringBuilder(500);
        retval.append("    <fields>").append(Const.CR);
        for (int i = 0; i < this.fieldInStream.length; ++i) {
            retval.append("      <field>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"in_stream_name", (String)this.fieldInStream[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"out_stream_name", (String)this.fieldOutStream[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"trim_type", (String)this.trimType[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"lower_upper", (String)this.lowerUpper[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"padding_type", (String)this.padding_type[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"pad_char", (String)this.padChar[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"pad_len", (String)this.padLen[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"init_cap", (String)this.initCap[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"mask_xml", (String)this.maskXML[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"digits", (String)this.digits[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"remove_special_characters", (String)this.remove_special_characters[i]));
            retval.append("      </field>").append(Const.CR);
        }
        retval.append("    </fields>").append(Const.CR);
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            int nrkeys = rep.countNrStepAttributes(id_step, "in_stream_name");
            this.allocate(nrkeys);
            for (int i = 0; i < nrkeys; ++i) {
                this.fieldInStream[i] = Const.NVL((String)rep.getStepAttributeString(id_step, i, "in_stream_name"), (String)"");
                this.fieldOutStream[i] = Const.NVL((String)rep.getStepAttributeString(id_step, i, "out_stream_name"), (String)"");
                this.trimType[i] = Const.NVL((String)rep.getStepAttributeString(id_step, i, "trim_type"), (String)"");
                this.lowerUpper[i] = Const.NVL((String)rep.getStepAttributeString(id_step, i, "lower_upper"), (String)"");
                this.padding_type[i] = Const.NVL((String)rep.getStepAttributeString(id_step, i, "padding_type"), (String)"");
                this.padChar[i] = Const.NVL((String)rep.getStepAttributeString(id_step, i, "pad_char"), (String)"");
                this.padLen[i] = Const.NVL((String)rep.getStepAttributeString(id_step, i, "pad_len"), (String)"");
                this.initCap[i] = Const.NVL((String)rep.getStepAttributeString(id_step, i, "init_cap"), (String)"");
                this.maskXML[i] = Const.NVL((String)rep.getStepAttributeString(id_step, i, "mask_xml"), (String)"");
                this.digits[i] = Const.NVL((String)rep.getStepAttributeString(id_step, i, "digits"), (String)"");
                this.remove_special_characters[i] = Const.NVL((String)rep.getStepAttributeString(id_step, i, "remove_special_characters"), (String)"");
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"StringOperationsMeta.Exception.UnexpectedErrorInReadingStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            for (int i = 0; i < this.fieldInStream.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "in_stream_name", this.fieldInStream[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "out_stream_name", this.fieldOutStream[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "trim_type", this.trimType[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "lower_upper", this.lowerUpper[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "padding_type", this.padding_type[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "pad_char", this.padChar[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "pad_len", this.padLen[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "init_cap", this.initCap[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "mask_xml", this.maskXML[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "digits", this.digits[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "remove_special_characters", this.remove_special_characters[i]);
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"StringOperationsMeta.Exception.UnableToSaveStepInfo", (String[])new String[0]) + id_step, (Throwable)e);
        }
    }

    @Override
    public void getFields(RowMetaInterface inputRowMeta, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        for (int i = 0; i < this.fieldOutStream.length; ++i) {
            int padLen;
            ValueMetaString v;
            String outputField = space.environmentSubstitute(this.fieldOutStream[i]);
            if (!Utils.isEmpty((CharSequence)outputField)) {
                v = new ValueMetaString(outputField);
                v.setLength(100, -1);
                v.setOrigin(name);
                inputRowMeta.addValueMeta((ValueMetaInterface)v);
                continue;
            }
            v = inputRowMeta.searchValueMeta(this.fieldInStream[i]);
            if (v == null) continue;
            v.setStorageType(0);
            int paddingType = StringOperationsMeta.getPaddingByDesc(this.getPaddingType()[i]);
            if (paddingType != 1 && paddingType != 2 || (padLen = Const.toInt((String)space.environmentSubstitute(this.getPadLen()[i]), (int)0)) <= v.getLength()) continue;
            v.setLength(padLen);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepinfo, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        String error_message = "";
        boolean first = true;
        boolean error_found = false;
        if (prev == null) {
            error_message = error_message + BaseMessages.getString(PKG, (String)"StringOperationsMeta.CheckResult.NoInputReceived", (String[])new String[0]) + Const.CR;
            CheckResult cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        } else {
            int idx;
            ValueMetaInterface v;
            String field;
            int i;
            for (i = 0; i < this.fieldInStream.length; ++i) {
                field = this.fieldInStream[i];
                v = prev.searchValueMeta(field);
                if (v != null) continue;
                if (first) {
                    first = false;
                    error_message = error_message + BaseMessages.getString(PKG, (String)"StringOperationsMeta.CheckResult.MissingInStreamFields", (String[])new String[0]) + Const.CR;
                }
                error_found = true;
                error_message = error_message + "\t\t" + field + Const.CR;
            }
            CheckResult cr = error_found ? new CheckResult(4, error_message, (CheckResultSourceInterface)stepinfo) : new CheckResult(1, BaseMessages.getString(PKG, (String)"StringOperationsMeta.CheckResult.FoundInStreamFields", (String[])new String[0]), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
            first = true;
            error_found = false;
            for (i = 0; i < this.fieldInStream.length; ++i) {
                field = this.fieldInStream[i];
                v = prev.searchValueMeta(field);
                if (v == null || v.getType() == 2) continue;
                if (first) {
                    first = false;
                    error_message = error_message + BaseMessages.getString(PKG, (String)"StringOperationsMeta.CheckResult.OperationOnNonStringFields", (String[])new String[0]) + Const.CR;
                }
                error_found = true;
                error_message = error_message + "\t\t" + field + Const.CR;
            }
            cr = error_found ? new CheckResult(4, error_message, (CheckResultSourceInterface)stepinfo) : new CheckResult(1, BaseMessages.getString(PKG, (String)"StringOperationsMeta.CheckResult.AllOperationsOnStringFields", (String[])new String[0]), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
            if (this.fieldInStream.length > 0) {
                for (idx = 0; idx < this.fieldInStream.length; ++idx) {
                    if (!Utils.isEmpty((CharSequence)this.fieldInStream[idx])) continue;
                    cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"StringOperationsMeta.CheckResult.InStreamFieldMissing", (String[])new String[]{new Integer(idx + 1).toString()}), (CheckResultSourceInterface)stepinfo);
                    remarks.add((CheckResultInterface)cr);
                }
            }
            for (idx = 0; idx < this.fieldInStream.length; ++idx) {
                for (int jdx = 0; jdx < this.fieldInStream.length; ++jdx) {
                    if (!this.fieldInStream[idx].equals(this.fieldInStream[jdx]) || idx == jdx || idx >= jdx) continue;
                    error_message = BaseMessages.getString(PKG, (String)"StringOperationsMeta.CheckResult.FieldInputError", (String[])new String[]{this.fieldInStream[idx]});
                    cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepinfo);
                    remarks.add((CheckResultInterface)cr);
                }
            }
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new StringOperations(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new StringOperationsData();
    }

    @Override
    public boolean supportsErrorHandling() {
        return true;
    }

    public static String getTrimTypeCode(int i) {
        if (i < 0 || i >= trimTypeCode.length) {
            return trimTypeCode[0];
        }
        return trimTypeCode[i];
    }

    public static String getLowerUpperCode(int i) {
        if (i < 0 || i >= lowerUpperCode.length) {
            return lowerUpperCode[0];
        }
        return lowerUpperCode[i];
    }

    public static String getInitCapCode(int i) {
        if (i < 0 || i >= initCapCode.length) {
            return initCapCode[0];
        }
        return initCapCode[i];
    }

    public static String getMaskXMLCode(int i) {
        if (i < 0 || i >= maskXMLCode.length) {
            return maskXMLCode[0];
        }
        return maskXMLCode[i];
    }

    public static String getDigitsCode(int i) {
        if (i < 0 || i >= digitsCode.length) {
            return digitsCode[0];
        }
        return digitsCode[i];
    }

    public static String getRemoveSpecialCharactersCode(int i) {
        if (i < 0 || i >= removeSpecialCharactersCode.length) {
            return removeSpecialCharactersCode[0];
        }
        return removeSpecialCharactersCode[i];
    }

    public static String getPaddingCode(int i) {
        if (i < 0 || i >= paddingCode.length) {
            return paddingCode[0];
        }
        return paddingCode[i];
    }

    public static String getTrimTypeDesc(int i) {
        if (i < 0 || i >= trimTypeDesc.length) {
            return trimTypeDesc[0];
        }
        return trimTypeDesc[i];
    }

    public static String getLowerUpperDesc(int i) {
        if (i < 0 || i >= lowerUpperDesc.length) {
            return lowerUpperDesc[0];
        }
        return lowerUpperDesc[i];
    }

    public static String getInitCapDesc(int i) {
        if (i < 0 || i >= initCapDesc.length) {
            return initCapDesc[0];
        }
        return initCapDesc[i];
    }

    public static String getMaskXMLDesc(int i) {
        if (i < 0 || i >= maskXMLDesc.length) {
            return maskXMLDesc[0];
        }
        return maskXMLDesc[i];
    }

    public static String getDigitsDesc(int i) {
        if (i < 0 || i >= digitsDesc.length) {
            return digitsDesc[0];
        }
        return digitsDesc[i];
    }

    public static String getRemoveSpecialCharactersDesc(int i) {
        if (i < 0 || i >= removeSpecialCharactersDesc.length) {
            return removeSpecialCharactersDesc[0];
        }
        return removeSpecialCharactersDesc[i];
    }

    public static String getPaddingDesc(int i) {
        if (i < 0 || i >= paddingDesc.length) {
            return paddingDesc[0];
        }
        return paddingDesc[i];
    }

    private static int getTrimTypeByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < trimTypeCode.length; ++i) {
            if (!trimTypeCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public static int getLowerUpperByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < lowerUpperCode.length; ++i) {
            if (!lowerUpperCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    private static int getInitCapByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < initCapCode.length; ++i) {
            if (!initCapCode[i].equalsIgnoreCase(tt) && !initCapCodeMDI[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    private static int getMaskXMLByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < maskXMLCode.length; ++i) {
            if (!maskXMLCode[i].equalsIgnoreCase(tt) && !maskXMLCodeMDI[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    private static int getDigitsByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < digitsCode.length; ++i) {
            if (!digitsCode[i].equalsIgnoreCase(tt) && !digitsCodeMDI[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    private static int getRemoveSpecialCharactersByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < removeSpecialCharactersCode.length; ++i) {
            if (!removeSpecialCharactersCode[i].equalsIgnoreCase(tt) && !removeSpecialCharactersCodeMDI[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    private static int getPaddingByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < paddingCode.length; ++i) {
            if (!paddingCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public static int getTrimTypeByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < trimTypeDesc.length; ++i) {
            if (!trimTypeDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return StringOperationsMeta.getTrimTypeByCode(tt);
    }

    public static int getLowerUpperByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < lowerUpperDesc.length; ++i) {
            if (!lowerUpperDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return StringOperationsMeta.getLowerUpperByCode(tt);
    }

    public static int getInitCapByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < initCapDesc.length; ++i) {
            if (!initCapDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return StringOperationsMeta.getInitCapByCode(tt);
    }

    public static int getMaskXMLByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < maskXMLDesc.length; ++i) {
            if (!maskXMLDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return StringOperationsMeta.getMaskXMLByCode(tt);
    }

    public static int getDigitsByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < digitsDesc.length; ++i) {
            if (!digitsDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return StringOperationsMeta.getDigitsByCode(tt);
    }

    public static int getRemoveSpecialCharactersByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < removeSpecialCharactersDesc.length; ++i) {
            if (!removeSpecialCharactersDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return StringOperationsMeta.getRemoveSpecialCharactersByCode(tt);
    }

    public static int getPaddingByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < paddingDesc.length; ++i) {
            if (!paddingDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return StringOperationsMeta.getPaddingByCode(tt);
    }
}

