/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.janino;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.janino.ExpressionEvaluator;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.janino.JaninoData;
import org.pentaho.di.trans.steps.janino.JaninoMeta;
import org.pentaho.di.trans.steps.janino.JaninoMetaFunction;

public class Janino
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = JaninoMeta.class;
    private JaninoMeta meta;
    private JaninoData data;

    public Janino(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (JaninoMeta)smi;
        this.data = (JaninoData)sdi;
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            this.data.outputRowMeta = this.getInputRowMeta().clone();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
            this.data.replaceIndex = new int[this.meta.getFormula().length];
            this.data.returnType = new ValueMetaInterface[this.meta.getFormula().length];
            for (int i = 0; i < this.meta.getFormula().length; ++i) {
                JaninoMetaFunction fn = this.meta.getFormula()[i];
                this.data.returnType[i] = ValueMetaFactory.createValueMeta((int)fn.getValueType());
                if (!Utils.isEmpty((CharSequence)fn.getReplaceField())) {
                    this.data.replaceIndex[i] = this.getInputRowMeta().indexOfValue(fn.getReplaceField());
                    if (this.data.replaceIndex[i] >= 0) continue;
                    throw new KettleException("Unknown field specified to replace with a formula result: [" + fn.getReplaceField() + "]");
                }
                this.data.replaceIndex[i] = -1;
            }
        }
        if (this.log.isRowLevel()) {
            this.logRowlevel("Read row #" + this.getLinesRead() + " : " + this.getInputRowMeta().getString(r));
        }
        try {
            Object[] outputRowData = this.calcFields(this.getInputRowMeta(), r);
            this.putRow(this.data.outputRowMeta, outputRowData);
            if (this.log.isRowLevel()) {
                this.logRowlevel("Wrote row #" + this.getLinesWritten() + " : " + this.data.outputRowMeta.getString(outputRowData));
            }
        }
        catch (Exception e) {
            if (this.getStepMeta().isDoingErrorHandling()) {
                this.putError(this.getInputRowMeta(), r, 1L, e.toString(), null, "UJE001");
            }
            throw new KettleException((Throwable)e);
        }
        if (this.checkFeedback(this.getLinesRead())) {
            this.logBasic("Linenr " + this.getLinesRead());
        }
        return true;
    }

    private Object[] calcFields(RowMetaInterface rowMeta, Object[] r) throws KettleValueException {
        try {
            ValueMetaInterface valueMeta;
            int i;
            Object[] outputRowData = RowDataUtil.createResizedCopy((Object[])r, (int)this.data.outputRowMeta.size());
            int tempIndex = rowMeta.size();
            if (this.data.expressionEvaluators == null) {
                List<Object> argIndexes;
                this.data.expressionEvaluators = new ExpressionEvaluator[this.meta.getFormula().length];
                this.data.argumentIndexes = new ArrayList<List<Integer>>();
                for (i = 0; i < this.meta.getFormula().length; ++i) {
                    argIndexes = new ArrayList();
                    this.data.argumentIndexes.add(argIndexes);
                }
                for (int m = 0; m < this.meta.getFormula().length; ++m) {
                    argIndexes = this.data.argumentIndexes.get(m);
                    ArrayList<String> parameterNames = new ArrayList<String>();
                    ArrayList<Class> parameterTypes = new ArrayList<Class>();
                    for (int i2 = 0; i2 < this.data.outputRowMeta.size(); ++i2) {
                        valueMeta = this.data.outputRowMeta.getValueMeta(i2);
                        if (!this.meta.getFormula()[m].getFormula().contains(valueMeta.getName())) continue;
                        argIndexes.add(i2);
                        parameterTypes.add(valueMeta.getNativeDataTypeClass());
                        parameterNames.add(valueMeta.getName());
                    }
                    JaninoMetaFunction fn = this.meta.getFormula()[m];
                    if (Utils.isEmpty((CharSequence)fn.getFieldName())) {
                        throw new KettleException("Unable to find field name for formula [" + Const.NVL((String)fn.getFormula(), (String)"") + "]");
                    }
                    this.data.expressionEvaluators[m] = new ExpressionEvaluator();
                    this.data.expressionEvaluators[m].setParameters(parameterNames.toArray(new String[parameterNames.size()]), parameterTypes.toArray(new Class[parameterTypes.size()]));
                    this.data.expressionEvaluators[m].setReturnType(Object.class);
                    this.data.expressionEvaluators[m].setThrownExceptions(new Class[]{Exception.class});
                    this.data.expressionEvaluators[m].cook(fn.getFormula());
                }
            }
            for (i = 0; i < this.meta.getFormula().length; ++i) {
                List<Integer> argumentIndexes = this.data.argumentIndexes.get(i);
                Object[] argumentData = new Object[argumentIndexes.size()];
                for (int x = 0; x < argumentIndexes.size(); ++x) {
                    int index = argumentIndexes.get(x);
                    ValueMetaInterface outputValueMeta = this.data.outputRowMeta.getValueMeta(index);
                    argumentData[x] = outputValueMeta.convertToNormalStorageType(outputRowData[index]);
                }
                Object formulaResult = this.data.expressionEvaluators[i].evaluate(argumentData);
                Object value = null;
                if (formulaResult == null) {
                    value = null;
                } else {
                    valueMeta = this.data.returnType[i];
                    if (valueMeta.getNativeDataTypeClass().isAssignableFrom(formulaResult.getClass())) {
                        value = formulaResult;
                    } else if (formulaResult instanceof Integer && valueMeta.getType() == 5) {
                        value = ((Integer)formulaResult).longValue();
                    } else {
                        throw new KettleValueException(BaseMessages.getString(PKG, (String)"Janino.Error.ValueTypeMismatch", (Object[])new Object[]{valueMeta.getTypeDesc(), this.meta.getFormula()[i].getFieldName(), formulaResult.getClass(), this.meta.getFormula()[i].getFormula()}));
                    }
                }
                if (this.data.replaceIndex[i] < 0) {
                    outputRowData[tempIndex++] = value;
                    continue;
                }
                outputRowData[this.data.replaceIndex[i]] = value;
            }
            return outputRowData;
        }
        catch (Exception e) {
            throw new KettleValueException((Throwable)e);
        }
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (JaninoMeta)smi;
        this.data = (JaninoData)sdi;
        return super.init(smi, sdi);
    }
}

