/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.ifnull;

import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.injection.Injection;
import org.pentaho.di.core.injection.InjectionDeep;
import org.pentaho.di.core.injection.InjectionSupported;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.ifnull.IfNull;
import org.pentaho.di.trans.steps.ifnull.IfNullData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

@InjectionSupported(localizationPrefix="IfNull.Injection.", groups={"FIELDS", "VALUE_TYPES"})
public class IfNullMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = IfNullMeta.class;
    @InjectionDeep
    private Fields[] fields;
    @InjectionDeep
    private ValueTypes[] valueTypes;
    @Injection(name="SELECT_FIELDS")
    private boolean selectFields;
    @Injection(name="SELECT_VALUES_TYPE")
    private boolean selectValuesType;
    @Injection(name="REPLACE_ALL_BY_VALUE")
    private String replaceAllByValue;
    @Injection(name="REPLACE_ALL_MASK")
    private String replaceAllMask;
    @Injection(name="SET_EMPTY_STRING_ALL")
    private boolean setEmptyStringAll;

    public boolean isSetEmptyStringAll() {
        return this.setEmptyStringAll;
    }

    public void setEmptyStringAll(boolean setEmptyStringAll) {
        this.setEmptyStringAll = setEmptyStringAll;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode, databases);
    }

    @Override
    public Object clone() {
        int i;
        IfNullMeta retval = (IfNullMeta)super.clone();
        int nrTypes = this.valueTypes.length;
        int nrfields = this.fields.length;
        retval.allocate(nrTypes, nrfields);
        for (i = 0; i < nrTypes; ++i) {
            retval.getValueTypes()[i] = this.valueTypes[i].clone();
        }
        for (i = 0; i < nrfields; ++i) {
            retval.getFields()[i] = this.fields[i].clone();
        }
        return retval;
    }

    public void allocate(int nrtypes, int nrfields) {
        int i;
        this.valueTypes = new ValueTypes[nrtypes];
        for (i = 0; i < nrtypes; ++i) {
            this.valueTypes[i] = new ValueTypes();
        }
        this.fields = new Fields[nrfields];
        for (i = 0; i < nrfields; ++i) {
            this.fields[i] = new Fields();
        }
    }

    public boolean isSelectFields() {
        return this.selectFields;
    }

    public void setSelectFields(boolean selectFields) {
        this.selectFields = selectFields;
    }

    public void setSelectValuesType(boolean selectValuesType) {
        this.selectValuesType = selectValuesType;
    }

    public boolean isSelectValuesType() {
        return this.selectValuesType;
    }

    public void setReplaceAllByValue(String replaceValue) {
        this.replaceAllByValue = replaceValue;
    }

    public String getReplaceAllByValue() {
        return this.replaceAllByValue;
    }

    public void setReplaceAllMask(String replaceAllMask) {
        this.replaceAllMask = replaceAllMask;
    }

    public String getReplaceAllMask() {
        return this.replaceAllMask;
    }

    public Fields[] getFields() {
        return this.fields;
    }

    public void setFields(Fields[] fields) {
        this.fields = fields;
    }

    public ValueTypes[] getValueTypes() {
        return this.valueTypes;
    }

    public void setValueTypes(ValueTypes[] valueTypes) {
        this.valueTypes = valueTypes;
    }

    private void readData(Node stepnode, List<? extends SharedObjectInterface> databases) throws KettleXMLException {
        try {
            int i;
            this.selectFields = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"selectFields"));
            this.selectValuesType = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"selectValuesType"));
            this.replaceAllByValue = XMLHandler.getTagValue((Node)stepnode, (String)"replaceAllByValue");
            this.replaceAllMask = XMLHandler.getTagValue((Node)stepnode, (String)"replaceAllMask");
            String setEmptyStringAllString = XMLHandler.getTagValue((Node)stepnode, (String)"setEmptyStringAll");
            this.setEmptyStringAll = !Utils.isEmpty((CharSequence)setEmptyStringAllString) && "Y".equalsIgnoreCase(setEmptyStringAllString);
            Node types = XMLHandler.getSubNode((Node)stepnode, (String)"valuetypes");
            int nrtypes = XMLHandler.countNodes((Node)types, (String)"valuetype");
            Node fieldNodes = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int nrfields = XMLHandler.countNodes((Node)fieldNodes, (String)"field");
            this.allocate(nrtypes, nrfields);
            for (i = 0; i < nrtypes; ++i) {
                Node tnode = XMLHandler.getSubNodeByNr((Node)types, (String)"valuetype", (int)i);
                this.valueTypes[i].setTypeName(XMLHandler.getTagValue((Node)tnode, (String)"name"));
                this.valueTypes[i].setTypereplaceValue(XMLHandler.getTagValue((Node)tnode, (String)"value"));
                this.valueTypes[i].setTypereplaceMask(XMLHandler.getTagValue((Node)tnode, (String)"mask"));
                String typeemptyString = XMLHandler.getTagValue((Node)tnode, (String)"set_type_empty_string");
                this.valueTypes[i].setTypeEmptyString(!Utils.isEmpty((CharSequence)typeemptyString) && "Y".equalsIgnoreCase(typeemptyString));
            }
            for (i = 0; i < nrfields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fieldNodes, (String)"field", (int)i);
                this.fields[i].setFieldName(XMLHandler.getTagValue((Node)fnode, (String)"name"));
                this.fields[i].setReplaceValue(XMLHandler.getTagValue((Node)fnode, (String)"value"));
                this.fields[i].setReplaceMask(XMLHandler.getTagValue((Node)fnode, (String)"mask"));
                String emptyString = XMLHandler.getTagValue((Node)fnode, (String)"set_empty_string");
                this.fields[i].setEmptyString(!Utils.isEmpty((CharSequence)emptyString) && "Y".equalsIgnoreCase(emptyString));
            }
        }
        catch (Exception e) {
            throw new KettleXMLException("It was not possibke to load the IfNull metadata from XML", (Throwable)e);
        }
    }

    @Override
    public String getXML() {
        int i;
        StringBuilder retval = new StringBuilder();
        retval.append("      " + XMLHandler.addTagValue((String)"replaceAllByValue", (String)this.replaceAllByValue));
        retval.append("      " + XMLHandler.addTagValue((String)"replaceAllMask", (String)this.replaceAllMask));
        retval.append("      " + XMLHandler.addTagValue((String)"selectFields", (boolean)this.selectFields));
        retval.append("      " + XMLHandler.addTagValue((String)"selectValuesType", (boolean)this.selectValuesType));
        retval.append("      " + XMLHandler.addTagValue((String)"setEmptyStringAll", (boolean)this.setEmptyStringAll));
        retval.append("    <valuetypes>" + Const.CR);
        for (i = 0; i < this.valueTypes.length; ++i) {
            retval.append("      <valuetype>" + Const.CR);
            retval.append("        " + XMLHandler.addTagValue((String)"name", (String)this.valueTypes[i].getTypeName()));
            retval.append("        " + XMLHandler.addTagValue((String)"value", (String)this.valueTypes[i].getTypereplaceValue()));
            retval.append("        " + XMLHandler.addTagValue((String)"mask", (String)this.valueTypes[i].getTypereplaceMask()));
            retval.append("        " + XMLHandler.addTagValue((String)"set_type_empty_string", (boolean)this.valueTypes[i].isSetTypeEmptyString()));
            retval.append("        </valuetype>" + Const.CR);
        }
        retval.append("      </valuetypes>" + Const.CR);
        retval.append("    <fields>" + Const.CR);
        for (i = 0; i < this.fields.length; ++i) {
            retval.append("      <field>" + Const.CR);
            retval.append("        " + XMLHandler.addTagValue((String)"name", (String)this.fields[i].getFieldName()));
            retval.append("        " + XMLHandler.addTagValue((String)"value", (String)this.fields[i].getReplaceValue()));
            retval.append("        " + XMLHandler.addTagValue((String)"mask", (String)this.fields[i].getReplaceMask()));
            retval.append("        " + XMLHandler.addTagValue((String)"set_empty_string", (boolean)this.fields[i].isSetEmptyString()));
            retval.append("        </field>" + Const.CR);
        }
        retval.append("      </fields>" + Const.CR);
        return retval.toString();
    }

    @Override
    public void setDefault() {
        this.replaceAllByValue = null;
        this.replaceAllMask = null;
        this.selectFields = false;
        this.selectValuesType = false;
        this.setEmptyStringAll = false;
        int nrfields = 0;
        int nrtypes = 0;
        this.allocate(nrtypes, nrfields);
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            int i;
            this.replaceAllByValue = rep.getStepAttributeString(id_step, "replaceAllByValue");
            this.replaceAllMask = rep.getStepAttributeString(id_step, "replaceAllMask");
            this.selectFields = rep.getStepAttributeBoolean(id_step, "selectFields");
            this.selectValuesType = rep.getStepAttributeBoolean(id_step, "selectValuesType");
            this.setEmptyStringAll = rep.getStepAttributeBoolean(id_step, 0, "setEmptyStringAll", false);
            int nrtypes = rep.countNrStepAttributes(id_step, "type_name");
            int nrfields = rep.countNrStepAttributes(id_step, "field_name");
            this.allocate(nrtypes, nrfields);
            for (i = 0; i < nrtypes; ++i) {
                this.valueTypes[i].setTypeName(rep.getStepAttributeString(id_step, i, "type_name"));
                this.valueTypes[i].setTypereplaceValue(rep.getStepAttributeString(id_step, i, "type_replace_value"));
                this.valueTypes[i].setTypereplaceMask(rep.getStepAttributeString(id_step, i, "type_replace_mask"));
                this.valueTypes[i].setTypeEmptyString(rep.getStepAttributeBoolean(id_step, i, "set_type_empty_string", false));
            }
            for (i = 0; i < nrfields; ++i) {
                this.fields[i].setFieldName(rep.getStepAttributeString(id_step, i, "field_name"));
                this.fields[i].setReplaceValue(rep.getStepAttributeString(id_step, i, "replace_value"));
                this.fields[i].setReplaceMask(rep.getStepAttributeString(id_step, i, "replace_mask"));
                this.fields[i].setEmptyString(rep.getStepAttributeBoolean(id_step, i, "set_empty_string", false));
            }
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            int i;
            rep.saveStepAttribute(id_transformation, id_step, "replaceAllByValue", this.replaceAllByValue);
            rep.saveStepAttribute(id_transformation, id_step, "replaceAllMask", this.replaceAllMask);
            rep.saveStepAttribute(id_transformation, id_step, "selectFields", this.selectFields);
            rep.saveStepAttribute(id_transformation, id_step, "selectValuesType", this.selectValuesType);
            rep.saveStepAttribute(id_transformation, id_step, "setEmptyStringAll", this.setEmptyStringAll);
            for (i = 0; i < this.valueTypes.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "type_name", this.valueTypes[i].getTypeName());
                rep.saveStepAttribute(id_transformation, id_step, i, "type_replace_value", this.valueTypes[i].getTypereplaceValue());
                rep.saveStepAttribute(id_transformation, id_step, i, "type_replace_mask", this.valueTypes[i].getTypereplaceMask());
                rep.saveStepAttribute(id_transformation, id_step, i, "set_type_empty_string", this.valueTypes[i].isSetTypeEmptyString());
            }
            for (i = 0; i < this.fields.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "field_name", this.fields[i].getFieldName());
                rep.saveStepAttribute(id_transformation, id_step, i, "replace_value", this.fields[i].getReplaceValue());
                rep.saveStepAttribute(id_transformation, id_step, i, "replace_mask", this.fields[i].getReplaceMask());
                rep.saveStepAttribute(id_transformation, id_step, i, "set_empty_string", this.fields[i].isSetEmptyString());
            }
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for id_step=" + id_step, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr;
        if (prev == null || prev.size() == 0) {
            cr = new CheckResult(3, BaseMessages.getString(PKG, (String)"IfNullMeta.CheckResult.NotReceivingFields", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"IfNullMeta.CheckResult.StepRecevingData", (String[])new String[]{prev.size() + ""}), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
            String error_message = "";
            boolean error_found = false;
            for (int i = 0; i < this.fields.length; ++i) {
                int idx = prev.indexOfValue(this.fields[i].getFieldName());
                if (idx >= 0) continue;
                error_message = error_message + "\t\t" + this.fields[i].getFieldName() + Const.CR;
                error_found = true;
            }
            if (error_found) {
                error_message = BaseMessages.getString(PKG, (String)"IfNullMeta.CheckResult.FieldsFound", (String[])new String[]{error_message});
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            } else if (this.fields.length > 0) {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"IfNullMeta.CheckResult.AllFieldsFound", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            } else {
                cr = new CheckResult(3, BaseMessages.getString(PKG, (String)"IfNullMeta.CheckResult.NoFieldsEntered", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"IfNullMeta.CheckResult.StepRecevingData2", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"IfNullMeta.CheckResult.NoInputReceivedFromOtherSteps", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new IfNull(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new IfNullData();
    }

    @Override
    public boolean supportsErrorHandling() {
        return true;
    }

    public static class ValueTypes
    implements Cloneable {
        @Injection(name="TYPE_NAME", group="VALUE_TYPES")
        private String typeName;
        @Injection(name="TYPE_REPLACE_VALUE", group="VALUE_TYPES")
        private String typereplaceValue;
        @Injection(name="TYPE_REPLACE_MASK", group="VALUE_TYPES")
        private String typereplaceMask;
        @Injection(name="SET_TYPE_EMPTY_STRING", group="VALUE_TYPES")
        private boolean setTypeEmptyString;

        public String getTypeName() {
            return this.typeName;
        }

        public void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        public String getTypereplaceValue() {
            return this.typereplaceValue;
        }

        public void setTypereplaceValue(String typereplaceValue) {
            this.typereplaceValue = typereplaceValue;
        }

        public String getTypereplaceMask() {
            return this.typereplaceMask;
        }

        public void setTypereplaceMask(String typereplaceMask) {
            this.typereplaceMask = typereplaceMask;
        }

        public boolean isSetTypeEmptyString() {
            return this.setTypeEmptyString;
        }

        public void setTypeEmptyString(boolean setTypeEmptyString) {
            this.setTypeEmptyString = setTypeEmptyString;
        }

        public ValueTypes clone() {
            try {
                return (ValueTypes)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class Fields
    implements Cloneable {
        @Injection(name="FIELD_NAME", group="FIELDS")
        private String fieldName;
        @Injection(name="REPLACE_VALUE", group="FIELDS")
        private String replaceValue;
        @Injection(name="REPLACE_MASK", group="FIELDS")
        private String replaceMask;
        @Injection(name="SET_EMPTY_STRING", group="FIELDS")
        private boolean setEmptyString;

        public String getFieldName() {
            return this.fieldName;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public String getReplaceValue() {
            return this.replaceValue;
        }

        public void setReplaceValue(String replaceValue) {
            this.replaceValue = replaceValue;
        }

        public String getReplaceMask() {
            return this.replaceMask;
        }

        public void setReplaceMask(String replaceMask) {
            this.replaceMask = replaceMask;
        }

        public boolean isSetEmptyString() {
            return this.setEmptyString;
        }

        public void setEmptyString(boolean setEmptyString) {
            this.setEmptyString = setEmptyString;
        }

        public Fields clone() {
            try {
                return (Fields)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

