/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.shared;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.pentaho.di.cluster.ClusterSchema;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.partition.PartitionSchema;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SharedObjects {
    private static Class<?> PKG = SharedObjects.class;
    private static final String XML_TAG = "sharedobjects";
    private String filename;
    private Map<SharedEntry, SharedObjectInterface> objectsMap;

    public SharedObjects(String sharedObjectsFile) throws KettleXMLException {
        try {
            Document document;
            Node sharedObjectsNode;
            this.filename = SharedObjects.createFilename(sharedObjectsFile);
            this.objectsMap = new Hashtable<SharedEntry, SharedObjectInterface>();
            LogChannel log = new LogChannel((Object)this);
            FileObject file = this.getFileObjectFromKettleVFS(this.filename);
            if (file.exists() && (sharedObjectsNode = XMLHandler.getSubNode((Node)(document = XMLHandler.loadXMLFile((FileObject)file)), (String)XML_TAG)) != null) {
                Object isShared;
                String nodeName;
                Node node;
                int i;
                ArrayList<SlaveServer> privateSlaveServers = new ArrayList<SlaveServer>();
                ArrayList<DatabaseMeta> privateDatabases = new ArrayList<DatabaseMeta>();
                NodeList childNodes = sharedObjectsNode.getChildNodes();
                for (i = 0; i < childNodes.getLength(); ++i) {
                    node = childNodes.item(i);
                    nodeName = node.getNodeName();
                    isShared = null;
                    if (nodeName.equals("connection")) {
                        try {
                            DatabaseMeta sharedDatabaseMeta;
                            isShared = sharedDatabaseMeta = new DatabaseMeta(node);
                            privateDatabases.add(sharedDatabaseMeta);
                        }
                        catch (KettleXMLException kxe) {
                            Throwable firstCause = kxe.getCause();
                            if (firstCause != null) {
                                Throwable secondCause = firstCause.getCause();
                                if (secondCause == null || !(secondCause instanceof KettleDatabaseException)) {
                                    throw kxe;
                                }
                                log.logBasic(kxe.getLocalizedMessage());
                            }
                            throw kxe;
                        }
                    } else if (nodeName.equals("slaveserver")) {
                        SlaveServer sharedSlaveServer = new SlaveServer(node);
                        isShared = sharedSlaveServer;
                        privateSlaveServers.add(sharedSlaveServer);
                    }
                    if (isShared == null) continue;
                    isShared.setShared(true);
                    this.storeObject((SharedObjectInterface)isShared);
                }
                for (i = 0; i < childNodes.getLength(); ++i) {
                    node = childNodes.item(i);
                    nodeName = node.getNodeName();
                    isShared = null;
                    if (nodeName.equals("step")) {
                        StepMeta stepMeta = new StepMeta(node, privateDatabases, (IMetaStore)null);
                        stepMeta.setDraw(false);
                        isShared = stepMeta;
                    } else if (nodeName.equals("partitionschema")) {
                        isShared = new PartitionSchema(node);
                    } else if (nodeName.equals("clusterschema")) {
                        isShared = new ClusterSchema(node, privateSlaveServers);
                    }
                    if (isShared == null) continue;
                    isShared.setShared(true);
                    this.storeObject((SharedObjectInterface)isShared);
                }
            }
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"SharedOjects.Readingfile.UnexpectedError", (String[])new String[]{sharedObjectsFile}), (Throwable)e);
        }
    }

    public static final String createFilename(String sharedObjectsFile) {
        String filename;
        if (Utils.isEmpty((CharSequence)sharedObjectsFile)) {
            filename = Variables.getADefaultVariableSpace().getVariable("KETTLE_SHARED_OBJECTS");
            if (Utils.isEmpty((CharSequence)filename)) {
                filename = Const.getSharedObjectsFile();
            }
        } else {
            filename = sharedObjectsFile;
        }
        return filename;
    }

    public SharedObjects() throws KettleXMLException {
        this(null);
    }

    public Map<SharedEntry, SharedObjectInterface> getObjectsMap() {
        return this.objectsMap;
    }

    public void setObjectsMap(Map<SharedEntry, SharedObjectInterface> objects) {
        this.objectsMap = objects;
    }

    public void storeObject(SharedObjectInterface sharedObject) {
        SharedEntry key = new SharedEntry(sharedObject.getClass().getName(), sharedObject.getName());
        this.objectsMap.put(key, sharedObject);
    }

    public void removeObject(SharedObjectInterface sharedObject) {
        SharedEntry key = new SharedEntry(sharedObject.getClass().getName(), sharedObject.getName());
        this.objectsMap.remove(key);
    }

    public void saveToFile() throws IOException, KettleException {
        FileObject fileObject = this.getFileObjectFromKettleVFS(this.filename);
        String backupFileName = this.createOrGetFileBackup(fileObject);
        this.writeToFile(fileObject, backupFileName);
    }

    public SharedObjectInterface getSharedObject(Class<SharedObjectInterface> clazz, String objectName) {
        return this.getSharedObject(clazz.getName(), objectName);
    }

    public SharedObjectInterface getSharedObject(String className, String objectName) {
        SharedEntry entry = new SharedEntry(className, objectName);
        return this.objectsMap.get(entry);
    }

    public DatabaseMeta getSharedDatabase(String name) {
        return (DatabaseMeta)this.getSharedObject(DatabaseMeta.class.getName(), name);
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    @VisibleForTesting
    protected void writeToFile(FileObject fileObject, String backupFileName) throws IOException, KettleException {
        OutputStream outputStream = null;
        PrintStream out = null;
        try {
            outputStream = this.initOutputStreamUsingKettleVFS(fileObject);
            out = new PrintStream(outputStream);
            out.print(XMLHandler.getXMLHeader((String)"UTF-8"));
            out.println("<sharedobjects>");
            Collection<SharedObjectInterface> collection = this.objectsMap.values();
            for (SharedObjectInterface sharedObject : collection) {
                String xmlContent = sharedObject.getXML();
                out.println(xmlContent);
            }
            out.println("</sharedobjects>");
        }
        catch (Exception e) {
            boolean isRestored = false;
            if (backupFileName != null) {
                this.restoreFileFromBackup(backupFileName);
                isRestored = true;
            }
            throw new KettleException(BaseMessages.getString(PKG, (String)"SharedOjects.WriteToFile.ErrorWritingFile", (Object[])new Object[]{isRestored}), (Throwable)e);
        }
        finally {
            if (out != null) {
                out.flush();
            }
            if (out != null) {
                out.close();
            }
            if (out != null) {
                outputStream.close();
            }
        }
    }

    private FileObject getFileObjectFromKettleVFS(String filename) throws KettleFileException {
        return KettleVFS.getFileObject((String)filename);
    }

    @VisibleForTesting
    protected OutputStream initOutputStreamUsingKettleVFS(FileObject fileObject) throws IOException {
        return KettleVFS.getOutputStream((FileObject)fileObject, (boolean)false);
    }

    @VisibleForTesting
    protected void restoreFileFromBackup(String backupFileName) throws IOException, KettleFileException {
        this.copyFile(backupFileName, this.filename);
    }

    private String createOrGetFileBackup(FileObject fileObject) throws IOException, KettleException {
        String backupFileName = this.filename + ".backup";
        boolean isBackupFileExist = false;
        isBackupFileExist = fileObject.exists() ? this.createFileBackup(backupFileName) : this.getBackupFileFromFileSystem(backupFileName);
        return isBackupFileExist ? backupFileName : null;
    }

    private boolean getBackupFileFromFileSystem(String backupFileName) throws KettleException {
        FileObject fileObject = this.getFileObjectFromKettleVFS(backupFileName);
        try {
            return fileObject.exists();
        }
        catch (FileSystemException e) {
            return false;
        }
    }

    private boolean createFileBackup(String backupFileName) throws IOException, KettleFileException {
        return this.copyFile(this.filename, backupFileName);
    }

    private boolean copyFile(String src, String dest) throws KettleFileException, IOException {
        FileObject srcFile = this.getFileObjectFromKettleVFS(src);
        FileObject destFile = this.getFileObjectFromKettleVFS(dest);
        try (InputStream in = KettleVFS.getInputStream((FileObject)srcFile);
             OutputStream out = KettleVFS.getOutputStream((FileObject)destFile, (boolean)false);){
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        return true;
    }

    public String toString() {
        return this.getClass().getSimpleName() + (!Utils.isEmpty((CharSequence)this.getFilename()) ? " (" + this.getFilename() + ")" : "");
    }

    private class SharedEntry {
        public String className;
        public String objectName;

        public SharedEntry(String className, String objectName) {
            this.className = className;
            this.objectName = objectName;
        }

        public boolean equals(Object obj) {
            SharedEntry sharedEntry = (SharedEntry)obj;
            return this.className.equals(sharedEntry.className) && this.objectName.equalsIgnoreCase(this.objectName);
        }

        public int hashCode() {
            return this.className.hashCode() ^ this.objectName.hashCode();
        }
    }
}

