/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.util.serialization;

import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.pentaho.di.core.util.serialization.StepMetaProps;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.core.xml.XMLParserFactoryProducer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MetaXmlSerializer {
    private MetaXmlSerializer() {
    }

    public static String serialize(StepMetaProps stepMetaProps) {
        String string;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            Marshaller marshalObj = JAXBContext.newInstance((Class[])new Class[]{StepMetaProps.class}).createMarshaller();
            marshalObj.setProperty("jaxb.formatted.output", (Object)true);
            marshalObj.setProperty("jaxb.fragment", (Object)true);
            marshalObj.marshal((Object)stepMetaProps, (OutputStream)baos);
            string = baos.toString(StandardCharsets.UTF_8.name());
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | JAXBException e) {
                throw new RuntimeException(e);
            }
        }
        baos.close();
        return string;
    }

    public static StepMetaProps deserialize(String ser) {
        StepMetaProps stepMetaProps;
        ByteArrayInputStream bais = new ByteArrayInputStream(ser.getBytes(StandardCharsets.UTF_8));
        try {
            Unmarshaller unmarshaller = JAXBContext.newInstance((Class[])new Class[]{StepMetaProps.class}).createUnmarshaller();
            stepMetaProps = (StepMetaProps)unmarshaller.unmarshal((InputStream)bais);
        }
        catch (Throwable throwable) {
            try {
                try {
                    bais.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | JAXBException e) {
                throw new RuntimeException(e);
            }
        }
        bais.close();
        return stepMetaProps;
    }

    public static StepMetaProps deserialize(Node node) {
        return MetaXmlSerializer.deserialize(MetaXmlSerializer.nodeToString(XMLHandler.getSubNode((Node)node, (String)"step-props")));
    }

    private static String nodeToString(Node node) {
        Preconditions.checkArgument((boolean)(node instanceof Element));
        StringWriter sw = new StringWriter();
        try {
            ((Element)node).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            ((Element)node).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xs", "http://www.w3.org/2001/XMLSchema");
            XMLParserFactoryProducer.createSecureTransformerFactory().newTransformer().transform(new DOMSource(node), new StreamResult(sw));
        }
        catch (TransformerException te) {
            throw new RuntimeException(te);
        }
        return sw.toString();
    }
}

