/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.xmlns.parser;

import java.util.ArrayList;
import java.util.Properties;
import org.pentaho.reporting.libraries.xmlns.parser.AbstractXmlReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.PropertyReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class PropertiesReadHandler
extends AbstractXmlReadHandler {
    private ArrayList<PropertyReadHandler> propertyHandlers;
    private String propertyTagName;
    private Properties result;

    public PropertiesReadHandler() {
        this("property");
    }

    public PropertiesReadHandler(String propertyTagName) {
        if (propertyTagName == null) {
            throw new NullPointerException();
        }
        this.propertyHandlers = new ArrayList();
        this.propertyTagName = propertyTagName;
    }

    protected ArrayList<PropertyReadHandler> getPropertyHandlers() {
        return this.propertyHandlers;
    }

    protected String getPropertyTagName() {
        return this.propertyTagName;
    }

    @Override
    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        if (!this.isSameNamespace(uri)) {
            return null;
        }
        if (tagName.equals(this.propertyTagName)) {
            PropertyReadHandler prh = new PropertyReadHandler();
            this.propertyHandlers.add(prh);
            return prh;
        }
        return null;
    }

    @Override
    protected void doneParsing() throws SAXException {
        this.result = new Properties();
        for (int i = 0; i < this.propertyHandlers.size(); ++i) {
            PropertyReadHandler handler = this.propertyHandlers.get(i);
            this.result.setProperty(handler.getName(), handler.getResult());
        }
    }

    public Properties getResult() {
        return this.result;
    }

    @Override
    public Object getObject() throws SAXException {
        return this.result;
    }
}

