/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v25.segment.AFF;
import ca.uhn.hl7v2.model.v25.segment.CER;
import ca.uhn.hl7v2.model.v25.segment.EDU;
import ca.uhn.hl7v2.model.v25.segment.EVN;
import ca.uhn.hl7v2.model.v25.segment.LAN;
import ca.uhn.hl7v2.model.v25.segment.MSH;
import ca.uhn.hl7v2.model.v25.segment.ORG;
import ca.uhn.hl7v2.model.v25.segment.PRA;
import ca.uhn.hl7v2.model.v25.segment.SFT;
import ca.uhn.hl7v2.model.v25.segment.STF;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class PMU_B01
extends AbstractMessage {
    public PMU_B01(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    public PMU_B01() {
        super((ModelClassFactory)new DefaultModelClassFactory());
        this.init((ModelClassFactory)new DefaultModelClassFactory());
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(EVN.class, true, false);
            this.add(STF.class, true, false);
            this.add(PRA.class, false, true);
            this.add(ORG.class, false, true);
            this.add(AFF.class, false, true);
            this.add(LAN.class, false, true);
            this.add(EDU.class, false, true);
            this.add(CER.class, false, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error creating PMU_B01 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5";
    }

    public MSH getMSH() {
        MSH ret = null;
        try {
            ret = (MSH)this.get("MSH");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public SFT getSFT() {
        SFT ret = null;
        try {
            ret = (SFT)this.get("SFT");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public SFT getSFT(int rep) {
        SFT ret = null;
        try {
            ret = (SFT)this.get("SFT", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getSFTReps() {
        int reps = -1;
        try {
            reps = this.getAll("SFT").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", (Structure)structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public EVN getEVN() {
        EVN ret = null;
        try {
            ret = (EVN)this.get("EVN");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public STF getSTF() {
        STF ret = null;
        try {
            ret = (STF)this.get("STF");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PRA getPRA() {
        PRA ret = null;
        try {
            ret = (PRA)this.get("PRA");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PRA getPRA(int rep) {
        PRA ret = null;
        try {
            ret = (PRA)this.get("PRA", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getPRAReps() {
        int reps = -1;
        try {
            reps = this.getAll("PRA").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertPRA(PRA structure, int rep) throws HL7Exception {
        super.insertRepetition("PRA", (Structure)structure, rep);
    }

    public PRA insertPRA(int rep) throws HL7Exception {
        return (PRA)super.insertRepetition("PRA", rep);
    }

    public PRA removePRA(int rep) throws HL7Exception {
        return (PRA)super.removeRepetition("PRA", rep);
    }

    public ORG getORG() {
        ORG ret = null;
        try {
            ret = (ORG)this.get("ORG");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ORG getORG(int rep) {
        ORG ret = null;
        try {
            ret = (ORG)this.get("ORG", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getORGReps() {
        int reps = -1;
        try {
            reps = this.getAll("ORG").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertORG(ORG structure, int rep) throws HL7Exception {
        super.insertRepetition("ORG", (Structure)structure, rep);
    }

    public ORG insertORG(int rep) throws HL7Exception {
        return (ORG)super.insertRepetition("ORG", rep);
    }

    public ORG removeORG(int rep) throws HL7Exception {
        return (ORG)super.removeRepetition("ORG", rep);
    }

    public AFF getAFF() {
        AFF ret = null;
        try {
            ret = (AFF)this.get("AFF");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public AFF getAFF(int rep) {
        AFF ret = null;
        try {
            ret = (AFF)this.get("AFF", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getAFFReps() {
        int reps = -1;
        try {
            reps = this.getAll("AFF").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertAFF(AFF structure, int rep) throws HL7Exception {
        super.insertRepetition("AFF", (Structure)structure, rep);
    }

    public AFF insertAFF(int rep) throws HL7Exception {
        return (AFF)super.insertRepetition("AFF", rep);
    }

    public AFF removeAFF(int rep) throws HL7Exception {
        return (AFF)super.removeRepetition("AFF", rep);
    }

    public LAN getLAN() {
        LAN ret = null;
        try {
            ret = (LAN)this.get("LAN");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public LAN getLAN(int rep) {
        LAN ret = null;
        try {
            ret = (LAN)this.get("LAN", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getLANReps() {
        int reps = -1;
        try {
            reps = this.getAll("LAN").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertLAN(LAN structure, int rep) throws HL7Exception {
        super.insertRepetition("LAN", (Structure)structure, rep);
    }

    public LAN insertLAN(int rep) throws HL7Exception {
        return (LAN)super.insertRepetition("LAN", rep);
    }

    public LAN removeLAN(int rep) throws HL7Exception {
        return (LAN)super.removeRepetition("LAN", rep);
    }

    public EDU getEDU() {
        EDU ret = null;
        try {
            ret = (EDU)this.get("EDU");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public EDU getEDU(int rep) {
        EDU ret = null;
        try {
            ret = (EDU)this.get("EDU", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getEDUReps() {
        int reps = -1;
        try {
            reps = this.getAll("EDU").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertEDU(EDU structure, int rep) throws HL7Exception {
        super.insertRepetition("EDU", (Structure)structure, rep);
    }

    public EDU insertEDU(int rep) throws HL7Exception {
        return (EDU)super.insertRepetition("EDU", rep);
    }

    public EDU removeEDU(int rep) throws HL7Exception {
        return (EDU)super.removeRepetition("EDU", rep);
    }

    public CER getCER() {
        CER ret = null;
        try {
            ret = (CER)this.get("CER");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public CER getCER(int rep) {
        CER ret = null;
        try {
            ret = (CER)this.get("CER", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getCERReps() {
        int reps = -1;
        try {
            reps = this.getAll("CER").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertCER(CER structure, int rep) throws HL7Exception {
        super.insertRepetition("CER", (Structure)structure, rep);
    }

    public CER insertCER(int rep) throws HL7Exception {
        return (CER)super.insertRepetition("CER", rep);
    }

    public CER removeCER(int rep) throws HL7Exception {
        return (CER)super.removeRepetition("CER", rep);
    }
}

