/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.modules.sbarcodes;

import net.sourceforge.barbecue.Barcode;
import net.sourceforge.barbecue.BarcodeException;
import net.sourceforge.barbecue.linear.codabar.CodabarBarcode;
import net.sourceforge.barbecue.linear.code128.Code128Barcode;
import net.sourceforge.barbecue.linear.code39.Code39Barcode;
import net.sourceforge.barbecue.linear.ean.BooklandBarcode;
import net.sourceforge.barbecue.linear.ean.EAN13Barcode;
import net.sourceforge.barbecue.linear.ean.UCCEAN128Barcode;
import net.sourceforge.barbecue.linear.postnet.PostNetBarcode;
import net.sourceforge.barbecue.linear.twoOfFive.Int2of5Barcode;
import net.sourceforge.barbecue.linear.twoOfFive.Std2of5Barcode;
import net.sourceforge.barbecue.linear.upc.UPCABarcode;
import net.sourceforge.barbecue.twod.pdf417.PDF417Barcode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.krysalis.barcode4j.BarcodeGenerator;
import org.krysalis.barcode4j.ChecksumMode;
import org.krysalis.barcode4j.HumanReadablePlacement;
import org.krysalis.barcode4j.impl.code128.EAN128;
import org.krysalis.barcode4j.impl.datamatrix.DataMatrix;
import org.krysalis.barcode4j.impl.fourstate.RoyalMailCBC;
import org.krysalis.barcode4j.impl.fourstate.USPSIntelligentMail;
import org.krysalis.barcode4j.impl.upcean.EAN8;
import org.krysalis.barcode4j.impl.upcean.UPCE;
import org.krysalis.barcode4j.tools.UnitConv;

public class SimpleBarcodesUtility {
    public static final String BARCODE_CODE39 = "code39";
    public static final String BARCODE_CODE39EXT = "code39ext";
    public static final String BARCODE_CODABAR = "codabar";
    public static final String BARCODE_CODE128 = "code128";
    public static final String BARCODE_CODE128A = "code128a";
    public static final String BARCODE_CODE128B = "code128b";
    public static final String BARCODE_CODE128C = "code128c";
    public static final String BARCODE_EAN13 = "ean13";
    public static final String BARCODE_UPCA = "upca";
    public static final String BARCODE_ISBN = "isbn";
    public static final String BARCODE_UCCEAN128 = "uccean128";
    public static final String BARCODE_2OF5 = "2of5";
    public static final String BARCODE_2OF5INT = "2of5int";
    public static final String BARCODE_POSTNET = "postnet";
    public static final String BARCODE_PDF417 = "pdf417";
    public static final String BARCODE_EAN8 = "ean8";
    public static final String BARCODE_EAN128 = "ean128";
    public static final String BARCODE_UPCE = "upce";
    public static final String BARCODE_DATAMATRIX = "datamatrix";
    public static final String BARCODE_ROYALMAIL = "royalmail";
    public static final String BARCODE_USPSINTELLIGENTMAIL = "uspsintelligentmail";
    private static final Log logger = LogFactory.getLog(SimpleBarcodesUtility.class);

    private SimpleBarcodesUtility() {
    }

    public static Barcode createBarcode(String data, String type, boolean checksum) {
        if (data == null || type == null) {
            throw new IllegalArgumentException("Barcode type or data must not be null");
        }
        if (BARCODE_CODE39.equals(type)) {
            try {
                return new Code39Barcode(data, checksum, false);
            }
            catch (BarcodeException e) {
                logger.error((Object)"Wrong code39(ext) data supplied", (Throwable)e);
                return null;
            }
        }
        if (BARCODE_CODE39EXT.equals(type)) {
            try {
                return new Code39Barcode(data, checksum, true);
            }
            catch (BarcodeException e) {
                logger.error((Object)"Wrong code39(ext) data supplied", (Throwable)e);
                return null;
            }
        }
        if (BARCODE_CODABAR.equals(type)) {
            try {
                return new CodabarBarcode(data);
            }
            catch (BarcodeException e) {
                logger.error((Object)"Wrong codabar data supplied", (Throwable)e);
                return null;
            }
        }
        if (BARCODE_EAN13.equals(type)) {
            try {
                return new EAN13Barcode(data);
            }
            catch (BarcodeException e) {
                logger.error((Object)"Wrong ean13 data supplied", (Throwable)e);
                return null;
            }
        }
        if (BARCODE_UPCA.equals(type)) {
            try {
                return new UPCABarcode(data, false);
            }
            catch (BarcodeException e) {
                logger.error((Object)"Wrong upca data supplied", (Throwable)e);
                return null;
            }
        }
        if (BARCODE_ISBN.equals(type)) {
            try {
                return new BooklandBarcode(data);
            }
            catch (BarcodeException e) {
                logger.error((Object)"Wrong isbn data supplied", (Throwable)e);
                return null;
            }
        }
        if (BARCODE_CODE128.equals(type)) {
            try {
                return new Code128Barcode(data, 3);
            }
            catch (BarcodeException e) {
                logger.error((Object)"Wrong code128 data supplied", (Throwable)e);
                return null;
            }
        }
        if (BARCODE_CODE128A.equals(type)) {
            try {
                return new Code128Barcode(data, 0);
            }
            catch (BarcodeException e) {
                logger.error((Object)"Wrong code128 data supplied", (Throwable)e);
                return null;
            }
        }
        if (BARCODE_CODE128B.equals(type)) {
            try {
                return new Code128Barcode(data, 1);
            }
            catch (BarcodeException e) {
                logger.error((Object)"Wrong code128 data supplied", (Throwable)e);
                return null;
            }
        }
        if (BARCODE_CODE128C.equals(type)) {
            try {
                return new Code128Barcode(data, 2);
            }
            catch (BarcodeException e) {
                logger.error((Object)"Wrong code128 data supplied", (Throwable)e);
                return null;
            }
        }
        if (BARCODE_UCCEAN128.equals(type)) {
            try {
                return new UCCEAN128Barcode(data, checksum);
            }
            catch (BarcodeException e) {
                logger.error((Object)"Wrong uccean128 data supplied", (Throwable)e);
                return null;
            }
        }
        if (BARCODE_2OF5.equals(type)) {
            try {
                return new Std2of5Barcode(data, checksum);
            }
            catch (BarcodeException e) {
                logger.error((Object)"Wrong std2of5 data supplied", (Throwable)e);
                return null;
            }
        }
        if (BARCODE_2OF5INT.equals(type)) {
            try {
                return new Int2of5Barcode(data, checksum);
            }
            catch (BarcodeException e) {
                logger.error((Object)"Wrong int2of5 data supplied", (Throwable)e);
                return null;
            }
        }
        if (BARCODE_POSTNET.equals(type)) {
            try {
                if (checksum) {
                    logger.info((Object)("Checkum property is not usable on barcode " + type));
                }
                return new PostNetBarcode(data);
            }
            catch (BarcodeException e) {
                logger.error((Object)"Wrong postnet data supplied", (Throwable)e);
                return null;
            }
        }
        if (BARCODE_PDF417.equals(type)) {
            try {
                return new PDF417Barcode(data);
            }
            catch (BarcodeException e) {
                logger.error((Object)"Wrong postnet data supplied", (Throwable)e);
                return null;
            }
        }
        logger.warn((Object)("Unknown barcode type '" + type + "'."));
        return null;
    }

    public static BarcodeGenerator createBarcode4J(String type, boolean showText, boolean checksum, Number barHeight) {
        if (BARCODE_DATAMATRIX.equals(type)) {
            DataMatrix dataMatrix = new DataMatrix();
            return dataMatrix;
        }
        if (BARCODE_EAN8.equals(type)) {
            EAN8 dataMatrix = new EAN8();
            if (!showText) {
                dataMatrix.getUPCEANBean().setMsgPosition(HumanReadablePlacement.HRP_NONE);
            }
            if (barHeight != null) {
                dataMatrix.getUPCEANBean().setBarHeight(UnitConv.pt2mm((double)barHeight.doubleValue()));
            }
            dataMatrix.getUPCEANBean().setChecksumMode(checksum ? ChecksumMode.CP_AUTO : ChecksumMode.CP_IGNORE);
            return dataMatrix;
        }
        if (BARCODE_EAN128.equals(type)) {
            EAN128 dataMatrix = new EAN128();
            if (!showText) {
                dataMatrix.getEAN128Bean().setMsgPosition(HumanReadablePlacement.HRP_NONE);
            }
            if (barHeight != null) {
                dataMatrix.getEAN128Bean().setBarHeight(UnitConv.pt2mm((double)barHeight.doubleValue()));
            }
            dataMatrix.getEAN128Bean().setChecksumMode(checksum ? ChecksumMode.CP_AUTO : ChecksumMode.CP_IGNORE);
            return dataMatrix;
        }
        if (BARCODE_UPCE.equals(type)) {
            UPCE dataMatrix = new UPCE();
            if (!showText) {
                dataMatrix.getUPCEANBean().setMsgPosition(HumanReadablePlacement.HRP_NONE);
            }
            if (barHeight != null) {
                dataMatrix.getUPCEANBean().setBarHeight(UnitConv.pt2mm((double)barHeight.doubleValue()));
            }
            dataMatrix.getUPCEANBean().setChecksumMode(checksum ? ChecksumMode.CP_AUTO : ChecksumMode.CP_IGNORE);
            return dataMatrix;
        }
        if (BARCODE_ROYALMAIL.equals(type)) {
            RoyalMailCBC dataMatrix = new RoyalMailCBC();
            if (!showText) {
                dataMatrix.getRoyalMailCBCBean().setMsgPosition(HumanReadablePlacement.HRP_NONE);
            }
            if (barHeight != null) {
                dataMatrix.getRoyalMailCBCBean().setBarHeight(UnitConv.pt2mm((double)barHeight.doubleValue()));
            }
            dataMatrix.getRoyalMailCBCBean().setChecksumMode(checksum ? ChecksumMode.CP_AUTO : ChecksumMode.CP_IGNORE);
            return dataMatrix;
        }
        if (BARCODE_USPSINTELLIGENTMAIL.equals(type)) {
            USPSIntelligentMail dataMatrix = new USPSIntelligentMail();
            if (!showText) {
                dataMatrix.getUSPSIntelligentMailBean().setMsgPosition(HumanReadablePlacement.HRP_NONE);
            }
            if (barHeight != null) {
                dataMatrix.getUSPSIntelligentMailBean().setBarHeight(UnitConv.pt2mm((double)barHeight.doubleValue()));
            }
            dataMatrix.getUSPSIntelligentMailBean().setChecksumMode(checksum ? ChecksumMode.CP_AUTO : ChecksumMode.CP_IGNORE);
            return dataMatrix;
        }
        return null;
    }

    public static String getBarcodeSampleData(String type) {
        if (BARCODE_DATAMATRIX.equals(type)) {
            return "barcode";
        }
        if (BARCODE_EAN8.equals(type)) {
            return "01234565";
        }
        if (BARCODE_EAN13.equals(type)) {
            return "012345678912";
        }
        if (BARCODE_ISBN.equals(type)) {
            return "0123456789";
        }
        if (BARCODE_EAN128.equals(type)) {
            return "barcode";
        }
        if (BARCODE_UPCE.equals(type)) {
            return "0425261";
        }
        if (BARCODE_UPCA.equals(type)) {
            return "42526112345";
        }
        if (BARCODE_ROYALMAIL.equals(type)) {
            return "B31HQ1A";
        }
        if (BARCODE_USPSINTELLIGENTMAIL.equals(type)) {
            return "0123456709498765432101234567891";
        }
        return "12345678";
    }
}

