/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.modules.mailer.parser;

import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.xmlns.parser.AbstractXmlReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ReportReadHandler
extends AbstractXmlReadHandler {
    private String targetType;
    private MasterReport report;

    protected void startParsing(Attributes attrs) throws SAXException {
        this.targetType = attrs.getValue(this.getUri(), "target-type");
        if (this.targetType == null) {
            throw new ParseException("Mandatory attribute 'target-type' is missing.", this.getLocator());
        }
        String href = attrs.getValue(this.getUri(), "href");
        if (href == null) {
            throw new ParseException("Mandatory attribute 'href' is missing.", this.getLocator());
        }
        try {
            ResourceManager resourceManager = this.getRootHandler().getResourceManager();
            ResourceKey key = resourceManager.deriveKey(this.getRootHandler().getSource(), href);
            Resource resource = resourceManager.create(key, null, MasterReport.class);
            this.report = (MasterReport)resource.getResource();
        }
        catch (ResourceException re) {
            throw new ParseException("Mandatory attribute 'href' is not pointing to a valid report.", (Exception)((Object)re), this.getLocator());
        }
    }

    public String getTargetType() {
        return this.targetType;
    }

    public MasterReport getReport() {
        return this.report;
    }

    public Object getObject() throws SAXException {
        return null;
    }
}

