/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.modules.mailer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import javax.mail.Authenticator;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.CompoundDataFactory;
import org.pentaho.reporting.engine.classic.core.DefaultReportEnvironment;
import org.pentaho.reporting.engine.classic.core.DefaultResourceBundleFactory;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportEnvironment;
import org.pentaho.reporting.engine.classic.core.ResourceBundleFactory;
import org.pentaho.reporting.engine.classic.core.metadata.ReportProcessTaskRegistry;
import org.pentaho.reporting.engine.classic.core.parameters.DefaultParameterDefinition;
import org.pentaho.reporting.engine.classic.core.parameters.ReportParameterDefinition;
import org.pentaho.reporting.engine.classic.core.util.ReportParameterValues;
import org.pentaho.reporting.engine.classic.extensions.modules.mailer.DefaultAuthenticator;
import org.pentaho.reporting.engine.classic.extensions.modules.mailer.FormulaHeader;
import org.pentaho.reporting.engine.classic.extensions.modules.mailer.MailHeader;
import org.pentaho.reporting.engine.classic.extensions.modules.mailer.StaticHeader;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class MailDefinition
implements Serializable,
Cloneable {
    private ArrayList headers;
    private Properties sessionProperties;
    private CompoundDataFactory dataFactory;
    private ReportParameterValues parameterValues;
    private ReportParameterDefinition parameterDefinition = new DefaultParameterDefinition();
    private String burstQuery;
    private String recipientsQuery;
    private String bodyType;
    private MasterReport bodyReport;
    private ReportEnvironment reportEnvironment;
    private ArrayList attachmentReports;
    private ArrayList attachmentTypes;
    private ResourceKey contextKey;
    private ResourceManager resourceManager;
    private ResourceBundleFactory resourceBundleFactory = new DefaultResourceBundleFactory();

    public MailDefinition() {
        this.resourceManager = new ResourceManager();
        this.parameterValues = new ReportParameterValues();
        this.dataFactory = new CompoundDataFactory();
        this.headers = new ArrayList();
        this.attachmentReports = new ArrayList();
        this.attachmentTypes = new ArrayList();
        this.sessionProperties = new Properties();
        this.reportEnvironment = new DefaultReportEnvironment(ClassicEngineBoot.getInstance().getGlobalConfig());
    }

    public MailDefinition(String bodyType, MasterReport bodyReport) {
        this();
        this.setBodyReport(bodyType, bodyReport);
    }

    public ReportEnvironment getReportEnvironment() {
        return this.reportEnvironment;
    }

    public ResourceBundleFactory getResourceBundleFactory() {
        return this.resourceBundleFactory;
    }

    public ResourceKey getContextKey() {
        return this.contextKey;
    }

    public void setContextKey(ResourceKey contextKey) {
        this.contextKey = contextKey;
    }

    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public void setResourceManager(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
        if (this.resourceManager == null) {
            this.resourceManager = new ResourceManager();
        }
    }

    public Properties getSessionProperties() {
        return (Properties)this.sessionProperties.clone();
    }

    public void setSessionProperties(Properties sessionProperties) {
        this.sessionProperties.clear();
        this.sessionProperties.putAll((Map<?, ?>)sessionProperties);
    }

    public void addStaticHeader(String name, String value) {
        this.addHeader(new StaticHeader(name, value));
    }

    public void addFormulaHeader(String name, String formula) {
        this.addHeader(new FormulaHeader(name, formula));
    }

    public void addHeader(MailHeader header) {
        if (header == null) {
            throw new NullPointerException();
        }
        this.headers.add(header);
    }

    public MailHeader getHeader(int i) {
        return (MailHeader)this.headers.get(i);
    }

    public int getHeaderCount() {
        return this.headers.size();
    }

    public MailHeader[] getHeaders() {
        return this.headers.toArray(new MailHeader[this.headers.size()]);
    }

    public void addAttachmentReport(String type, MasterReport attachmentReport) {
        if (type == null) {
            throw new NullPointerException();
        }
        if (attachmentReport == null) {
            throw new NullPointerException();
        }
        if (!ReportProcessTaskRegistry.getInstance().isExportTypeRegistered(type)) {
            throw new IllegalArgumentException("The export type " + type + " is not defined.");
        }
        this.attachmentTypes.add(type);
        this.attachmentReports.add(attachmentReport);
    }

    public String getBodyType() {
        return this.bodyType;
    }

    public MasterReport getBodyReport() {
        return this.bodyReport;
    }

    public void setBodyReport(String bodyType, MasterReport bodyReport) {
        this.bodyType = bodyType;
        this.bodyReport = bodyReport;
    }

    public int getAttachmentCount() {
        return this.attachmentReports.size();
    }

    public MasterReport getAttachmentReport(int index) {
        return (MasterReport)this.attachmentReports.get(index);
    }

    public String getAttachmentType(int index) {
        return (String)this.attachmentTypes.get(index);
    }

    public void removeAttachment(int index) {
        this.attachmentReports.remove(index);
        this.attachmentTypes.remove(index);
    }

    public CompoundDataFactory getDataFactory() {
        return this.dataFactory;
    }

    public ReportParameterValues getParameterValues() {
        return this.parameterValues;
    }

    public ReportParameterDefinition getParameterDefinition() {
        return this.parameterDefinition;
    }

    public void setParameterDefinition(ReportParameterDefinition parameterDefinition) {
        if (parameterDefinition == null) {
            throw new NullPointerException();
        }
        this.parameterDefinition = parameterDefinition;
    }

    public String getBurstQuery() {
        return this.burstQuery;
    }

    public void setBurstQuery(String burstQuery) {
        this.burstQuery = burstQuery;
    }

    public String getRecipientsQuery() {
        return this.recipientsQuery;
    }

    public void setRecipientsQuery(String recipientsQuery) {
        this.recipientsQuery = recipientsQuery;
    }

    public Object clone() throws CloneNotSupportedException {
        MailDefinition mailDefinition = (MailDefinition)super.clone();
        mailDefinition.bodyReport = this.bodyReport.clone();
        mailDefinition.attachmentTypes = (ArrayList)this.attachmentTypes.clone();
        mailDefinition.attachmentReports = (ArrayList)this.attachmentReports.clone();
        mailDefinition.attachmentReports.clear();
        for (int i = 0; i < this.attachmentReports.size(); ++i) {
            MasterReport report = (MasterReport)this.attachmentReports.get(i);
            mailDefinition.attachmentReports.add(report.clone());
        }
        return mailDefinition;
    }

    public Authenticator getAuthenticator() {
        return new DefaultAuthenticator(this.sessionProperties);
    }
}

