/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.modules.java14print;

import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.ReportProgressDialog;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.SwingGuiContext;
import org.pentaho.reporting.engine.classic.core.modules.gui.print.PrintingPlugin;
import org.pentaho.reporting.engine.classic.extensions.modules.java14print.Java14PrintModule;
import org.pentaho.reporting.engine.classic.extensions.modules.java14print.Java14RepaginateAndPrintExportTask;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class Java14PrintingPlugin
extends PrintingPlugin {
    protected String getConfigurationPrefix() {
        return "org.pentaho.reporting.engine.classic.extensions.modules.java14print.print.";
    }

    public boolean initialize(SwingGuiContext context) {
        if (!ObjectUtilities.isJDK14()) {
            return false;
        }
        if (!super.initialize(context)) {
            return false;
        }
        return ClassicEngineBoot.getInstance().isModuleAvailable(Java14PrintModule.class.getName());
    }

    public boolean performExport(MasterReport report) {
        ReportProgressDialog progressDialog;
        if ("true".equals(report.getReportConfiguration().getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.gui.print.ProgressDialogEnabled", "false"))) {
            progressDialog = this.createProgressDialog();
            if (report.getTitle() == null) {
                progressDialog.setTitle(this.getResources().getString("ProgressDialog.EMPTY_TITLE"));
            } else {
                progressDialog.setTitle(this.getResources().formatMessage("ProgressDialog.TITLE", (Object)report.getTitle()));
            }
        } else {
            progressDialog = null;
        }
        Java14RepaginateAndPrintExportTask task = new Java14RepaginateAndPrintExportTask(report, progressDialog, this.getContext().getStatusListener());
        Thread worker = new Thread(task);
        worker.start();
        return true;
    }
}

