/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime;

import com.oracle.webservices.oracle_internal_api.rm.OutboundDelivered;
import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Fiber;
import com.sun.xml.ws.commons.ha.HaContext;
import com.sun.xml.ws.rx.RxException;
import com.sun.xml.ws.rx.RxRuntimeException;
import com.sun.xml.ws.rx.rm.localization.LocalizationMessages;
import com.sun.xml.ws.rx.rm.runtime.ApplicationMessage;
import com.sun.xml.ws.rx.rm.runtime.JaxwsApplicationMessage;
import com.sun.xml.ws.rx.rm.runtime.RedeliveryTaskExecutor;
import com.sun.xml.ws.rx.rm.runtime.RuntimeContext;
import com.sun.xml.ws.rx.rm.runtime.Utilities;
import com.sun.xml.ws.rx.rm.runtime.delivery.Postman;
import com.sun.xml.ws.rx.rm.runtime.sequence.Sequence;
import com.sun.xml.ws.rx.util.AbstractResponseHandler;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

class ClientSourceDeliveryCallback
implements Postman.Callback {
    private static final Logger LOGGER = Logger.getLogger(ClientSourceDeliveryCallback.class);
    private final RuntimeContext rc;

    public ClientSourceDeliveryCallback(RuntimeContext rc) {
        this.rc = rc;
    }

    @Override
    public void deliver(ApplicationMessage message) {
        if (!(message instanceof JaxwsApplicationMessage)) {
            throw LOGGER.logSevereException(new RxRuntimeException(LocalizationMessages.WSRM_1141_UNEXPECTED_MESSAGE_CLASS(message.getClass().getName(), JaxwsApplicationMessage.class.getName())));
        }
        this.deliver((JaxwsApplicationMessage)JaxwsApplicationMessage.class.cast(message));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliver(JaxwsApplicationMessage message) {
        LOGGER.entering(message);
        try {
            this.rc.sourceMessageHandler.attachAcknowledgementInfo(message);
            Packet outboundPacketCopy = message.getPacket().copy(true);
            OutboundDelivered outboundDelivered = outboundPacketCopy.getSatellite(OutboundDelivered.class);
            if (outboundDelivered != null) {
                String seqId = message.getSequenceId();
                long msgNumber = message.getMessageNumber();
                this.rc.outboundDeliveredHandler.store(seqId, msgNumber, outboundDelivered);
                outboundPacketCopy.removeSatellite(outboundDelivered);
            } else if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("OutboundDelivered satellite property was not found");
            }
            this.rc.protocolHandler.appendSequenceHeader(outboundPacketCopy.getMessage(), message);
            this.rc.protocolHandler.appendAcknowledgementHeaders(outboundPacketCopy, message.getAcknowledgementData());
            ResponseCallbackHandler responseCallback = new ResponseCallbackHandler(message, this.rc);
            this.rc.communicator.sendAsync(outboundPacketCopy, responseCallback);
        }
        finally {
            LOGGER.exiting();
        }
    }

    @Override
    public RuntimeContext getRuntimeContext() {
        return this.rc;
    }

    private static class ResponseCallbackHandler
    extends AbstractResponseHandler
    implements Fiber.CompletionCallback {
        private final JaxwsApplicationMessage request;
        private final RuntimeContext rc;

        public ResponseCallbackHandler(JaxwsApplicationMessage request, RuntimeContext rc) {
            super(rc.suspendedFiberStorage, request.getCorrelationId());
            this.request = request;
            this.rc = rc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCompletion(Packet response) {
            try {
                HaContext.initFrom(response);
                if (response.getMessage() != null) {
                    JaxwsApplicationMessage message = new JaxwsApplicationMessage(response, this.getCorrelationId());
                    this.rc.protocolHandler.loadSequenceHeaderData(message, message.getJaxwsMessage());
                    this.rc.protocolHandler.loadAcknowledgementData(message, message.getJaxwsMessage());
                    this.rc.destinationMessageHandler.processAcknowledgements(message.getAcknowledgementData());
                    this.invokeOutboundDeliveredTrueIfRequestAcked();
                    if (this.rc.configuration.getRuntimeVersion().protocolVersion.isFault(message.getWsaAction())) {
                        LOGGER.severe(LocalizationMessages.WSRM_5003_RECEIVED_WSRM_FAULT_RESPONSE(message.getWsaAction()));
                    }
                    if (message.getSequenceId() != null) {
                        boolean persistenceEnabled = this.rc.configuration.getRmFeature().isPersistenceEnabled();
                        this.rc.destinationMessageHandler.registerMessage(message, !persistenceEnabled);
                        this.rc.destinationMessageHandler.putToDeliveryQueue(message);
                    } else {
                        this.resumeParentFiber(response);
                    }
                } else {
                    int nextResendCount = this.request.getNextResendCount();
                    if (!this.rc.configuration.getRmFeature().canRetransmitMessage(nextResendCount)) {
                        this.invokeOutboundDeliveredFalse();
                        this.resumeParentFiber((Throwable)((Object)new RxRuntimeException(LocalizationMessages.WSRM_1159_MAX_MESSAGE_RESEND_ATTEMPTS_REACHED())));
                        return;
                    }
                    RedeliveryTaskExecutor.deliverUsingCurrentThread(this.request, this.rc.configuration.getRmFeature().getRetransmissionBackoffAlgorithm().getDelayInMillis(nextResendCount, this.rc.configuration.getRmFeature().getMessageRetransmissionInterval()), TimeUnit.MILLISECONDS, this.rc.sourceMessageHandler);
                }
            }
            catch (RxRuntimeException ex) {
                this.onCompletion((Throwable)((Object)ex));
            }
            catch (RxException ex) {
                this.onCompletion(ex);
            }
            finally {
                HaContext.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCompletion(Throwable error) {
            if (Utilities.isResendPossible(error)) {
                int nextResendCount = this.request.getNextResendCount();
                if (!this.rc.configuration.getRmFeature().canRetransmitMessage(nextResendCount)) {
                    this.invokeOutboundDeliveredFalse();
                    this.resumeParentFiber((Throwable)((Object)new RxRuntimeException(LocalizationMessages.WSRM_1159_MAX_MESSAGE_RESEND_ATTEMPTS_REACHED())));
                    return;
                }
                try {
                    HaContext.initFrom(this.request.getPacket());
                    RedeliveryTaskExecutor.deliverUsingCurrentThread(this.request, this.rc.configuration.getRmFeature().getRetransmissionBackoffAlgorithm().getDelayInMillis(nextResendCount, this.rc.configuration.getRmFeature().getMessageRetransmissionInterval()), TimeUnit.MILLISECONDS, this.rc.sourceMessageHandler);
                }
                finally {
                    HaContext.clear();
                }
            } else {
                this.invokeOutboundDeliveredFalse();
                this.resumeParentFiber(error);
            }
        }

        private void invokeOutboundDeliveredTrueIfRequestAcked() {
            long messageNumber;
            String seqId = this.request.getSequenceId();
            OutboundDelivered outboundDelivered = this.retrieveOutboundDelivered(seqId, messageNumber = this.request.getMessageNumber());
            if (outboundDelivered != null) {
                Sequence outboundSequence = this.rc.sequenceManager().getOutboundSequence(seqId);
                boolean isRequestAcked = outboundSequence.isAcknowledged(messageNumber);
                if (isRequestAcked) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Invoking outboundDelivered.setDelivered(true) for seq id:" + outboundSequence.getId() + " and " + "message number:" + messageNumber);
                    }
                    outboundDelivered.setDelivered(Boolean.TRUE);
                    this.rc.outboundDeliveredHandler.remove(seqId, messageNumber);
                } else if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("isRequestAcked found false, cannot invoke outboundDelivered.setDelivered(true)");
                }
            }
        }

        private void invokeOutboundDeliveredFalse() {
            long messageNumber;
            String seqId = this.request.getSequenceId();
            OutboundDelivered outboundDelivered = this.retrieveOutboundDelivered(seqId, messageNumber = this.request.getMessageNumber());
            if (outboundDelivered != null) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Invoking outboundDelivered.setDelivered(false)");
                }
                outboundDelivered.setDelivered(Boolean.FALSE);
                this.rc.outboundDeliveredHandler.remove(seqId, messageNumber);
            }
        }

        private OutboundDelivered retrieveOutboundDelivered(String seqId, long messageNumber) {
            OutboundDelivered outboundDelivered = this.rc.outboundDeliveredHandler.retrieve(seqId, messageNumber);
            if (outboundDelivered == null && LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Could not get OutboundDelivered from OutboundDeliveredHandler");
            }
            return outboundDelivered;
        }
    }
}

