/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.ivwloader;

import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ProvidesDatabaseConnectionInformation;
import org.pentaho.di.core.SQLStatement;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.ivwloader.IngresVectorwiseLoader;
import org.pentaho.di.trans.steps.ivwloader.IngresVectorwiseLoaderData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

@Step(id="VectorWiseBulkLoader", name="BaseStep.TypeLongDesc.VectorWiseBulkLoader", description="BaseStep.TypeTooltipDesc.VectorWiseBulkLoader", categoryDescription="i18n:org.pentaho.di.trans.step:BaseStep.Category.Bulk", image="BLKVW.svg", documentationUrl="http://wiki.pentaho.com/display/EAI/Ingres+VectorWise+Bulk+Loader", i18nPackageName="org.pentaho.di.trans.steps.ivwloader")
public class IngresVectorwiseLoaderMeta
extends BaseStepMeta
implements StepMetaInterface,
ProvidesDatabaseConnectionInformation {
    private static Class<?> PKG = IngresVectorwiseLoaderMeta.class;
    private DatabaseMeta databaseMeta;
    private String tablename;
    private String[] fieldStream;
    private String[] fieldDatabase;
    private String[] fieldFormat;
    private String fifoFileName;
    private String errorFileName;
    private boolean continueOnError;
    private String sqlPath;
    private boolean useStandardConversion;
    private boolean useAuthentication;
    private String encoding;
    private String delimiter;
    private boolean useSSV;
    private boolean rejectErrors = false;
    private boolean useDynamicVNode;
    private boolean escapingSpecialCharacters;
    private String bufferSize;
    private boolean usingVwload;
    private String maxNrErrors;
    private boolean truncatingTable;

    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        IngresVectorwiseLoader loader = new IngresVectorwiseLoader(stepMeta, stepDataInterface, cnr, tr, trans);
        return loader;
    }

    public StepDataInterface getStepData() {
        return new IngresVectorwiseLoaderData();
    }

    public Object clone() {
        IngresVectorwiseLoaderMeta retval = (IngresVectorwiseLoaderMeta)((Object)super.clone());
        return retval;
    }

    public void setDefault() {
        this.allocate(0);
        this.sqlPath = "/opt/Ingres/IngresVW/ingres/bin/sql";
        this.delimiter = "|";
        this.fifoFileName = "${java.io.tmpdir}/fifoVW-${Internal.Step.CopyNr}";
        this.useStandardConversion = false;
        this.useAuthentication = false;
        this.continueOnError = false;
        this.useDynamicVNode = false;
        this.escapingSpecialCharacters = true;
        this.usingVwload = false;
        this.maxNrErrors = "50";
        this.truncatingTable = false;
        this.useSSV = false;
        this.bufferSize = "5000";
    }

    public boolean isRejectErrors() {
        return this.rejectErrors;
    }

    public void setRejectErrors(boolean rejectErrors) {
        this.rejectErrors = rejectErrors;
    }

    public void allocate(int nrRows) {
        this.fieldStream = new String[nrRows];
        this.fieldDatabase = new String[nrRows];
    }

    public String getXML() {
        StringBuilder retval = new StringBuilder();
        retval.append("    ").append(XMLHandler.addTagValue((String)"connection", (String)(this.databaseMeta == null ? "" : this.databaseMeta.getName())));
        retval.append("    ").append(XMLHandler.addTagValue((String)"table", (String)this.tablename));
        retval.append("    ").append(XMLHandler.addTagValue((String)"fifo_file_name", (String)this.fifoFileName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"sql_path", (String)this.sqlPath));
        retval.append("    ").append(XMLHandler.addTagValue((String)"encoding", (String)this.encoding));
        retval.append("    ").append(XMLHandler.addTagValue((String)"delimiter", (String)this.delimiter));
        retval.append("    ").append(XMLHandler.addTagValue((String)"continue_on_error", (boolean)this.continueOnError));
        retval.append("    ").append(XMLHandler.addTagValue((String)"error_file_name", (String)this.errorFileName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"use_standard_conversion", (boolean)this.useStandardConversion));
        retval.append("    ").append(XMLHandler.addTagValue((String)"use_authentication", (boolean)this.useAuthentication));
        retval.append("    ").append(XMLHandler.addTagValue((String)"use_dynamic_vnode", (boolean)this.useDynamicVNode));
        retval.append("    ").append(XMLHandler.addTagValue((String)"use_SSV_delimiter", (boolean)this.useSSV));
        retval.append("    ").append(XMLHandler.addTagValue((String)"escape_special_characters", (boolean)this.escapingSpecialCharacters));
        retval.append("    ").append(XMLHandler.addTagValue((String)"use_vwload", (boolean)this.usingVwload));
        retval.append("    ").append(XMLHandler.addTagValue((String)"truncate_table", (boolean)this.truncatingTable));
        retval.append("    ").append(XMLHandler.addTagValue((String)"max_errors", (String)this.maxNrErrors));
        retval.append("    ").append(XMLHandler.addTagValue((String)"buffer_size", (String)this.bufferSize));
        retval.append("    <fields>").append(Const.CR);
        for (int i = 0; i < this.fieldDatabase.length; ++i) {
            retval.append("        <field>").append(Const.CR);
            retval.append("          ").append(XMLHandler.addTagValue((String)"column_name", (String)this.fieldDatabase[i]));
            retval.append("          ").append(XMLHandler.addTagValue((String)"stream_name", (String)this.fieldStream[i]));
            retval.append("        </field>").append(Const.CR);
        }
        retval.append("    </fields>").append(Const.CR);
        return retval.toString();
    }

    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        try {
            String con = XMLHandler.getTagValue((Node)stepnode, (String)"connection");
            this.databaseMeta = DatabaseMeta.findDatabase(databases, (String)con);
            this.tablename = XMLHandler.getTagValue((Node)stepnode, (String)"table");
            this.fifoFileName = XMLHandler.getTagValue((Node)stepnode, (String)"fifo_file_name");
            this.sqlPath = XMLHandler.getTagValue((Node)stepnode, (String)"sql_path");
            this.encoding = XMLHandler.getTagValue((Node)stepnode, (String)"encoding");
            this.delimiter = XMLHandler.getTagValue((Node)stepnode, (String)"delimiter");
            this.continueOnError = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"continue_on_error"));
            this.errorFileName = XMLHandler.getTagValue((Node)stepnode, (String)"error_file_name");
            this.useStandardConversion = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"use_standard_conversion"));
            this.useAuthentication = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"use_authentication"));
            this.useDynamicVNode = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"use_dynamic_vnode"));
            this.useSSV = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"use_SSV_delimiter"));
            String escape = XMLHandler.getTagValue((Node)stepnode, (String)"escape_special_characters");
            this.escapingSpecialCharacters = Utils.isEmpty((CharSequence)escape) ? true : "Y".equalsIgnoreCase(escape);
            this.usingVwload = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"use_vwload"));
            this.maxNrErrors = XMLHandler.getTagValue((Node)stepnode, (String)"max_errors");
            this.truncatingTable = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"truncate_table"));
            this.bufferSize = XMLHandler.getTagValue((Node)stepnode, (String)"buffer_size");
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int nrRows = XMLHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrRows);
            for (int i = 0; i < nrRows; ++i) {
                Node knode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.fieldDatabase[i] = XMLHandler.getTagValue((Node)knode, (String)"column_name");
                this.fieldStream[i] = XMLHandler.getTagValue((Node)knode, (String)"stream_name");
            }
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.databaseMeta = rep.loadDatabaseMetaFromStepAttribute(id_step, "id_connection", databases);
            this.tablename = rep.getStepAttributeString(id_step, "table");
            this.fifoFileName = rep.getStepAttributeString(id_step, "fifo_file_name");
            this.sqlPath = rep.getStepAttributeString(id_step, "sql_path");
            this.encoding = rep.getStepAttributeString(id_step, "encoding");
            this.delimiter = rep.getStepAttributeString(id_step, "delimiter");
            this.continueOnError = rep.getStepAttributeBoolean(id_step, "continue_on_error");
            this.errorFileName = rep.getStepAttributeString(id_step, "error_file_name");
            this.useStandardConversion = rep.getStepAttributeBoolean(id_step, "use_standard_conversion");
            this.useAuthentication = rep.getStepAttributeBoolean(id_step, "use_authentication");
            this.useDynamicVNode = rep.getStepAttributeBoolean(id_step, "use_dynamic_vnode");
            this.useSSV = rep.getStepAttributeBoolean(id_step, "use_SSV_delimiter");
            this.escapingSpecialCharacters = rep.getStepAttributeBoolean(id_step, 0, "escape_special_characters", true);
            this.usingVwload = rep.getStepAttributeBoolean(id_step, "use_vwload");
            this.maxNrErrors = rep.getStepAttributeString(id_step, "max_errors");
            this.truncatingTable = rep.getStepAttributeBoolean(id_step, "truncate_table");
            this.bufferSize = rep.getStepAttributeString(id_step, "buffer_size");
            int nrCols = rep.countNrStepAttributes(id_step, "column_name");
            int nrStreams = rep.countNrStepAttributes(id_step, "stream_name");
            int nrRows = nrCols < nrStreams ? nrStreams : nrCols;
            this.allocate(nrRows);
            for (int idx = 0; idx < nrRows; ++idx) {
                this.fieldDatabase[idx] = Const.NVL((String)rep.getStepAttributeString(id_step, idx, "column_name"), (String)"");
                this.fieldStream[idx] = Const.NVL((String)rep.getStepAttributeString(id_step, idx, "stream_name"), (String)"");
            }
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveDatabaseMetaStepAttribute(id_transformation, id_step, "id_connection", this.databaseMeta);
            rep.saveStepAttribute(id_transformation, id_step, "table", this.tablename);
            rep.saveStepAttribute(id_transformation, id_step, "fifo_file_name", this.fifoFileName);
            rep.saveStepAttribute(id_transformation, id_step, "sql_path", this.sqlPath);
            rep.saveStepAttribute(id_transformation, id_step, "encoding", this.encoding);
            rep.saveStepAttribute(id_transformation, id_step, "delimiter", this.delimiter);
            rep.saveStepAttribute(id_transformation, id_step, "continue_on_error", this.continueOnError);
            rep.saveStepAttribute(id_transformation, id_step, "error_file_name", this.errorFileName);
            rep.saveStepAttribute(id_transformation, id_step, "use_standard_conversion", this.useStandardConversion);
            rep.saveStepAttribute(id_transformation, id_step, "use_authentication", this.useAuthentication);
            rep.saveStepAttribute(id_transformation, id_step, "use_dynamic_vnode", this.useDynamicVNode);
            rep.saveStepAttribute(id_transformation, id_step, "use_SSV_delimiter", this.useSSV);
            rep.saveStepAttribute(id_transformation, id_step, "escape_special_characters", this.escapingSpecialCharacters);
            rep.saveStepAttribute(id_transformation, id_step, "use_vwload", this.usingVwload);
            rep.saveStepAttribute(id_transformation, id_step, "max_errors", this.maxNrErrors);
            rep.saveStepAttribute(id_transformation, id_step, "truncate_table", this.truncatingTable);
            rep.saveStepAttribute(id_transformation, id_step, "buffer_size", this.bufferSize);
            int nrRows = this.fieldDatabase.length < this.fieldStream.length ? this.fieldStream.length : this.fieldDatabase.length;
            for (int idx = 0; idx < nrRows; ++idx) {
                String columnName = idx < this.fieldDatabase.length ? this.fieldDatabase[idx] : "";
                String streamName = idx < this.fieldStream.length ? this.fieldStream[idx] : "";
                rep.saveStepAttribute(id_transformation, id_step, idx, "column_name", columnName);
                rep.saveStepAttribute(id_transformation, id_step, idx, "stream_name", streamName);
            }
            if (this.databaseMeta != null) {
                rep.insertStepDatabase(id_transformation, id_step, this.databaseMeta.getObjectId());
            }
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for id_step=" + id_step, (Throwable)e);
        }
    }

    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public void setDatabaseMeta(DatabaseMeta databaseMeta) {
        this.databaseMeta = databaseMeta;
    }

    public String getTableName() {
        return this.tablename;
    }

    public void setTablename(String tablename) {
        this.tablename = tablename;
    }

    public String[] getFieldStream() {
        return this.fieldStream;
    }

    public void setFieldStream(String[] fieldStream) {
        this.fieldStream = fieldStream;
    }

    public String[] getFieldDatabase() {
        return this.fieldDatabase;
    }

    public void setFieldDatabase(String[] fieldDatabase) {
        this.fieldDatabase = fieldDatabase;
    }

    public String[] getFieldFormat() {
        return this.fieldFormat;
    }

    public void setFieldFormat(String[] fieldFormat) {
        this.fieldFormat = fieldFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLStatement getSQLStatements(TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, Repository repository, IMetaStore metaStore) {
        SQLStatement retval = new SQLStatement(stepMeta.getName(), this.databaseMeta, null);
        if (this.databaseMeta != null) {
            if (prev != null && prev.size() > 0) {
                if (!Utils.isEmpty((CharSequence)this.tablename)) {
                    Database db = new Database(loggingObject, this.databaseMeta);
                    db.shareVariablesWith((VariableSpace)transMeta);
                    try {
                        db.connect();
                        String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(null, this.tablename);
                        String cr_table = db.getDDL(schemaTable, prev);
                        String VW_CLAUSE = "WITH STRUCTURE=VECTORWISE";
                        if (cr_table.toUpperCase().contains("CREATE TABLE")) {
                            int scIndex = cr_table.indexOf(59);
                            cr_table = scIndex < 0 ? cr_table + VW_CLAUSE : cr_table.substring(0, scIndex) + VW_CLAUSE + cr_table.substring(scIndex);
                        }
                        if (cr_table == null || cr_table.length() == 0) {
                            cr_table = null;
                        }
                        retval.setSQL(cr_table);
                    }
                    catch (KettleDatabaseException dbe) {
                        retval.setError(BaseMessages.getString(PKG, (String)"IngresVectorWiseLoaderMeta.Error.ErrorConnecting", (String[])new String[]{dbe.getMessage()}));
                    }
                    finally {
                        db.disconnect();
                    }
                } else {
                    retval.setError(BaseMessages.getString(PKG, (String)"IngresVectorWiseLoaderMeta.Error.NoTable", (String[])new String[0]));
                }
            } else {
                retval.setError(BaseMessages.getString(PKG, (String)"IngresVectorWiseLoaderMeta.Error.NoInput", (String[])new String[0]));
            }
        } else {
            retval.setError(BaseMessages.getString(PKG, (String)"IngresVectorWiseLoaderMeta.Error.NoConnection", (String[])new String[0]));
        }
        return retval;
    }

    public String getFifoFileName() {
        return this.fifoFileName;
    }

    public void setFifoFileName(String fifoFileName) {
        this.fifoFileName = fifoFileName;
    }

    public String getSqlPath() {
        return this.sqlPath;
    }

    public void setSqlPath(String sqlPath) {
        this.sqlPath = sqlPath;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public String getErrorFileName() {
        return this.errorFileName;
    }

    public void setErrorFileName(String errorFileName) {
        this.errorFileName = errorFileName;
    }

    public boolean isContinueOnError() {
        return this.continueOnError;
    }

    public void setContinueOnError(boolean continueOnError) {
        this.continueOnError = continueOnError;
    }

    public boolean isUseStandardConversion() {
        return this.useStandardConversion;
    }

    public void setUseStandardConversion(boolean useStandardConversion) {
        this.useStandardConversion = useStandardConversion;
    }

    public boolean isUseDynamicVNode() {
        return this.useDynamicVNode;
    }

    public void setUseDynamicVNode(boolean createDynamicVNode) {
        this.useDynamicVNode = createDynamicVNode;
    }

    public boolean isUseSSV() {
        return this.useSSV;
    }

    public void setUseSSV(boolean useSSV) {
        this.useSSV = useSSV;
    }

    public boolean isEscapingSpecialCharacters() {
        return this.escapingSpecialCharacters;
    }

    public void setEscapingSpecialCharacters(boolean escapingSpecialCharacters) {
        this.escapingSpecialCharacters = escapingSpecialCharacters;
    }

    public String getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(String bufferSize) {
        this.bufferSize = bufferSize;
    }

    public boolean isUseAuthentication() {
        return this.useAuthentication;
    }

    public void setUseAuthentication(boolean useAuthentication) {
        this.useAuthentication = useAuthentication;
    }

    public boolean isUsingVwload() {
        return this.usingVwload;
    }

    public void setUsingVwload(boolean usingVwload) {
        this.usingVwload = usingVwload;
    }

    public boolean isTruncatingTable() {
        return this.truncatingTable;
    }

    public void setTruncatingTable(boolean truncatingTable) {
        this.truncatingTable = truncatingTable;
    }

    public String getMaxNrErrors() {
        return this.maxNrErrors;
    }

    public void setMaxNrErrors(String maxNrErrors) {
        this.maxNrErrors = maxNrErrors;
    }

    public String getSchemaName() {
        return null;
    }

    public String getMissingDatabaseConnectionInformationMessage() {
        return null;
    }

    public DatabaseMeta[] getUsedDatabaseConnections() {
        if (this.databaseMeta != null) {
            return new DatabaseMeta[]{this.databaseMeta};
        }
        return super.getUsedDatabaseConnections();
    }
}

