/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metadata.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.pentaho.metadata.model.concept.security.RowLevelSecurity;
import org.pentaho.metadata.model.concept.security.SecurityOwner;

public class RowLevelSecurityHelper {
    private static final String EMPTY_STRING = "";
    private static final String FUNC_OR = "OR";
    private static final String PARAM_LIST_BEGIN = "(";
    private static final String PARAM_LIST_END = ")";
    private static final String PARAM_SEPARATOR = ";";

    public String getOpenFormulaSecurityConstraint(RowLevelSecurity rls, String user, List<String> roles) {
        switch (rls.getType()) {
            case GLOBAL: {
                return this.expandFunctions(rls.getGlobalConstraint(), user, roles);
            }
            case ROLEBASED: {
                return this.generateRuleBasedConstraint(rls, user, roles);
            }
        }
        return EMPTY_STRING;
    }

    protected String expandFunctions(String formula, String user, List<String> roles) {
        formula = formula.replaceAll("USER\\(\\)", String.format("\"%s\"", user));
        StringBuilder buf = new StringBuilder();
        int i = 0;
        for (String role : roles) {
            if (i > 0) {
                buf.append(PARAM_SEPARATOR);
            }
            buf.append(String.format("\"%s\"", role));
            ++i;
        }
        return formula.replaceAll("ROLES\\(\\)", buf.toString());
    }

    protected String generateRuleBasedConstraint(RowLevelSecurity rls, String user, List<String> roles) {
        ArrayList<String> pieces = new ArrayList<String>();
        for (Map.Entry<SecurityOwner, String> entry : rls.getRoleBasedConstraintMap().entrySet()) {
            SecurityOwner owner = entry.getKey();
            String formula = entry.getValue();
            if ((owner.getOwnerType() != SecurityOwner.OwnerType.USER || !owner.getOwnerName().equals(user)) && (roles == null || owner.getOwnerType() != SecurityOwner.OwnerType.ROLE || !roles.contains(owner.getOwnerName()))) continue;
            pieces.add(formula);
        }
        if (pieces.size() == 0) {
            return "FALSE()";
        }
        if (pieces.size() == 1) {
            return (String)pieces.get(0);
        }
        StringBuilder buf = new StringBuilder();
        buf.append(FUNC_OR);
        buf.append(PARAM_LIST_BEGIN);
        int index = 0;
        for (String piece : pieces) {
            if (index > 0) {
                buf.append(PARAM_SEPARATOR);
            }
            buf.append(piece);
            ++index;
        }
        buf.append(PARAM_LIST_END);
        return buf.toString();
    }
}

