/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metadata.query.model;

import java.io.Serializable;
import org.pentaho.metadata.model.Category;
import org.pentaho.metadata.model.LogicalColumn;
import org.pentaho.metadata.model.concept.types.AggregationType;

public class Selection
implements Serializable {
    private static final long serialVersionUID = -3477700975099030430L;
    private Category category;
    private LogicalColumn logicalColumn;
    private AggregationType aggregation;

    public Selection(Category category, LogicalColumn column, AggregationType aggregation) {
        this.category = category;
        this.logicalColumn = column;
        this.aggregation = aggregation;
    }

    public Category getCategory() {
        return this.category;
    }

    public LogicalColumn getLogicalColumn() {
        return this.logicalColumn;
    }

    public AggregationType getAggregationType() {
        return this.aggregation;
    }

    public boolean hasAggregate() {
        return !AggregationType.NONE.equals((Object)this.getActiveAggregationType());
    }

    public AggregationType getActiveAggregationType() {
        if (this.getAggregationType() == null) {
            AggregationType aggType = this.logicalColumn.getAggregationType();
            if (aggType == null) {
                return AggregationType.NONE;
            }
            return aggType;
        }
        return this.getAggregationType();
    }

    public int hashCode() {
        return this.logicalColumn.getId().hashCode();
    }

    public boolean equals(Object selection) {
        Selection sel = (Selection)selection;
        return sel.getLogicalColumn().equals(this.getLogicalColumn()) && sel.getActiveAggregationType() == this.getActiveAggregationType();
    }
}

