/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metadata.model;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.metadata.model.IPhysicalColumn;
import org.pentaho.metadata.model.IPhysicalModel;
import org.pentaho.metadata.model.IPhysicalTable;
import org.pentaho.metadata.model.SqlPhysicalModel;
import org.pentaho.metadata.model.concept.Concept;
import org.pentaho.metadata.model.concept.IConcept;
import org.pentaho.metadata.model.concept.types.LocalizedString;
import org.pentaho.metadata.model.concept.types.TableType;
import org.pentaho.metadata.model.concept.types.TargetTableType;

public class SqlPhysicalTable
extends Concept
implements IPhysicalTable {
    private static final long serialVersionUID = -2590635019353532334L;
    public static final String TARGET_SCHEMA = "target_schema";
    public static final String TARGET_TABLE = "target_table";
    public static final String TARGET_TABLE_TYPE = "target_table_type";
    public static final String RELATIVE_SIZE = "relative_size";
    List<IPhysicalColumn> physicalColumns = new ArrayList<IPhysicalColumn>();

    public SqlPhysicalTable() {
        this.setTargetTableType(TargetTableType.TABLE);
        this.setName(new LocalizedString());
        this.setDescription(new LocalizedString());
    }

    public SqlPhysicalTable(SqlPhysicalModel model) {
        this();
        this.setParent(model);
    }

    @Override
    public List<IConcept> getChildren() {
        ArrayList<IConcept> children = new ArrayList<IConcept>();
        children.addAll(this.physicalColumns);
        return children;
    }

    @Override
    public IPhysicalModel getPhysicalModel() {
        return (IPhysicalModel)this.getParent();
    }

    @Override
    public List<IPhysicalColumn> getPhysicalColumns() {
        return this.physicalColumns;
    }

    public void addPhysicalColumn(IPhysicalColumn column) {
        this.physicalColumns.add(column);
    }

    public String getTargetSchema() {
        return (String)this.getProperty(TARGET_SCHEMA);
    }

    public void setTargetSchema(String targetSchema) {
        this.setProperty(TARGET_SCHEMA, targetSchema);
    }

    public String getTargetTable() {
        return (String)this.getProperty(TARGET_TABLE);
    }

    public void setTargetTable(String targetTable) {
        this.setProperty(TARGET_TABLE, targetTable);
    }

    public TargetTableType getTargetTableType() {
        return (TargetTableType)((Object)this.getProperty(TARGET_TABLE_TYPE));
    }

    public void setTargetTableType(TargetTableType targetTableType) {
        this.setProperty(TARGET_TABLE_TYPE, (Object)targetTableType);
    }

    public TableType getTableType() {
        return (TableType)((Object)this.getProperty("tabletype"));
    }

    public void setTableType(TableType tableType) {
        this.setProperty("tabletype", (Object)tableType);
    }

    public Integer getRelativeSize() {
        return (Integer)this.getProperty(RELATIVE_SIZE);
    }

    public void setRelativeSize(Integer relativeSize) {
        this.setProperty(RELATIVE_SIZE, relativeSize);
    }
}

