/*
 * Decompiled with CFR 0.152.
 */
package net.sf.farrago.jdbc.client;

import de.simplicit.vjdbc.VirtualDriver;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import net.sf.farrago.jdbc.FarragoAbstractJdbcDriver;
import net.sf.farrago.release.FarragoReleaseProperties;

public class FarragoUnregisteredVjdbcHttpClientDriver
extends FarragoAbstractJdbcDriver {
    @Override
    public String getUrlPrefix() {
        return this.getBaseUrl() + "http://";
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        VirtualDriver httpDriver;
        if (!this.acceptsURL(url)) {
            return null;
        }
        Properties driverProps = this.applyDefaultConnectionProps(info);
        String driverUrl = this.parseConnectionParams(url, driverProps);
        try {
            httpDriver = new VirtualDriver();
        }
        catch (Exception ex) {
            throw new SQLException(ex.getMessage());
        }
        String urlHttp = driverUrl.substring(this.getUrlPrefix().length());
        String[] split = urlHttp.split(":");
        if (split.length == 1) {
            FarragoReleaseProperties props = FarragoReleaseProperties.instance();
            urlHttp = urlHttp + ":" + props.jdbcUrlHttpPortDefault.get();
        }
        urlHttp = "jdbc:vjdbc:servlet:http://" + urlHttp + "/vjdbc,FarragoDBMS";
        return httpDriver.connect(urlHttp, driverProps);
    }
}

