/*
 * Decompiled with CFR 0.152.
 */
package de.simplicit.vjdbc.cache;

import java.util.HashSet;
import java.util.Set;

class SimpleStatementParser {
    SimpleStatementParser() {
    }

    Set getTablesOfSelectStatement(String sql) {
        String newsql;
        HashSet<String> result = new HashSet<String>();
        while (!(newsql = sql.replaceAll("  ", " ")).equals(sql)) {
            sql = newsql;
        }
        String sqlLowerCase = sql.toLowerCase();
        int selectPos = sqlLowerCase.indexOf("select");
        if (selectPos >= 0) {
            boolean fromLoop = true;
            int fromStartPos = 0;
            while (fromLoop) {
                int fromPos = sqlLowerCase.indexOf(" from ", fromStartPos);
                if (fromPos >= 0) {
                    String fromPart = sqlLowerCase.substring(fromPos + 6);
                    String[] parts = fromPart.split(",");
                    for (int i = 0; i < parts.length; ++i) {
                        String part = parts[i].trim();
                        int spacePos = part.indexOf(32);
                        if (spacePos >= 0) {
                            String table = part.substring(0, spacePos);
                            result.add(table.toLowerCase());
                            continue;
                        }
                        result.add(part.toLowerCase());
                    }
                    fromStartPos = fromPos + 6;
                    continue;
                }
                fromLoop = false;
            }
            boolean joinLoop = true;
            int joinStartPos = 0;
            while (joinLoop) {
                int joinPos = sqlLowerCase.indexOf(" join ", joinStartPos);
                if (joinPos >= 0) {
                    int joinPos2 = sql.indexOf(32, joinPos + 6);
                    String tableName = joinPos2 >= 0 ? sql.substring(joinPos + 6, joinPos2) : sql.substring(joinPos + 6);
                    result.add(tableName.toLowerCase());
                    joinStartPos = joinPos2;
                    continue;
                }
                joinLoop = false;
            }
        }
        return result;
    }

    private static void dumpTables(String sql) {
        System.out.println(sql);
        SimpleStatementParser parser = new SimpleStatementParser();
        Set tables = parser.getTablesOfSelectStatement(sql);
        for (String table : tables) {
            System.out.println("Table: " + table);
        }
    }

    public static void main(String[] args) {
        SimpleStatementParser.dumpTables("SELECT * FROM Test");
        SimpleStatementParser.dumpTables("SELECT * FROM Test, Jolly WHERE H = O");
        SimpleStatementParser.dumpTables("SELECT * FROM Test INNER JOIN Jolly WHERE H = O");
        SimpleStatementParser.dumpTables("     SELECT * FROM Test    INNER    JOIN    Jolly ON Test.Id = Jolly.Id   INNER   JOIN     Opa WHERE H = O");
        SimpleStatementParser.dumpTables("select usr.user_id as x0_0_ from Users usr where usr.discriminator='kport' and ((65543 in(select register0_.regcat_id from rel_usr_cat register0_ where usr.user_id=register0_.user_id))");
    }
}

