/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.s3common;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.auth.profile.ProfileCredentialsProvider;
import com.amazonaws.auth.profile.ProfilesConfigFile;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.pentaho.amazon.s3.S3Util;
import org.pentaho.di.connections.ConnectionManager;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.s3common.S3CommonFileProvider;
import org.pentaho.s3common.S3CommonFileSystemConfigBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class S3CommonFileSystem
extends AbstractFileSystem {
    private static final Logger logger = LoggerFactory.getLogger(S3CommonFileSystem.class);
    private static final String DEFAULT_S3_CONFIG_PROPERTY = "defaultS3Config";
    private String awsAccessKeyCache;
    private String awsSecretKeyCache;
    private AmazonS3 client;
    private final Supplier<ConnectionManager> connectionManager = ConnectionManager::getInstance;
    private Map<String, String> currentConnectionProperties = new HashMap<String, String>();
    private FileSystemOptions currentFileSystemOptions;

    protected S3CommonFileSystem(FileName rootName, FileSystemOptions fileSystemOptions) {
        super(rootName, null, fileSystemOptions);
    }

    protected void addCapabilities(Collection caps) {
        caps.addAll(S3CommonFileProvider.capabilities);
    }

    protected abstract FileObject createFile(AbstractFileName var1) throws Exception;

    public AmazonS3 getS3Client() {
        S3CommonFileSystemConfigBuilder s3CommonFileSystemConfigBuilder = new S3CommonFileSystemConfigBuilder(this.getFileSystemOptions());
        Optional<Object> defaultS3Connection = Optional.empty();
        try {
            defaultS3Connection = this.connectionManager.get().getConnectionDetailsByScheme("s3").stream().filter(connectionDetails -> connectionDetails.getProperties().get(DEFAULT_S3_CONFIG_PROPERTY) != null && ((String)connectionDetails.getProperties().get(DEFAULT_S3_CONFIG_PROPERTY)).equalsIgnoreCase("true")).findFirst();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (s3CommonFileSystemConfigBuilder.getName() == null) {
            HashMap<String, String> newConnectionProperties = new HashMap<String, String>();
            defaultS3Connection.ifPresent(connectionDetails -> newConnectionProperties.putAll(connectionDetails.getProperties()));
            if (!newConnectionProperties.equals(this.currentConnectionProperties)) {
                this.client = null;
                this.currentConnectionProperties = newConnectionProperties;
                this.getFileSystemManager().getFilesCache().clear((FileSystem)this);
            }
        }
        if (this.currentFileSystemOptions != null && !this.currentFileSystemOptions.equals((Object)this.getFileSystemOptions())) {
            this.client = null;
            this.getFileSystemManager().getFilesCache().clear((FileSystem)this);
        }
        if (this.client == null && this.getFileSystemOptions() != null) {
            this.currentFileSystemOptions = this.getFileSystemOptions();
            String accessKey = null;
            String secretKey = null;
            String sessionToken = null;
            String region = null;
            String credentialsFilePath = null;
            String profileName = null;
            String endpoint = null;
            String signatureVersion = null;
            String pathStyleAccess = null;
            if (s3CommonFileSystemConfigBuilder.getName() == null && defaultS3Connection.isPresent()) {
                accessKey = Encr.decryptPassword((String)this.currentConnectionProperties.get("accessKey"));
                secretKey = Encr.decryptPassword((String)this.currentConnectionProperties.get("secretKey"));
                sessionToken = Encr.decryptPassword((String)this.currentConnectionProperties.get("sessionToken"));
                region = this.currentConnectionProperties.get("region");
                credentialsFilePath = this.currentConnectionProperties.get("credentialsFilePath");
                profileName = this.currentConnectionProperties.get("profileName");
                endpoint = this.currentConnectionProperties.get("endpoint");
                signatureVersion = this.currentConnectionProperties.get("signatureVersion");
                pathStyleAccess = this.currentConnectionProperties.get("pathStyleAccess");
            } else {
                accessKey = s3CommonFileSystemConfigBuilder.getAccessKey();
                secretKey = s3CommonFileSystemConfigBuilder.getSecretKey();
                sessionToken = s3CommonFileSystemConfigBuilder.getSessionToken();
                region = s3CommonFileSystemConfigBuilder.getRegion();
                credentialsFilePath = s3CommonFileSystemConfigBuilder.getCredentialsFile();
                profileName = s3CommonFileSystemConfigBuilder.getProfileName();
                endpoint = s3CommonFileSystemConfigBuilder.getEndpoint();
                signatureVersion = s3CommonFileSystemConfigBuilder.getSignatureVersion();
                pathStyleAccess = s3CommonFileSystemConfigBuilder.getPathStyleAccess();
            }
            boolean access = pathStyleAccess == null || Boolean.parseBoolean(pathStyleAccess);
            ProfileCredentialsProvider awsCredentialsProvider = null;
            Regions regions = Regions.DEFAULT_REGION;
            S3Util.S3Keys keys = S3Util.getKeysFromURI(this.getRootURI());
            if (keys != null) {
                accessKey = keys.getAccessKey();
                secretKey = keys.getSecretKey();
            }
            if (!S3Util.isEmpty(accessKey) && !S3Util.isEmpty(secretKey)) {
                Object awsCredentials = S3Util.isEmpty(sessionToken) ? new BasicAWSCredentials(accessKey, secretKey) : new BasicSessionCredentials(accessKey, secretKey, sessionToken);
                awsCredentialsProvider = new AWSStaticCredentialsProvider((AWSCredentials)awsCredentials);
                regions = S3Util.isEmpty(region) ? Regions.DEFAULT_REGION : Regions.fromName((String)region);
            } else if (!S3Util.isEmpty(credentialsFilePath)) {
                ProfilesConfigFile profilesConfigFile = new ProfilesConfigFile(credentialsFilePath);
                awsCredentialsProvider = new ProfileCredentialsProvider(profilesConfigFile, profileName);
            }
            if (!S3Util.isEmpty(endpoint)) {
                ClientConfiguration clientConfiguration = new ClientConfiguration();
                clientConfiguration.setSignerOverride(S3Util.isEmpty(signatureVersion) ? "aws.endpoint" : signatureVersion);
                this.client = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(endpoint, regions.getName()))).withPathStyleAccessEnabled(Boolean.valueOf(access))).withClientConfiguration(clientConfiguration)).withCredentials((AWSCredentialsProvider)awsCredentialsProvider)).build();
            } else {
                AmazonS3ClientBuilder clientBuilder = (AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().enableForceGlobalBucketAccess()).withCredentials(awsCredentialsProvider);
                if (!this.isRegionSet()) {
                    clientBuilder.withRegion(regions);
                }
                this.client = (AmazonS3)clientBuilder.build();
            }
        }
        if (this.client == null || this.hasClientChangedCredentials()) {
            try {
                this.client = this.isRegionSet() ? (AmazonS3)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().enableForceGlobalBucketAccess()).build() : (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().enableForceGlobalBucketAccess()).withRegion(Regions.DEFAULT_REGION)).build();
                this.awsAccessKeyCache = System.getProperty("aws.accessKeyId");
                this.awsSecretKeyCache = System.getProperty("aws.secretKey");
            }
            catch (Exception ex) {
                logger.error("Could not get an S3Client", (Throwable)ex);
            }
        }
        return this.client;
    }

    private boolean hasClientChangedCredentials() {
        return this.client != null && (S3Util.hasChanged(this.awsAccessKeyCache, System.getProperty("aws.accessKeyId")) || S3Util.hasChanged(this.awsSecretKeyCache, System.getProperty("aws.secretKey")));
    }

    protected boolean isRegionSet() {
        if (System.getenv("AWS_REGION") != null || System.getenv("AWS_CONFIG_FILE") != null) {
            return true;
        }
        File awsConfigFolder = new File(System.getProperty("user.home") + File.separator + ".aws" + File.separator + "config");
        if (awsConfigFolder.exists()) {
            return true;
        }
        return Regions.getCurrentRegion() != null;
    }
}

