/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.s3a.vfs;

import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.AbstractFileNameParser;
import org.apache.commons.vfs2.provider.FileNameParser;
import org.apache.commons.vfs2.provider.UriParser;
import org.apache.commons.vfs2.provider.VfsComponentContext;
import org.pentaho.amazon.s3.S3Util;
import org.pentaho.s3a.vfs.S3AFileName;

public class S3AFileNameParser
extends AbstractFileNameParser {
    private static final S3AFileNameParser INSTANCE = new S3AFileNameParser();

    private S3AFileNameParser() {
    }

    public static FileNameParser getInstance() {
        return INSTANCE;
    }

    public FileName parseUri(VfsComponentContext context, FileName base, String uri) throws FileSystemException {
        StringBuilder buffer = new StringBuilder();
        String scheme = UriParser.extractScheme((String)uri, (StringBuilder)buffer);
        UriParser.canonicalizePath((StringBuilder)buffer, (int)0, (int)buffer.length(), (FileNameParser)this);
        UriParser.fixSeparators((StringBuilder)buffer);
        FileType fileType = UriParser.normalisePath((StringBuilder)buffer);
        String keys = S3Util.getFullKeysFromURI(buffer.toString());
        if (keys != null) {
            buffer.replace(buffer.indexOf(keys), buffer.indexOf(keys) + keys.length(), "");
        }
        String path = buffer.toString();
        String bucketName = UriParser.extractFirstElement((StringBuilder)buffer);
        if (keys != null) {
            bucketName = keys + bucketName;
            return new S3AFileName(scheme, bucketName, buffer.length() == 0 ? path : buffer.toString(), fileType, keys);
        }
        return new S3AFileName(scheme, bucketName, path, fileType);
    }
}

