/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.amazon.s3;

import java.util.Arrays;
import java.util.HashSet;
import java.util.stream.IntStream;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.pentaho.amazon.s3.S3Details;
import org.pentaho.di.connections.vfs.VFSDetailsComposite;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.core.vfs.connections.ui.dialog.VFSDetailsCompositeHelper;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.widget.CheckBoxVar;
import org.pentaho.di.ui.core.widget.ComboVar;
import org.pentaho.di.ui.core.widget.FileChooserVar;
import org.pentaho.di.ui.core.widget.PasswordTextVar;
import org.pentaho.di.ui.core.widget.PasswordVisibleTextVar;
import org.pentaho.di.ui.core.widget.TextVar;

public class S3DetailComposite
implements VFSDetailsComposite {
    private static final Class<?> PKG = S3DetailComposite.class;
    private final Composite wComposite;
    private final S3Details details;
    private final VFSDetailsCompositeHelper helper;
    private final PropsUI props;
    private static final String[] S3_CONNECTION_TYPE_CHOICES = new String[]{"Amazon", "Minio"};
    private static final String[] AUTH_TYPE_CHOICES = new String[]{"Access Key/Secret Key", "Credentials File"};
    private static final int TEXT_VAR_FLAGS = 18436;
    private final String[] regionChoices;
    private boolean initializingUiForFirstTime = true;
    private CCombo wS3ConnectionType;
    private CCombo wAuthType;
    private Composite wBottomHalf;
    private Composite wWidgetHolder;
    private ComboVar wRegion;
    private PasswordVisibleTextVar wAccessKey;
    private PasswordVisibleTextVar wSecretKey;
    private PasswordVisibleTextVar wSessionToken;
    private CheckBoxVar wDefaultS3Config;
    private TextVar wProfileName;
    private FileChooserVar wCredentialsFilePath;
    private TextVar wEndpoint;
    private TextVar wSignatureVersion;
    private CheckBoxVar wPathStyleAccess;
    private VariableSpace variableSpace = Variables.getADefaultVariableSpace();
    private HashSet<Control> skipControls = new HashSet();

    public S3DetailComposite(Composite composite, S3Details details, PropsUI props) {
        this.helper = new VFSDetailsCompositeHelper(PKG, props);
        this.props = props;
        this.wComposite = composite;
        this.details = details;
        this.regionChoices = details.getRegions().toArray(new String[0]);
    }

    public Object open() {
        FormLayout genLayout = new FormLayout();
        genLayout.marginWidth = 5;
        genLayout.marginHeight = 5;
        this.wComposite.setLayout((Layout)genLayout);
        Label wlTitle = this.helper.createTitleLabel(this.wComposite, "ConnectionDialog.s3.Details.Title", this.skipControls);
        Label wlConnectionType = this.createLabel("ConnectionDialog.s3.ConnectionType.Label", (Control)wlTitle, this.wComposite);
        this.wS3ConnectionType = this.createCCombo((Control)wlConnectionType, 200, this.wComposite);
        this.wS3ConnectionType.setItems(S3_CONNECTION_TYPE_CHOICES);
        this.wS3ConnectionType.select(Integer.parseInt(Const.NVL((String)this.details.getConnectionType(), (String)"0")));
        this.wBottomHalf = new Composite(this.wComposite, 0);
        FormLayout bottomHalfLayout = new FormLayout();
        this.wBottomHalf.setLayout((Layout)bottomHalfLayout);
        FormData wfdBottomHalf = new FormData();
        wfdBottomHalf.top = new FormAttachment((Control)this.wS3ConnectionType, 0);
        wfdBottomHalf.left = new FormAttachment(0, 0);
        wfdBottomHalf.right = new FormAttachment(100, 0);
        this.wBottomHalf.setLayoutData((Object)wfdBottomHalf);
        this.props.setLook((Control)this.wBottomHalf);
        this.wWidgetHolder = new Composite(this.wComposite, 0);
        this.wWidgetHolder.setVisible(false);
        this.wAuthType = this.createStandbyCombo();
        this.wAuthType.setItems(AUTH_TYPE_CHOICES);
        this.wAuthType.select(Integer.parseInt(Const.NVL((String)this.details.getAuthType(), (String)"0")));
        this.wRegion = this.createStandbyComboVar();
        this.wRegion.setItems(this.regionChoices);
        this.wRegion.select(0);
        this.wAccessKey = this.createStandbyPasswordVisibleTextVar();
        this.wSecretKey = this.createStandbyPasswordVisibleTextVar();
        this.wSessionToken = this.createStandbyPasswordVisibleTextVar();
        this.wDefaultS3Config = this.createStandByCheckBoxVar();
        this.wProfileName = this.createStandByTextVar();
        this.wCredentialsFilePath = new FileChooserVar(this.variableSpace, this.wWidgetHolder, 18436, "Browse File");
        this.wEndpoint = this.createStandByTextVar();
        this.wSignatureVersion = this.createStandByTextVar();
        this.wPathStyleAccess = this.createStandByCheckBoxVar();
        this.skipControls.add((Control)this.wBottomHalf);
        this.skipControls.add((Control)this.wWidgetHolder);
        this.setupBottomHalf();
        this.populateWidgets();
        for (CCombo cCombo : Arrays.asList(this.wS3ConnectionType, this.wAuthType)) {
            cCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    S3DetailComposite.this.setupBottomHalf();
                }
            });
        }
        this.wRegion.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                S3DetailComposite.this.details.setRegion(S3DetailComposite.this.wRegion.getText());
            }
        });
        this.wRegion.addModifyListener(modifyEvent -> this.details.setRegion(this.wRegion.getText()));
        this.wAccessKey.addModifyListener(modifyEvent -> this.details.setAccessKey(this.wAccessKey.getText()));
        this.wSecretKey.addModifyListener(modifyEvent -> this.details.setSecretKey(this.wSecretKey.getText()));
        this.wSessionToken.addModifyListener(modifyEvent -> this.details.setSessionToken(this.wSessionToken.getText()));
        this.wDefaultS3Config.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                S3DetailComposite.this.details.setDefaultS3Config(Boolean.toString(S3DetailComposite.this.wDefaultS3Config.getSelection()));
            }
        });
        this.wDefaultS3Config.getTextVar().addModifyListener(modifyEvent -> this.details.setDefaultS3ConfigVariable(this.wDefaultS3Config.getVariableName()));
        this.wCredentialsFilePath.addModifyListener(modifyEvent -> this.details.setCredentialsFilePath(this.wCredentialsFilePath.getText()));
        this.wProfileName.addModifyListener(modifyEvent -> this.details.setProfileName(this.wProfileName.getText()));
        this.wEndpoint.addModifyListener(modifyEvent -> this.details.setEndpoint(this.wEndpoint.getText()));
        this.wSignatureVersion.addModifyListener(modifyEvent -> this.details.setSignatureVersion(this.wSignatureVersion.getText()));
        this.wPathStyleAccess.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                S3DetailComposite.this.details.setPathStyleAccess(Boolean.toString(S3DetailComposite.this.wPathStyleAccess.getSelection()));
            }
        });
        this.wPathStyleAccess.getTextVar().addModifyListener(modifyEvent -> this.details.setPathStyleAccessVariable(this.wPathStyleAccess.getVariableName()));
        VFSDetailsCompositeHelper.setupCompositeResizeListener((Composite)this.wComposite);
        this.initializingUiForFirstTime = false;
        return this.wComposite;
    }

    private void setupBottomHalf() {
        this.setupBottomHalf(this.computeComboIndex(this.wS3ConnectionType.getText(), S3_CONNECTION_TYPE_CHOICES, 0), this.computeComboIndex(this.wAuthType.getText(), AUTH_TYPE_CHOICES, 0));
    }

    private void setupBottomHalf(int s3ConnectionType, int authType) {
        if (this.initializingUiForFirstTime || s3ConnectionType != this.stringToInteger(this.details.getConnectionType())) {
            this.details.setConnectionType(String.valueOf(s3ConnectionType));
        }
        if (this.initializingUiForFirstTime || authType != this.stringToInteger(this.details.getAuthType())) {
            this.details.setAuthType(String.valueOf(authType));
        }
        for (Control c : this.wBottomHalf.getChildren()) {
            if (c instanceof Label) {
                c.dispose();
                continue;
            }
            c.setParent(this.wWidgetHolder);
        }
        switch (s3ConnectionType * 10 + authType) {
            case 0: {
                this.moveWidgetToBottomHalf((Control)this.wAuthType, "ConnectionDialog.s3.AuthType.Label", null, 200);
                this.moveWidgetToBottomHalf((Control)this.wRegion, "ConnectionDialog.s3.Region.Label", (Control)this.wAuthType, 200);
                this.moveWidgetToBottomHalf((Control)this.wAccessKey, "ConnectionDialog.s3.AccessKey.Label", (Control)this.wRegion);
                this.moveWidgetToBottomHalf((Control)this.wSecretKey, "ConnectionDialog.s3.SecretKey.Label", (Control)this.wAccessKey);
                this.moveWidgetToBottomHalf((Control)this.wSessionToken, "ConnectionDialog.s3.sessionToken.Label", (Control)this.wSecretKey);
                this.moveWidgetToBottomHalf((Control)this.wDefaultS3Config, "ConnectionDialog.s3.DefaultS3Config.Label", (Control)this.wSessionToken);
                break;
            }
            case 1: {
                this.moveWidgetToBottomHalf((Control)this.wAuthType, "ConnectionDialog.s3.AuthType.Label", null, 200);
                this.moveWidgetToBottomHalf((Control)this.wRegion, "ConnectionDialog.s3.Region.Label", (Control)this.wAuthType, 200);
                this.moveWidgetToBottomHalf((Control)this.wProfileName, "ConnectionDialog.s3.ProfileName.Label", (Control)this.wRegion);
                this.moveWidgetToBottomHalf((Control)this.wCredentialsFilePath, "ConnectionDialog.s3.CredentialsFilePath.Label", (Control)this.wProfileName);
                break;
            }
            case 10: 
            case 11: {
                this.moveWidgetToBottomHalf((Control)this.wAccessKey, "ConnectionDialog.s3.AccessKey.Label", null);
                this.moveWidgetToBottomHalf((Control)this.wSecretKey, "ConnectionDialog.s3.SecretKey.Label", (Control)this.wAccessKey);
                this.moveWidgetToBottomHalf((Control)this.wEndpoint, "ConnectionDialog.s3.Endpoint.Label", (Control)this.wSecretKey);
                this.moveWidgetToBottomHalf((Control)this.wSignatureVersion, "ConnectionDialog.s3.SignatureVersion.Label", (Control)this.wEndpoint);
                this.moveWidgetToBottomHalf((Control)this.wPathStyleAccess, "ConnectionDialog.s3.PathStyleAccess.Label", (Control)this.wSignatureVersion);
                this.moveWidgetToBottomHalf((Control)this.wDefaultS3Config, "ConnectionDialog.s3.DefaultS3Config.Label", (Control)this.wPathStyleAccess);
                break;
            }
        }
        this.wBottomHalf.layout();
        this.wComposite.pack();
        VFSDetailsCompositeHelper.updateScrollableRegion((Composite)this.wComposite);
    }

    private void populateWidgets() {
        this.wS3ConnectionType.select(this.stringToInteger(this.details.getConnectionType()));
        this.wAuthType.select(this.stringToInteger(this.details.getAuthType()));
        this.wAccessKey.setText(Const.NVL((String)this.details.getAccessKey(), (String)""));
        this.wSecretKey.setText(Const.NVL((String)this.details.getSecretKey(), (String)""));
        this.wSessionToken.setText(Const.NVL((String)this.details.getSessionToken(), (String)""));
        this.wDefaultS3Config.setSelection(Boolean.parseBoolean(Const.NVL((String)this.details.getDefaultS3Config(), (String)"false")));
        this.wDefaultS3Config.setVariableName(Const.NVL((String)this.details.getDefaultS3ConfigVariable(), (String)""));
        int regionIndex = this.computeComboIndex(Const.NVL((String)this.details.getRegion(), (String)this.regionChoices[0]), this.regionChoices, -1);
        if (regionIndex != -1) {
            this.wRegion.select(regionIndex);
        } else {
            this.wRegion.setText(this.details.getRegion());
        }
        this.wProfileName.setText(Const.NVL((String)this.details.getProfileName(), (String)""));
        this.wCredentialsFilePath.setText(Const.NVL((String)this.details.getCredentialsFilePath(), (String)""));
        this.wEndpoint.setText(Const.NVL((String)this.details.getEndpoint(), (String)""));
        this.wSignatureVersion.setText(Const.NVL((String)this.details.getSignatureVersion(), (String)""));
        this.wPathStyleAccess.setSelection(Boolean.parseBoolean(Const.NVL((String)this.details.getPathStyleAccess(), (String)"false")));
        this.wPathStyleAccess.setVariableName(Const.NVL((String)this.details.getPathStyleAccessVariable(), (String)""));
    }

    private Label createLabel(String key, Control topWidget, Composite composite) {
        return this.helper.createLabel(composite, 16448, key, topWidget);
    }

    private PasswordTextVar createStandbyPasswordTextVar() {
        return new PasswordTextVar(this.variableSpace, this.wWidgetHolder, 18436);
    }

    private PasswordVisibleTextVar createStandbyPasswordVisibleTextVar() {
        return new PasswordVisibleTextVar(this.variableSpace, this.wWidgetHolder, 18432);
    }

    private TextVar createStandByTextVar() {
        return new TextVar(this.variableSpace, this.wWidgetHolder, 18436);
    }

    private CCombo createCCombo(Control topWidget, int width, Composite composite) {
        return this.helper.createCCombo(composite, 18436, topWidget, width);
    }

    private CCombo createStandbyCombo() {
        return new CCombo(this.wWidgetHolder, 18436);
    }

    private ComboVar createStandbyComboVar() {
        return new ComboVar(this.variableSpace, this.wWidgetHolder, 18436);
    }

    private CheckBoxVar createStandByCheckBoxVar() {
        return new CheckBoxVar(this.variableSpace, this.wWidgetHolder, 32);
    }

    private void moveWidgetToBottomHalf(Control targetWidget, String labelKey, Control topWidget) {
        this.moveWidgetToBottomHalf(targetWidget, labelKey, topWidget, 0);
    }

    private void moveWidgetToBottomHalf(Control targetWidget, String labelKey, Control topWidget, int width) {
        Label lbl = this.createLabel(labelKey, topWidget, this.wBottomHalf);
        targetWidget.setParent(this.wBottomHalf);
        this.props.setLook(targetWidget);
        targetWidget.setLayoutData((Object)this.helper.getFormDataField((Control)lbl, width));
    }

    public void close() {
        this.wComposite.dispose();
        if (this.wBottomHalf != null) {
            this.wBottomHalf.dispose();
        }
    }

    private int stringToInteger(String value) {
        return Integer.parseInt(Const.NVL((String)value, (String)"0"));
    }

    private int computeComboIndex(String targetValue, String[] choices, int notFoundReturnValue) {
        return IntStream.range(0, choices.length).filter(i -> choices[i].equals(targetValue)).findFirst().orElse(notFoundReturnValue);
    }

    public String validate() {
        int regionIndex = this.computeComboIndex(Const.NVL((String)this.details.getRegion(), (String)this.regionChoices[0]), this.regionChoices, -1);
        if (regionIndex == -1 && !StringUtil.isVariable((String)this.details.getRegion())) {
            return BaseMessages.getString(PKG, (String)"ConnectionDialog.s3.Validate.badRegionText", (String[])new String[0]);
        }
        return null;
    }
}

