/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.util;

import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;

public class ManifestUtil {
    private ManifestUtil() {
    }

    public static Manifest getManifest() {
        return ManifestUtil.getManifest(ManifestUtil.class);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Manifest getManifest(Class<?> clazz) {
        URL codeBase = clazz.getProtectionDomain().getCodeSource().getLocation();
        if (!codeBase.getPath().endsWith(".jar")) return null;
        try (JarInputStream jin2222 = new JarInputStream(codeBase.openStream());){
            Manifest manifest2 = jin2222.getManifest();
            if (null != manifest2) {
                Manifest manifest3 = manifest2;
                return manifest3;
            }
        }
        catch (Exception jin2222) {
            // empty catch block
        }
        try {
            Class<?> virtualFile = Class.forName("org.jboss.vfs.VirtualFile");
            Method getChild = virtualFile.getMethod("getChild", String.class);
            Object manifestVFile = getChild.invoke(codeBase.getContent(), "META-INF/MANIFEST.MF");
            Method openStream = virtualFile.getMethod("openStream", new Class[0]);
            try (InputStream manifestStream = (InputStream)openStream.invoke(manifestVFile, new Object[0]);){
                Manifest manifest = new Manifest(manifestStream);
                return manifest;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

