/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.services.solution;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.pentaho.platform.api.engine.IActionParameter;
import org.pentaho.platform.api.engine.IOutputHandler;
import org.pentaho.platform.api.engine.IPentahoRequestContext;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPentahoUrlFactory;
import org.pentaho.platform.api.engine.ISolutionEngine;
import org.pentaho.platform.engine.core.output.SimpleOutputHandler;
import org.pentaho.platform.engine.core.solution.SimpleParameterProvider;
import org.pentaho.platform.engine.core.system.PentahoRequestContextHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.core.system.StandaloneSession;
import org.pentaho.platform.engine.services.solution.SolutionEngine;
import org.pentaho.platform.util.web.SimpleUrlFactory;

public class SolutionEngineAgent {
    private HashMap<String, String> parameters = new HashMap();
    private String userId;
    private String actionSequence;
    private String description;
    private ByteArrayOutputStream outputStream;
    private ISolutionEngine solutionEngine = null;

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setParamter(String name, String value) {
        this.parameters.put(name, value);
    }

    public void setActionSequence(String actionSequence) {
        this.actionSequence = actionSequence;
    }

    public String getActionSequence() {
        return this.actionSequence;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public String getOutput(String name) {
        if (name == null || "default".equals(name) || "".equals(name)) {
            return this.outputStream.toString();
        }
        IActionParameter output = this.solutionEngine.getExecutionContext().getOutputParameter(name);
        return output.getStringValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute() {
        PentahoSystem.systemEntryPoint();
        try {
            StandaloneSession session = new StandaloneSession(this.userId);
            this.solutionEngine = PentahoSystem.get(SolutionEngine.class, session);
            this.solutionEngine.init((IPentahoSession)session);
            SimpleParameterProvider parameterProvider = new SimpleParameterProvider(this.parameters);
            HashMap<String, SimpleParameterProvider> parameterProviderMap = new HashMap<String, SimpleParameterProvider>();
            parameterProviderMap.put("request", parameterProvider);
            IPentahoRequestContext requestContext = PentahoRequestContextHolder.getRequestContext();
            SimpleUrlFactory urlFactory = new SimpleUrlFactory(requestContext.getContextPath());
            String processName = this.description;
            boolean persisted = false;
            ArrayList messages = new ArrayList();
            this.outputStream = new ByteArrayOutputStream(0);
            SimpleOutputHandler outputHandler = null;
            if (this.outputStream != null) {
                outputHandler = new SimpleOutputHandler(this.outputStream, false);
                outputHandler.setOutputPreference(3);
            }
            this.solutionEngine.execute(this.actionSequence, processName, false, true, null, persisted, parameterProviderMap, (IOutputHandler)outputHandler, null, (IPentahoUrlFactory)urlFactory, messages);
        }
        finally {
            PentahoSystem.systemExitPoint();
        }
        return this.solutionEngine.getStatus();
    }
}

