/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.services.solution;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.engine.services.messages.Messages;
import org.pentaho.platform.util.beans.PropertyNameFormatter;

public class ActionSequenceCompatibilityFormatter
implements PropertyNameFormatter {
    Log logger = LogFactory.getLog(ActionSequenceCompatibilityFormatter.class);

    @Override
    public String format(String name) {
        return this.compatibilityToCamelCase(name);
    }

    protected String compatibilityToCamelCase(String name) {
        String[] parts = name.split("-", 0);
        if (parts.length > 1) {
            String camelCaseName = "";
            for (int i = 0; i < parts.length; ++i) {
                camelCaseName = i > 0 ? camelCaseName + StringUtils.capitalize((String)parts[i]) : camelCaseName + parts[i];
            }
            this.logger.warn((Object)Messages.getInstance().getString("ActionSequenceCompatibilityFormatter.WARN_USING_IO_COMPATIBILITY_MODE", camelCaseName, name));
            return camelCaseName;
        }
        return name;
    }
}

