/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.services.connection.datasource.dbcp;

import javax.sql.DataSource;
import org.pentaho.database.model.IDatabaseConnection;
import org.pentaho.platform.api.data.DBDatasourceServiceException;
import org.pentaho.platform.api.data.IDBDatasourceService;
import org.pentaho.platform.engine.services.connection.datasource.dbcp.NonPooledOrJndiDatasourceService;

public class DynamicallyPooledOrJndiDatasourceService
extends NonPooledOrJndiDatasourceService {
    private IDBDatasourceService pooledDatasourceService;
    private IDBDatasourceService nonPooledDatasourceService;

    @Override
    public DataSource resolveDatabaseConnection(IDatabaseConnection databaseConnection) throws DBDatasourceServiceException {
        return databaseConnection.isUsingConnectionPool() ? this.getPooledDatasourceService().resolveDatabaseConnection(databaseConnection) : this.getNonPooledDatasourceService().getDataSource(databaseConnection.getName());
    }

    public IDBDatasourceService getPooledDatasourceService() {
        return this.pooledDatasourceService;
    }

    public void setPooledDatasourceService(IDBDatasourceService pooledDatasourceService) {
        this.pooledDatasourceService = pooledDatasourceService;
    }

    public IDBDatasourceService getNonPooledDatasourceService() {
        return this.nonPooledDatasourceService;
    }

    public void setNonPooledDatasourceService(IDBDatasourceService nonPooledDatasourceService) {
        this.nonPooledDatasourceService = nonPooledDatasourceService;
    }
}

