/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.services.connection;

import java.util.Properties;
import org.pentaho.commons.connection.IPentahoConnection;
import org.pentaho.platform.api.engine.ILogger;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.ObjectFactoryException;
import org.pentaho.platform.engine.core.system.IPentahoLoggingConnection;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.messages.Messages;
import org.pentaho.platform.util.logging.Logger;

public class PentahoConnectionFactory {
    private static final String CONNECTION_PREFIX = "connection-";

    public static IPentahoConnection getConnection(String datasourceType, IPentahoSession session, ILogger logger) {
        return PentahoConnectionFactory.getConnection(datasourceType, (Properties)null, session, logger);
    }

    public static IPentahoConnection getConnection(String datasourceType, String connectStr, IPentahoSession session, ILogger logger) {
        Properties props = new Properties();
        props.put("jndiName", connectStr);
        return PentahoConnectionFactory.getConnection(datasourceType, props, session, logger);
    }

    public static IPentahoConnection getConnection(String datasourceType, String driver, String location, String userName, String password, IPentahoSession session, ILogger logger) {
        Properties props = new Properties();
        if (driver != null) {
            props.put("driver", driver);
        }
        if (location != null) {
            props.put("location", location);
        }
        if (userName != null) {
            props.put("userName", userName);
        }
        if (password != null) {
            props.put("password", password);
        }
        return PentahoConnectionFactory.getConnection(datasourceType, props, session, logger);
    }

    public static IPentahoConnection getConnection(String datasourceType, Properties properties, IPentahoSession session, ILogger logger) {
        String key = CONNECTION_PREFIX + datasourceType;
        IPentahoConnection connection = null;
        try {
            connection = (IPentahoConnection)PentahoSystem.getObjectFactory().get(IPentahoConnection.class, key, session);
            if (connection instanceof IPentahoLoggingConnection) {
                ((IPentahoLoggingConnection)connection).setLogger(logger);
            }
            connection.setProperties(properties);
        }
        catch (ObjectFactoryException e) {
            Logger.error(PentahoSystem.class.getName(), Messages.getInstance().getErrorString("PentahoConnectionFactory.ERROR_0001_COULD_NOT_CREATE_CONNECTION", key), (Throwable)e);
        }
        return connection;
    }
}

