/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.services.actionsequence;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.ListOrderedMap;
import org.dom4j.Element;
import org.dom4j.Node;
import org.pentaho.platform.api.engine.IComponent;
import org.pentaho.platform.api.engine.ILogger;
import org.pentaho.platform.api.engine.ISolutionActionDefinition;
import org.pentaho.platform.engine.services.actionsequence.SequenceDefinition;
import org.pentaho.platform.util.logging.Logger;
import org.pentaho.platform.util.xml.dom4j.XmlDom4JHelper;

public class ActionDefinition
implements ISolutionActionDefinition {
    private int errorCode;
    private int loggingLevel;
    private List preExecuteAuditList;
    private List postExecuteAuditList;
    private String description;
    private String author;
    private String help;
    private String iconUrl;
    private Node componentNode;
    private Node actionRootNode;
    private IComponent component;
    private String componentName;
    private Map actionInputDefinitions;
    private Map actionInputMapping;
    private Map actionOutputDefinitions;
    private Map actionOutputMapping;
    private Map actionResourceMapping;
    private boolean hasActionResources = false;

    public ActionDefinition(Node actionRootNode, ILogger logger) {
        this.actionRootNode = actionRootNode;
        this.errorCode = 0;
        this.actionInputDefinitions = new ListOrderedMap();
        this.actionInputMapping = new ListOrderedMap();
        this.errorCode = SequenceDefinition.parseParameters(actionRootNode, logger, "action-inputs/*", this.actionInputDefinitions, this.actionInputMapping, true);
        this.actionOutputDefinitions = new ListOrderedMap();
        this.actionOutputMapping = new ListOrderedMap();
        this.errorCode = SequenceDefinition.parseParameters(actionRootNode, logger, "action-outputs/*", this.actionOutputDefinitions, this.actionOutputMapping, false);
        this.actionResourceMapping = new ListOrderedMap();
        if (actionRootNode.selectNodes("action-resources/*").size() > 0) {
            this.hasActionResources = true;
            this.errorCode = SequenceDefinition.parseActionResourceDefinitions(actionRootNode, logger, "action-resources/*", this.actionResourceMapping);
        }
        this.componentName = XmlDom4JHelper.getNodeText("component-name", actionRootNode);
        String loggingLevelString = XmlDom4JHelper.getNodeText("logging-level", actionRootNode);
        this.loggingLevel = Logger.getLogLevel(loggingLevelString);
        this.componentNode = actionRootNode.selectSingleNode("component-definition");
        if (this.componentNode == null) {
            this.componentNode = ((Element)actionRootNode).addElement("component-definition");
        }
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getMappedInputName(String name) {
        return (String)this.actionInputMapping.get(name);
    }

    public Map getActionInputDefinitions() {
        return this.actionInputDefinitions;
    }

    public String getMappedOutputName(String name) {
        return (String)this.actionOutputMapping.get(name);
    }

    public Map getActionOutputDefinitions() {
        return this.actionOutputDefinitions;
    }

    public String getMappedResourceName(String name) {
        return (String)this.actionResourceMapping.get(name);
    }

    public List getActionResourceDefinitionNames() {
        return new ArrayList(this.actionResourceMapping.keySet());
    }

    public boolean hasActionResources() {
        return this.hasActionResources;
    }

    public void setLoggingLevel(int loggingLevel) {
        this.loggingLevel = loggingLevel;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public Node getComponentSection() {
        return this.componentNode;
    }

    public Node getNode() {
        return this.actionRootNode;
    }

    public boolean getSyncPreference() {
        return false;
    }

    public int getLoggingLevel() {
        return this.loggingLevel;
    }

    public List getPostExecuteAuditList() {
        return this.preExecuteAuditList;
    }

    public List getPreExecuteAuditList() {
        return this.postExecuteAuditList;
    }

    public IComponent getComponent() {
        return this.component;
    }

    public void setComponent(IComponent component) {
        this.component = component;
    }

    public String getIconUrl() {
        return this.iconUrl;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getDescription() {
        return this.description;
    }

    public String getHelp() {
        return this.help;
    }
}

