/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.security;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.pentaho.platform.api.security.ILoginAttemptService;

public class LoginAttemptService
implements ILoginAttemptService {
    private LoadingCache<String, Integer> attemptsCache;
    private final int maxAttempt;

    public LoginAttemptService(int maxAttempt, int cacheMinutes) {
        this.maxAttempt = maxAttempt;
        this.attemptsCache = CacheBuilder.newBuilder().expireAfterWrite((long)cacheMinutes, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, Integer>(){

            public Integer load(String key) {
                return 0;
            }
        });
    }

    public void loginSucceeded(String key) {
        this.attemptsCache.invalidate((Object)key);
    }

    public void loginFailed(String key) {
        int attempts = 0;
        try {
            attempts = (Integer)this.attemptsCache.get((Object)key);
        }
        catch (ExecutionException e) {
            attempts = 0;
        }
        this.attemptsCache.put((Object)key, (Object)(++attempts));
    }

    public boolean isBlocked(String key) {
        try {
            return (Integer)this.attemptsCache.get((Object)key) >= this.maxAttempt;
        }
        catch (ExecutionException e) {
            return false;
        }
    }
}

