/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.core.system.objfac.references;

import java.util.Map;
import java.util.WeakHashMap;
import org.pentaho.platform.api.engine.IObjectCreator;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.ObjectFactoryException;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.objfac.references.AbstractPentahoObjectReference;

public class SessionBoundPentahoObjectReference<T>
extends AbstractPentahoObjectReference<T> {
    private final IObjectCreator<T> creator;
    private static WeakHashMap<IPentahoSession, Map<Class<?>, Object>> cache = new WeakHashMap();

    public SessionBoundPentahoObjectReference(Class<T> type, IObjectCreator<T> creator, Map<String, Object> attributes, Integer priority) {
        super(type, attributes, priority);
        this.creator = creator;
    }

    @Override
    protected T createObject() throws ObjectFactoryException {
        IPentahoSession session = PentahoSessionHolder.getSession();
        Map<Class<?>, Object> classObjectMap = cache.get(session);
        if (classObjectMap == null) {
            classObjectMap = new WeakHashMap();
            cache.put(session, classObjectMap);
        }
        if (classObjectMap.containsKey(this.getObjectClass())) {
            return (T)classObjectMap.get(this.getObjectClass());
        }
        Object newObject = this.creator.create(session);
        classObjectMap.put(this.getObjectClass(), newObject);
        return (T)newObject;
    }

    public static class Builder<T>
    extends BuilderBase<T, Builder<T>> {
        public Builder(Class<T> type) {
            this.type(type);
        }

        @Override
        public Builder<T> self() {
            return this;
        }
    }

    private static abstract class BuilderBase<T, B extends BuilderBase<T, B>>
    extends AbstractPentahoObjectReference.Builder<T, B> {
        IObjectCreator<T> creator;

        private BuilderBase() {
        }

        public B creator(IObjectCreator<T> creator) {
            this.creator = creator;
            return (B)((BuilderBase)this.self());
        }

        @Override
        public SessionBoundPentahoObjectReference<T> build() {
            return new SessionBoundPentahoObjectReference<T>(this.type, this.creator, this.attributes, this.priority);
        }
    }
}

