/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.core.system.objfac;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IPentahoInitializer;
import org.pentaho.platform.api.engine.IPentahoObjectFactory;
import org.pentaho.platform.api.engine.IPentahoObjectReference;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.ObjectFactoryException;
import org.pentaho.platform.engine.core.messages.Messages;
import org.pentaho.platform.engine.core.system.StandaloneSession;
import org.pentaho.platform.engine.core.system.objfac.spring.SpringScopeSessionHolder;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.ConfigurableApplicationContext;

public abstract class AbstractSpringPentahoObjectFactory
implements IPentahoObjectFactory {
    protected ConfigurableApplicationContext beanFactory;
    protected static final Log logger = LogFactory.getLog(AbstractSpringPentahoObjectFactory.class);
    protected static final String PRIORITY = "priority";
    private BeanDefinitionPriorityComparitor priorityComparitor = new BeanDefinitionPriorityComparitor();
    private String name;

    protected AbstractSpringPentahoObjectFactory() {
    }

    protected AbstractSpringPentahoObjectFactory(String name) {
        this.name = name;
    }

    public <T> T get(Class<T> interfaceClass, IPentahoSession session) throws ObjectFactoryException {
        return this.get(interfaceClass, null, session);
    }

    public <T> T get(Class<T> interfaceClass, String key, IPentahoSession session) throws ObjectFactoryException {
        return this.retreiveObject(interfaceClass, key, session, null);
    }

    public <T> T get(Class<T> interfaceClass, IPentahoSession session, Map<String, String> props) throws ObjectFactoryException {
        return this.retreiveObject(interfaceClass, null, session, props);
    }

    public <T> List<T> getAll(Class<T> interfaceClass, IPentahoSession curSession, Map<String, String> properties) throws ObjectFactoryException {
        return this.retreiveObjects(interfaceClass, curSession, properties);
    }

    public <T> List<T> getAll(Class<T> interfaceClass, IPentahoSession curSession) throws ObjectFactoryException {
        return this.retreiveObjects(interfaceClass, curSession, null);
    }

    protected Object instanceClass(String simpleName) throws ObjectFactoryException {
        return this.instanceClass(simpleName, null);
    }

    protected Object instanceClass(String simpleName, String key) throws ObjectFactoryException {
        Object object = null;
        try {
            if (this.beanFactory.containsBean(simpleName)) {
                object = this.beanFactory.getType(simpleName).newInstance();
            } else if (key != null) {
                object = this.beanFactory.getType(key).newInstance();
            }
        }
        catch (Exception e) {
            String msg = Messages.getInstance().getString("AbstractSpringPentahoObjectFactory.WARN_FAILED_TO_CREATE_OBJECT", key);
            throw new ObjectFactoryException(msg, (Throwable)e);
        }
        return object;
    }

    protected Object instanceClass(Class<?> interfaceClass, String key) throws ObjectFactoryException {
        Object object = null;
        try {
            object = key != null ? this.beanFactory.getType(key).newInstance() : this.beanFactory.getType(interfaceClass.getSimpleName()).newInstance();
        }
        catch (Exception e) {
            String msg = Messages.getInstance().getString("AbstractSpringPentahoObjectFactory.WARN_FAILED_TO_CREATE_OBJECT", key);
            throw new ObjectFactoryException(msg, (Throwable)e);
        }
        return object;
    }

    private <T> T retrieveViaSpring(Class<T> interfaceClass) throws ObjectFactoryException {
        return this.retrieveViaSpring(interfaceClass, null);
    }

    private <T> T retrieveViaSpring(Class<T> interfaceClass, Map<String, String> props) throws ObjectFactoryException {
        Object object = null;
        try {
            String beanName = interfaceClass.getSimpleName();
            if (!this.beanFactory.getBeanFactory().containsBean(beanName)) {
                throw new IllegalStateException("No bean found for given type");
            }
            object = this.beanFactory.getBean(beanName);
        }
        catch (Throwable t) {
            String msg = Messages.getInstance().getString("AbstractSpringPentahoObjectFactory.WARN_FAILED_TO_RETRIEVE_OBJECT", interfaceClass.getSimpleName());
            throw new ObjectFactoryException(msg, t);
        }
        if (!interfaceClass.isAssignableFrom(object.getClass())) {
            throw new IllegalStateException("Object retrived from Spring not expected type: " + interfaceClass.getSimpleName());
        }
        return (T)object;
    }

    private BeanDefinition getBeanDefinitionFromFactory(String name) {
        return this.beanFactory.getBeanFactory().getBeanDefinition(name);
    }

    protected Object retrieveViaSpring(String beanId) throws ObjectFactoryException {
        Object object;
        try {
            object = this.beanFactory.getBean(beanId);
        }
        catch (Throwable t) {
            String msg = Messages.getInstance().getString("AbstractSpringPentahoObjectFactory.WARN_FAILED_TO_RETRIEVE_OBJECT", beanId);
            throw new ObjectFactoryException(msg, t);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T retreiveObject(Class<T> interfaceClass, String key, IPentahoSession session, Map<String, String> props) throws ObjectFactoryException {
        Object object;
        block13: {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Attempting to get an instance of [" + interfaceClass.getSimpleName() + "] while in session [" + session + "]"));
            }
            ClassLoader originalClassLoader = null;
            try {
                originalClassLoader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                if (session instanceof StandaloneSession) {
                    SpringScopeSessionHolder.SESSION.set(session);
                    try {
                        object = key != null ? this.retrieveViaSpring(key) : this.retrieveViaSpring(interfaceClass, props);
                        break block13;
                    }
                    catch (Throwable t) {
                        logger.debug((Object)"Retrieving object from Pentaho session map (not Spring).");
                        try {
                            object = session.getAttribute(interfaceClass.getSimpleName());
                            if (object == null) {
                                object = this.instanceClass(interfaceClass, key);
                                session.setAttribute(interfaceClass.getSimpleName(), object);
                            }
                            break block13;
                        }
                        catch (Throwable tt) {
                            String msg = Messages.getInstance().getString("AbstractSpringPentahoObjectFactory.WARN_FAILED_TO_RETRIEVE_OBJECT", interfaceClass.getSimpleName());
                            throw new ObjectFactoryException(msg, tt);
                        }
                    }
                }
                SpringScopeSessionHolder.SESSION.set(null);
                object = key != null ? this.retrieveViaSpring(key) : this.retrieveViaSpring(interfaceClass, props);
            }
            finally {
                if (originalClassLoader != null) {
                    Thread.currentThread().setContextClassLoader(originalClassLoader);
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(" Got an instance of [" + interfaceClass.getSimpleName() + "]: " + object));
        }
        if (object instanceof IPentahoInitializer) {
            ((IPentahoInitializer)object).init(session);
        }
        return (T)object;
    }

    protected <T> List<T> retreiveObjects(Class<T> type, IPentahoSession session, Map<String, String> properties) throws ObjectFactoryException {
        T object;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Attempting to get an instance of [" + type.getSimpleName() + "] while in session [" + session + "]"));
        }
        if ((object = this.retrieveViaSpring(type)) != null && logger.isDebugEnabled()) {
            logger.debug((Object)(" Got an instance of [" + type.getSimpleName() + "]: " + object));
        }
        return Collections.singletonList(object);
    }

    public boolean objectDefined(String key) {
        return this.beanFactory.containsBean(key);
    }

    public boolean objectDefined(Class<?> clazz) {
        return this.beanFactory.containsBean(clazz.getSimpleName());
    }

    public Class getImplementingClass(String key) {
        return this.beanFactory.getType(key);
    }

    protected void setBeanFactory(ConfigurableApplicationContext context) {
        this.beanFactory = context;
    }

    public <T> IPentahoObjectReference<T> getObjectReference(Class<T> clazz, IPentahoSession curSession) throws ObjectFactoryException {
        return this.getObjectReference(clazz, curSession, null);
    }

    public <T> IPentahoObjectReference<T> getObjectReference(Class<T> clazz, IPentahoSession curSession, Map<String, String> properties) throws ObjectFactoryException {
        return null;
    }

    public <T> List<IPentahoObjectReference<T>> getObjectReferences(Class<T> interfaceClass, IPentahoSession curSession) throws ObjectFactoryException {
        return this.getObjectReferences(interfaceClass, curSession, null);
    }

    public <T> List<IPentahoObjectReference<T>> getObjectReferences(Class<T> interfaceClass, IPentahoSession curSession, Map<String, String> properties) throws ObjectFactoryException {
        return Collections.emptyList();
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return this.beanFactory.getBeanFactory().hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractSpringPentahoObjectFactory)) {
            return false;
        }
        AbstractSpringPentahoObjectFactory that = (AbstractSpringPentahoObjectFactory)o;
        return this.beanFactory.equals(that.beanFactory);
    }

    protected static class BeanDefinitionNamePair {
        public String name;
        public BeanDefinition definition;

        public BeanDefinitionNamePair(String name, BeanDefinition definition) {
            this.definition = definition;
            this.name = name;
        }
    }

    protected class BeanDefinitionPriorityComparitor
    implements Comparator<BeanDefinitionNamePair> {
        protected BeanDefinitionPriorityComparitor() {
        }

        @Override
        public int compare(BeanDefinitionNamePair beanDefinitionNamePair, BeanDefinitionNamePair beanDefinitionNamePair1) {
            int pri2;
            int pri1 = this.computePriority(beanDefinitionNamePair.definition);
            if (pri1 == (pri2 = this.computePriority(beanDefinitionNamePair1.definition))) {
                return 0;
            }
            if (pri1 < pri2) {
                return 1;
            }
            return -1;
        }

        private int computePriority(BeanDefinition ref) {
            if (ref == null || ref.getAttribute(AbstractSpringPentahoObjectFactory.PRIORITY) == null) {
                return 0;
            }
            try {
                int val = Integer.parseInt(ref.getAttribute(AbstractSpringPentahoObjectFactory.PRIORITY).toString());
                return val;
            }
            catch (NumberFormatException e) {
                logger.error((Object)("bean of type " + ref.getBeanClassName() + " has an invalid priority value, only numeric allowed"));
                return 0;
            }
        }
    }
}

