/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.core.system;

import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.mt.ITenant;
import org.pentaho.platform.api.mt.ITenantedPrincipleNameResolver;
import org.pentaho.platform.core.mt.Tenant;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;

public class TenantUtils {
    public static final String TENANTID_SINGLE_TENANT = "tenant0";

    public static ITenant getCurrentTenant() {
        ITenantedPrincipleNameResolver tenantedUserNameUtils;
        IPentahoSession pentahoSession = PentahoSessionHolder.getSession();
        if (pentahoSession == null) {
            throw new IllegalStateException();
        }
        String tenantId = (String)pentahoSession.getAttribute("org.pentaho.tenantId");
        if (tenantId == null && (tenantedUserNameUtils = PentahoSystem.get(ITenantedPrincipleNameResolver.class, "tenantedUserNameUtils", pentahoSession)) != null) {
            ITenant tenant = tenantedUserNameUtils.getTenant(pentahoSession.getId());
            pentahoSession.setAttribute("org.pentaho.tenantId", (Object)tenant.getId());
            return new Tenant(tenant.getId(), true);
        }
        return new Tenant(tenantId, true);
    }

    public static String getDefaultTenant() {
        return TENANTID_SINGLE_TENANT;
    }

    public static boolean isAccessibleTenant(ITenant tenant) {
        ITenant currentTenant = TenantUtils.getCurrentTenant();
        try {
            return currentTenant.getId() == null || tenant.getRootFolderAbsolutePath().startsWith(currentTenant.getRootFolderAbsolutePath() + "/") || tenant.equals(currentTenant);
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }
}

