/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.infobrightoutput;

import com.infobright.etl.model.DataFormat;
import com.infobright.io.InfobrightNamedPipeLoader;
import java.nio.charset.Charset;
import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.infobrightoutput.InfobrightLoader;
import org.pentaho.di.trans.steps.infobrightoutput.InfobrightLoaderData;
import org.pentaho.di.trans.steps.tableoutput.TableOutputMeta;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

@Step(id="InfobrightOutput", name="BaseStep.TypeLongDesc.InfobrightOutput", description="BaseStep.TypeTooltipDesc.InfobrightOutput", categoryDescription="i18n:org.pentaho.di.trans.step:BaseStep.Category.Bulk", image="BLKIB.svg", documentationUrl="https://pentaho-community.atlassian.net/wiki/display/EAI/Infobright%20Loader", i18nPackageName="org.pentaho.di.trans.steps.infobrightoutput")
public class InfobrightLoaderMeta
extends TableOutputMeta
implements StepMetaInterface {
    private static final String TAG_DATA_FORMAT = "data_format";
    private static final String TAG_CHARSET = "charset";
    private static final String TAG_AGENT_PORT = "agent_port";
    private static final String TAG_DEBUG_FILE = "debug_file";
    private DataFormat dataFormat;
    private boolean rejectErrors = false;
    private Charset charset;
    private int agentPort;
    private String debugFile;

    public InfobrightLoaderMeta() {
        this.setIgnoreErrors(false);
        this.setTruncateTable(false);
    }

    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        InfobrightLoader loader = new InfobrightLoader(stepMeta, stepDataInterface, cnr, tr, trans);
        return loader;
    }

    public StepDataInterface getStepData() {
        return new InfobrightLoaderData();
    }

    public Object clone() {
        InfobrightLoaderMeta retval = (InfobrightLoaderMeta)((Object)super.clone());
        return retval;
    }

    public String getInfobrightProductType() {
        return this.dataFormat.getDisplayText();
    }

    public void setDataFormat(DataFormat dataFormat) {
        this.dataFormat = dataFormat;
    }

    public DataFormat getDataFormat() {
        return this.dataFormat;
    }

    public void setDefault() {
        this.dataFormat = DataFormat.TXT_VARIABLE;
        this.agentPort = 5555;
        this.charset = InfobrightNamedPipeLoader.DEFAULT_CHARSET;
    }

    public String getDebugFile() {
        return this.debugFile;
    }

    public void setCharset(Charset charset2) {
        this.charset = charset2;
    }

    public void setAgentPort(int agentPort2) {
        this.agentPort = agentPort2;
    }

    public void setDebugFile(String debugFile) {
        this.debugFile = "".equals(debugFile.trim()) ? null : debugFile;
    }

    public String getXML() {
        String ret = super.getXML();
        ret = ret + new String("    " + XMLHandler.addTagValue((String)TAG_DATA_FORMAT, (String)this.dataFormat.toString()));
        ret = ret + new String("    " + XMLHandler.addTagValue((String)TAG_AGENT_PORT, (int)this.agentPort));
        ret = ret + new String("    " + XMLHandler.addTagValue((String)TAG_CHARSET, (String)this.charset.name()));
        ret = ret + new String("    " + XMLHandler.addTagValue((String)TAG_DEBUG_FILE, (String)this.debugFile));
        return ret;
    }

    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        super.loadXML(stepnode, databases, metaStore);
        try {
            this.dataFormat = Enum.valueOf(DataFormat.class, XMLHandler.getTagValue((Node)stepnode, (String)TAG_DATA_FORMAT));
            this.agentPort = Integer.parseInt(Const.NVL((String)XMLHandler.getTagValue((Node)stepnode, (String)TAG_AGENT_PORT), (String)Integer.toString(5555)));
            String charsetName = XMLHandler.getTagValue((Node)stepnode, (String)TAG_CHARSET);
            this.charset = charsetName == null ? InfobrightNamedPipeLoader.DEFAULT_CHARSET : Charset.forName(charsetName);
            this.debugFile = XMLHandler.getTagValue((Node)stepnode, (String)TAG_DEBUG_FILE);
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        super.readRep(rep, metaStore, id_step, databases);
        try {
            this.dataFormat = Enum.valueOf(DataFormat.class, rep.getStepAttributeString(id_step, TAG_DATA_FORMAT));
            String agentPortStr = rep.getStepAttributeString(id_step, TAG_AGENT_PORT);
            this.agentPort = agentPortStr == null ? 5555 : Integer.parseInt(agentPortStr);
            String charsetName = rep.getStepAttributeString(id_step, TAG_CHARSET);
            this.charset = charsetName == null ? InfobrightNamedPipeLoader.DEFAULT_CHARSET : Charset.forName(charsetName);
            this.debugFile = rep.getStepAttributeString(id_step, TAG_DEBUG_FILE);
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        super.saveRep(rep, metaStore, id_transformation, id_step);
        rep.saveStepAttribute(id_transformation, id_step, TAG_DATA_FORMAT, this.dataFormat.toString());
        rep.saveStepAttribute(id_transformation, id_step, TAG_AGENT_PORT, (long)this.agentPort);
        rep.saveStepAttribute(id_transformation, id_step, TAG_CHARSET, this.charset.name());
        rep.saveStepAttribute(id_transformation, id_step, TAG_DEBUG_FILE, this.debugFile);
    }

    public boolean isRejectErrors() {
        return this.rejectErrors;
    }

    public void setRejectErrors(boolean rejectErrors) {
        this.rejectErrors = rejectErrors;
    }

    public int getAgentPort() {
        return this.agentPort;
    }

    public Charset getCharset() {
        return this.charset;
    }
}

