/*
 * Decompiled with CFR 0.152.
 */
package com.totvscrm.pentaho.step.restoauth;

import com.totvscrm.pentaho.step.restoauth.RestOAuth;
import com.totvscrm.pentaho.step.restoauth.RestOAuthData;
import com.totvscrm.pentaho.step.restoauth.RestOAuthDialog;
import java.util.List;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaInteger;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

@Step(id="Rest OAuth 1.0", name="RestOAuth.Name", description="RestOAuth.TooltipDesc", image="Oauth_WS.png", categoryDescription="RestOAuth.Description", i18nPackageName="com.totvscrm.pentaho.step.restoauth", documentationUrl="https://wsintegracoes.webnode.com/restoauth1-0/", casesUrl="https://wsintegracoes.webnode.com/restoauth1-0/", forumUrl="https://wsintegracoes.webnode.com/restoauth1-0/")
public class RestOAuthMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static final Class<?> PKG = RestOAuthMeta.class;
    public static final String SIGNATURE_METHOD_HMAC_SHA1 = "HMAC-SHA1";
    public static final String SIGNATURE_METHOD_PLAINTEXT = "PLAINTEXT";
    public static final String[] SIGNATURE_METHODS = new String[]{"HMAC-SHA1", "PLAINTEXT"};
    public static final String HTTP_METHOD_GET = "GET";
    public static final String HTTP_METHOD_POST = "POST";
    public static final String HTTP_METHOD_PUT = "PUT";
    public static final String HTTP_METHOD_DELETE = "DELETE";
    public static final String HTTP_METHOD_HEAD = "HEAD";
    public static final String HTTP_METHOD_OPTIONS = "OPTIONS";
    public static final String HTTP_METHOD_PATCH = "PATCH";
    public static final String[] HTTP_METHODS = new String[]{"GET", "POST", "PUT", "DELETE"};
    private String url;
    private String method;
    private String body;
    private String consumerKey;
    private String consumerSecret;
    private String AccessToken;
    private String TokenSecret;
    private String signatureMethod;
    private String fieldName;
    private String resultCodeFieldName;
    private String[] headerName;
    private String[] headerField;

    public StepDialogInterface getDialog(Shell shell, StepMetaInterface meta, TransMeta transMeta, String name) {
        return new RestOAuthDialog(shell, meta, transMeta, name);
    }

    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans disp) {
        return new RestOAuth(stepMeta, stepDataInterface, cnr, transMeta, disp);
    }

    public StepDataInterface getStepData() {
        return new RestOAuthData();
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public String getConsumerKey() {
        return this.consumerKey;
    }

    public void setConsumerKey(String consumerKey) {
        this.consumerKey = consumerKey;
    }

    public String getConsumerSecret() {
        return this.consumerSecret;
    }

    public void setConsumerSecret(String consumerSecret) {
        this.consumerSecret = consumerSecret;
    }

    public String getAccessToken() {
        return this.AccessToken;
    }

    public void setAccessToken(String accessToken) {
        this.AccessToken = accessToken;
    }

    public String getTokenSecret() {
        return this.TokenSecret;
    }

    public void setTokenSecret(String tokenSecret) {
        this.TokenSecret = tokenSecret;
    }

    public String getSignatureMethod() {
        return this.signatureMethod;
    }

    public void setSignatureMethod(String signatureMethod) {
        this.signatureMethod = signatureMethod;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getResultCodeFieldName() {
        return this.resultCodeFieldName;
    }

    public void setResultCodeFieldName(String resultCodeFieldName) {
        this.resultCodeFieldName = resultCodeFieldName;
    }

    public String[] getHeaderName() {
        return this.headerName;
    }

    public void setHeaderName(String[] headerName) {
        this.headerName = headerName;
    }

    public String[] getHeaderField() {
        return this.headerField;
    }

    public void setHeaderField(String[] headerField) {
        this.headerField = headerField;
    }

    public void setDefault() {
        int nrheaders = 0;
        this.allocate(nrheaders);
        for (int i = 0; i < nrheaders; ++i) {
            this.headerField[i] = "header" + i;
            this.headerName[i] = "header";
        }
        this.setUrl(null);
        this.setMethod(HTTP_METHOD_GET);
        this.setBody(null);
        this.setConsumerKey(null);
        this.setConsumerSecret(null);
        this.setAccessToken(null);
        this.setTokenSecret(null);
        this.setSignatureMethod(SIGNATURE_METHOD_HMAC_SHA1);
    }

    public void allocate(int nrheaders) {
        this.headerField = new String[nrheaders];
        this.headerName = new String[nrheaders];
    }

    public Object clone() {
        RestOAuthMeta retval = (RestOAuthMeta)((Object)super.clone());
        int nrheaders = this.headerName.length;
        retval.allocate(nrheaders);
        System.arraycopy(this.headerField, 0, retval.headerField, 0, nrheaders);
        System.arraycopy(this.headerName, 0, retval.headerName, 0, nrheaders);
        return retval;
    }

    public String getXML() throws KettleValueException {
        int len;
        StringBuilder xml = new StringBuilder();
        xml.append("    ").append(XMLHandler.addTagValue((String)"url", (String)this.url));
        xml.append("    ").append(XMLHandler.addTagValue((String)"method", (String)this.method));
        xml.append("    ").append(XMLHandler.addTagValue((String)"body", (String)this.body));
        xml.append("    ").append(XMLHandler.addTagValue((String)"consumer_key", (String)this.consumerKey));
        xml.append("    ").append(XMLHandler.addTagValue((String)"consumer_secret", (String)this.consumerSecret));
        xml.append("    ").append(XMLHandler.addTagValue((String)"access_token", (String)this.AccessToken));
        xml.append("    ").append(XMLHandler.addTagValue((String)"token_secret", (String)this.TokenSecret));
        xml.append("    ").append(XMLHandler.addTagValue((String)"signature_method", (String)this.signatureMethod));
        xml.append("    <result>").append(Const.CR);
        xml.append("      ").append(XMLHandler.addTagValue((String)"name", (String)this.fieldName));
        xml.append("      ").append(XMLHandler.addTagValue((String)"code", (String)this.resultCodeFieldName));
        xml.append("    </result>").append(Const.CR);
        xml.append("    <headers>").append(Const.CR);
        int n = len = this.headerName != null ? this.headerName.length : 0;
        for (int i = 0; i < len; ++i) {
            xml.append("      <header>").append(Const.CR);
            xml.append("        ").append(XMLHandler.addTagValue((String)"field", (String)this.headerField[i]));
            xml.append("        ").append(XMLHandler.addTagValue((String)"name", (String)this.headerName[i]));
            xml.append("        </header>").append(Const.CR);
        }
        xml.append("      </headers>").append(Const.CR);
        return xml.toString();
    }

    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        try {
            this.setUrl(XMLHandler.getNodeValue((Node)XMLHandler.getSubNode((Node)stepnode, (String)"url")));
            this.setMethod(XMLHandler.getNodeValue((Node)XMLHandler.getSubNode((Node)stepnode, (String)"method")));
            this.setBody(XMLHandler.getNodeValue((Node)XMLHandler.getSubNode((Node)stepnode, (String)"body")));
            this.setConsumerKey(XMLHandler.getNodeValue((Node)XMLHandler.getSubNode((Node)stepnode, (String)"consumer_key")));
            this.setConsumerSecret(XMLHandler.getNodeValue((Node)XMLHandler.getSubNode((Node)stepnode, (String)"consumer_secret")));
            this.setAccessToken(XMLHandler.getNodeValue((Node)XMLHandler.getSubNode((Node)stepnode, (String)"access_token")));
            this.setTokenSecret(XMLHandler.getNodeValue((Node)XMLHandler.getSubNode((Node)stepnode, (String)"token_secret")));
            this.setSignatureMethod(XMLHandler.getNodeValue((Node)XMLHandler.getSubNode((Node)stepnode, (String)"signature_method")));
            this.setFieldName(XMLHandler.getTagValue((Node)stepnode, (String)"result", (String)"name"));
            this.setResultCodeFieldName(XMLHandler.getTagValue((Node)stepnode, (String)"result", (String)"code"));
            Node headernode = XMLHandler.getSubNode((Node)stepnode, (String)"headers");
            int nrheaders = XMLHandler.countNodes((Node)headernode, (String)"header");
            this.allocate(nrheaders);
            for (int i = 0; i < nrheaders; ++i) {
                Node anode = XMLHandler.getSubNodeByNr((Node)headernode, (String)"header", (int)i);
                this.headerField[i] = XMLHandler.getTagValue((Node)anode, (String)"field");
                this.headerName[i] = XMLHandler.getTagValue((Node)anode, (String)"name");
            }
        }
        catch (Exception e) {
            throw new KettleXMLException("Rest OAuth 1.0 plugin unable to read step info from XML node", (Throwable)e);
        }
    }

    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "url", this.getUrl());
            rep.saveStepAttribute(id_transformation, id_step, "method", this.getMethod());
            rep.saveStepAttribute(id_transformation, id_step, "body", this.getBody());
            rep.saveStepAttribute(id_transformation, id_step, "consumer_key", this.getConsumerKey());
            rep.saveStepAttribute(id_transformation, id_step, "consumer_secret", this.getConsumerSecret());
            rep.saveStepAttribute(id_transformation, id_step, "access_token", this.getAccessToken());
            rep.saveStepAttribute(id_transformation, id_step, "token_secret", this.getTokenSecret());
            rep.saveStepAttribute(id_transformation, id_step, "signature_method", this.getSignatureMethod());
            rep.saveStepAttribute(id_transformation, id_step, "result_name", this.getFieldName());
            rep.saveStepAttribute(id_transformation, id_step, "result_code", this.getResultCodeFieldName());
            for (int i = 0; i < this.headerName.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "header_field", this.headerField[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "header_name", this.headerName[i]);
            }
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step into repository: " + String.valueOf(id_step), (Throwable)e);
        }
    }

    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.setUrl(rep.getStepAttributeString(id_step, "url"));
            this.setMethod(rep.getStepAttributeString(id_step, "method"));
            this.setBody(rep.getStepAttributeString(id_step, "body"));
            this.setConsumerKey(rep.getStepAttributeString(id_step, "consumer_key"));
            this.setConsumerSecret(rep.getStepAttributeString(id_step, "consumer_secret"));
            this.setAccessToken(rep.getStepAttributeString(id_step, "access_token"));
            this.setTokenSecret(rep.getStepAttributeString(id_step, "token_secret"));
            this.setSignatureMethod(rep.getStepAttributeString(id_step, "signature_method"));
            this.setFieldName(rep.getStepAttributeString(id_step, "result_name"));
            this.setResultCodeFieldName(rep.getStepAttributeString(id_step, "result_code"));
            int nrheaders = rep.countNrStepAttributes(id_step, "header_field");
            this.allocate(nrheaders);
            for (int i = 0; i < nrheaders; ++i) {
                this.headerField[i] = rep.getStepAttributeString(id_step, i, "header_field");
                this.headerName[i] = rep.getStepAttributeString(id_step, i, "header_name");
            }
        }
        catch (Exception e) {
            throw new KettleException("Unable to load step from repository", (Throwable)e);
        }
    }

    public void getFields(RowMetaInterface inputRowMeta, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        ValueMetaString v;
        if (this.fieldName != null && this.fieldName.length() > 0) {
            v = new ValueMetaString(space.environmentSubstitute(this.fieldName));
            v.setOrigin(name);
            inputRowMeta.addValueMeta((ValueMetaInterface)v);
        }
        if (this.resultCodeFieldName != null && this.resultCodeFieldName.length() > 0) {
            v = new ValueMetaInteger(space.environmentSubstitute(this.resultCodeFieldName));
            v.setOrigin(name);
            inputRowMeta.addValueMeta((ValueMetaInterface)v);
        }
    }

    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr = input.length > 0 ? new CheckResult(1, BaseMessages.getString(PKG, (String)"RestMeta.CheckResult.ReceivingInfoFromOtherSteps", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(4, BaseMessages.getString(PKG, (String)"RestMeta.CheckResult.NoInpuReceived", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
        remarks.add((CheckResultInterface)cr);
        cr = this.url == null || this.url.length() < 0 ? new CheckResult(4, BaseMessages.getString(PKG, (String)"RestMeta.CheckResult.UrlMissing", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"RestMeta.CheckResult.UrlOk", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
        remarks.add((CheckResultInterface)cr);
        cr = this.method == null || this.method.length() < 0 ? new CheckResult(4, BaseMessages.getString(PKG, (String)"RestMeta.CheckResult.MethodMissing", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"RestMeta.CheckResult.MethodOk", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
        remarks.add((CheckResultInterface)cr);
    }

    public boolean supportsErrorHandling() {
        return true;
    }

    public static boolean isActiveBody(String method) {
        if (method == null || method.length() == 0) {
            return false;
        }
        return method.equals(HTTP_METHOD_POST) || method.equals(HTTP_METHOD_PUT) || method.equals(HTTP_METHOD_PATCH);
    }
}

