/*
 * Decompiled with CFR 0.152.
 */
package com.totvscrm.pentaho.step.restoauth;

import com.intuit.ipp.exception.FMSException;
import com.totvscrm.pentaho.step.restoauth.RestOAuthData;
import com.totvscrm.pentaho.step.restoauth.RestOAuthMeta;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Arrays;
import oauth.signpost.commonshttp.CommonsHttpOAuthConsumer;
import oauth.signpost.exception.OAuthCommunicationException;
import oauth.signpost.exception.OAuthExpectationFailedException;
import oauth.signpost.exception.OAuthMessageSignerException;
import oauth.signpost.signature.AuthorizationHeaderSigningStrategy;
import oauth.signpost.signature.HmacSha1MessageSigner;
import oauth.signpost.signature.OAuthMessageSigner;
import oauth.signpost.signature.PlainTextMessageSigner;
import oauth.signpost.signature.SigningStrategy;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;

public class RestOAuth
extends BaseStep
implements StepInterface {
    private static final Class<?> PKG = RestOAuthMeta.class;
    private RestOAuthMeta meta;
    private RestOAuthData data;

    public RestOAuth(StepMeta s, StepDataInterface stepDataInterface, int c, TransMeta t, Trans dis) {
        super(s, stepDataInterface, c, t, dis);
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (RestOAuthMeta)smi;
        this.data = (RestOAuthData)sdi;
        if (!super.init((StepMetaInterface)this.meta, (StepDataInterface)this.data)) {
            this.data.resultFieldName = this.environmentSubstitute(this.meta.getFieldName());
            this.data.resultCodeFieldName = this.environmentSubstitute(this.meta.getResultCodeFieldName());
            return false;
        }
        return true;
    }

    private Object[] callRest(Object[] rowData) throws KettleException {
        String realUrl = null;
        String body = null;
        String consumerKey = null;
        String consumerSecret = null;
        String accessToken = null;
        String tokenSecret = null;
        realUrl = this.data.indexOfUrlField < 0 ? this.environmentSubstitute(this.meta.getUrl()) : this.data.inputRowMeta.getString(rowData, this.data.indexOfUrlField);
        if (realUrl == null || realUrl.length() == 0) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"RestOAuth.Exception.ErrorFindingField", (String[])new String[]{"URL"}));
        }
        if (this.data.useBody && ((body = this.environmentSubstitute(this.data.inputRowMeta.getString(rowData, this.data.indexOfBodyField))) == null || body.length() == 0)) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"RestOAuth.Exception.ErrorFindingField", (String[])new String[]{"Body"}));
        }
        consumerKey = this.data.indexOfConsumerKeyField < 0 ? this.environmentSubstitute(this.meta.getConsumerKey()) : this.data.inputRowMeta.getString(rowData, this.data.indexOfConsumerKeyField);
        consumerSecret = this.data.indexOfConsumerSecretField < 0 ? this.environmentSubstitute(this.meta.getConsumerSecret()) : this.data.inputRowMeta.getString(rowData, this.data.indexOfConsumerSecretField);
        accessToken = this.data.indexOfAccessTokenField < 0 ? this.environmentSubstitute(this.meta.getAccessToken()) : this.data.inputRowMeta.getString(rowData, this.data.indexOfAccessTokenField);
        tokenSecret = this.data.indexOfTokenSecretField < 0 ? this.environmentSubstitute(this.meta.getTokenSecret()) : this.data.inputRowMeta.getString(rowData, this.data.indexOfTokenSecretField);
        Object[] newRow = null;
        if (rowData != null) {
            newRow = (Object[])rowData.clone();
        }
        try {
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"RestOAuth.Log.ConnectingToURL", (String[])new String[]{realUrl}));
            }
            long startTime = System.currentTimeMillis();
            this.setupContext(consumerKey, consumerSecret, accessToken, tokenSecret);
            CloseableHttpClient httpClient = HttpClientBuilder.create().build();
            URI uri = null;
            try {
                uri = new URI(realUrl);
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
            HttpRequestBase httpRequestBase = null;
            try {
                httpRequestBase = this.createApacheRequest(uri, body);
            }
            catch (Exception e) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"RestOAuth.Error.FailCreatingHttpBase", (String[])new String[0]));
            }
            if (this.data.useHeaders) {
                for (int i = 0; i < this.data.nrheader; ++i) {
                    String value = null;
                    value = this.data.indexOfHeaderFields[i] < 0 ? this.meta.getHeaderField()[i] : this.data.inputRowMeta.getString(rowData, this.data.indexOfHeaderFields[i]);
                    httpRequestBase.addHeader(this.data.headerNames[i], value);
                    if (!this.isDebug()) continue;
                    this.logDebug(BaseMessages.getString(PKG, (String)"RestOAuth.Log.HeaderValue", (String[])new String[]{this.data.headerNames[i], value}));
                }
            }
            try {
                this.authorize(httpRequestBase);
            }
            catch (FMSException e) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"RestOAuth.Error.CannotAuthorizeRequest", (String[])new String[0]), (Throwable)e);
            }
            HttpResponse httpResponse = null;
            String output = null;
            try {
                httpResponse = httpClient.execute((HttpUriRequest)httpRequestBase);
                Charset charset = ContentType.getOrDefault((HttpEntity)httpResponse.getEntity()).getCharset();
                String encoding = charset.name() == null ? "UTF-8" : charset.name();
                output = IOUtils.toString((InputStream)httpResponse.getEntity().getContent(), (String)encoding);
            }
            catch (Exception e) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"RestOAuth.Error.RunningHttpRequest", (String[])new String[0]), (Throwable)e);
            }
            long responseTime = System.currentTimeMillis() - startTime;
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"RestOAuth.Log.ResponseTime", (String[])new String[]{String.valueOf(responseTime), realUrl}));
            }
            int status = httpResponse.getStatusLine().getStatusCode();
            if (this.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"RestOAuth.Log.ResponseCode", (String[])new String[]{"" + status}));
            }
            int returnFieldsOffset = this.data.inputRowMeta.size();
            if (this.data.resultFieldName == null || this.data.resultFieldName.length() == 0) {
                newRow = RowDataUtil.addValueData((Object[])newRow, (int)returnFieldsOffset, (Object)output);
                ++returnFieldsOffset;
            }
            if (this.data.resultCodeFieldName == null || this.data.resultCodeFieldName.length() == 0) {
                newRow = RowDataUtil.addValueData((Object[])newRow, (int)returnFieldsOffset, (Object)new Long(status));
                ++returnFieldsOffset;
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"RestOAuth.Error.CanNotReadURL", (String[])new String[]{realUrl}), (Throwable)e);
        }
        return newRow;
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        block19: {
            this.meta = (RestOAuthMeta)smi;
            this.data = (RestOAuthData)sdi;
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                String field;
                int nrargs;
                this.first = false;
                this.data.inputRowMeta = this.getInputRowMeta();
                this.data.outputRowMeta = this.data.inputRowMeta.clone();
                this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, (VariableSpace)this, this.repository, this.metaStore);
                this.data.method = this.environmentSubstitute(this.meta.getMethod());
                if (!Arrays.asList(RestOAuthMeta.HTTP_METHODS).contains(this.data.method)) {
                    this.logError(BaseMessages.getString(PKG, (String)"RestOAuth.Exception.MethodFieldMissing", (String[])new String[0]));
                    return false;
                }
                this.data.signatureMethod = this.environmentSubstitute(this.meta.getSignatureMethod());
                if (!Arrays.asList(RestOAuthMeta.SIGNATURE_METHODS).contains(this.data.signatureMethod)) {
                    this.logError(BaseMessages.getString(PKG, (String)"RestOAuth.Exception.SignatureMethodFieldMissing", (String[])new String[0]));
                    return false;
                }
                if (this.meta.getUrl() == null || this.meta.getUrl().length() == 0) {
                    this.logError(BaseMessages.getString(PKG, (String)"RestOAuth.Log.NoField", (String[])new String[0]));
                    throw new KettleException(BaseMessages.getString(PKG, (String)"RestOAuth.Log.NoField", (String[])new String[0]));
                }
                if (this.data.indexOfUrlField < 0) {
                    String realUrlfieldName = this.environmentSubstitute(this.meta.getUrl());
                    this.data.indexOfUrlField = this.data.inputRowMeta.indexOfValue(realUrlfieldName);
                }
                if (this.data.indexOfConsumerKeyField < 0) {
                    this.data.indexOfConsumerKeyField = this.data.inputRowMeta.indexOfValue(this.environmentSubstitute(this.meta.getConsumerKey()));
                }
                if (this.data.indexOfConsumerSecretField < 0) {
                    this.data.indexOfConsumerSecretField = this.data.inputRowMeta.indexOfValue(this.environmentSubstitute(this.meta.getConsumerSecret()));
                }
                if (this.data.indexOfAccessTokenField < 0) {
                    this.data.indexOfAccessTokenField = this.data.inputRowMeta.indexOfValue(this.environmentSubstitute(this.meta.getAccessToken()));
                }
                if (this.data.indexOfTokenSecretField < 0) {
                    this.data.indexOfTokenSecretField = this.data.inputRowMeta.indexOfValue(this.environmentSubstitute(this.meta.getTokenSecret()));
                }
                int n = nrargs = this.meta.getHeaderName() == null ? 0 : this.meta.getHeaderName().length;
                if (nrargs > 0) {
                    this.data.nrheader = nrargs;
                    this.data.indexOfHeaderFields = new int[nrargs];
                    this.data.headerNames = new String[nrargs];
                    for (int i = 0; i < nrargs; ++i) {
                        this.data.headerNames[i] = this.environmentSubstitute(this.meta.getHeaderName()[i]);
                        String field2 = this.environmentSubstitute(this.meta.getHeaderField()[i]);
                        if (field2 == null || field2.length() == 0) {
                            throw new KettleException(BaseMessages.getString(PKG, (String)"RestOAuth.Exception.HeaderFieldEmpty", (String[])new String[0]));
                        }
                        this.data.indexOfHeaderFields[i] = this.data.inputRowMeta.indexOfValue(field2);
                    }
                    this.data.useHeaders = true;
                }
                if (RestOAuthMeta.isActiveBody(this.meta.getMethod()) && (field = this.environmentSubstitute(this.meta.getBody())) != null && field.length() > 0) {
                    this.data.indexOfBodyField = this.data.inputRowMeta.indexOfValue(field);
                    if (this.data.indexOfBodyField < 0) {
                        throw new KettleException(BaseMessages.getString(PKG, (String)"RestOAuth.Exception.ErrorFindingField", (String[])new String[]{field}));
                    }
                    this.data.useBody = true;
                }
            }
            try {
                Object[] outputRowData = this.callRest(r);
                this.putRow(this.data.outputRowMeta, outputRowData);
                if (this.checkFeedback(this.getLinesRead()) && this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"RestOAuth.LineNumber", (String[])new String[0]) + this.getLinesRead());
                }
            }
            catch (KettleException e) {
                boolean sendToErrorRow = false;
                String errorMessage = null;
                if (!this.getStepMeta().isDoingErrorHandling()) {
                    this.logError(BaseMessages.getString(PKG, (String)"RestOAuth.ErrorInStepRunning", (String[])new String[0]) + e.getMessage());
                    this.setErrors(1L);
                    this.logError(Const.getStackTracker((Throwable)e));
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block19;
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, null, "Rest001");
            }
        }
        return true;
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (RestOAuthMeta)smi;
        this.data = (RestOAuthData)sdi;
        this.data.headerNames = null;
        this.data.indexOfHeaderFields = null;
        this.data.oAuthConsumer = null;
        this.data.useBody = false;
        this.data.indexOfBodyField = -1;
        this.data.indexOfUrlField = -1;
        this.data.indexOfConsumerKeyField = -1;
        this.data.indexOfConsumerSecretField = -1;
        this.data.indexOfAccessTokenField = -1;
        this.data.indexOfTokenSecretField = -1;
        super.dispose((StepMetaInterface)this.meta, (StepDataInterface)this.data);
    }

    public void setupContext(String consumerKey, String consumerSecret, String accessToken, String accessTokenSecret) {
        this.data.oAuthConsumer = new CommonsHttpOAuthConsumer(consumerKey, consumerSecret);
        this.data.oAuthConsumer.setTokenWithSecret(accessToken, accessTokenSecret);
        this.data.oAuthConsumer.setSigningStrategy((SigningStrategy)new AuthorizationHeaderSigningStrategy());
        HmacSha1MessageSigner messageSigner = null;
        switch (this.data.signatureMethod) {
            case "HMAC-SHA1": {
                messageSigner = new HmacSha1MessageSigner();
                break;
            }
            case "PLAINTEXT": {
                messageSigner = new PlainTextMessageSigner();
            }
        }
        messageSigner.setConsumerSecret(consumerSecret);
        messageSigner.setTokenSecret(accessTokenSecret);
        this.data.oAuthConsumer.setMessageSigner((OAuthMessageSigner)messageSigner);
    }

    public void authorize(HttpRequestBase httpRequest) throws FMSException {
        try {
            this.data.oAuthConsumer.sign((Object)httpRequest);
        }
        catch (OAuthMessageSignerException e) {
            throw new FMSException((Throwable)e);
        }
        catch (OAuthExpectationFailedException e) {
            throw new FMSException((Throwable)e);
        }
        catch (OAuthCommunicationException e) {
            throw new FMSException((Throwable)e);
        }
    }

    private HttpRequestBase createApacheRequest(URI uri, String body) throws KettleException, ParseException, IOException {
        StringEntity stringEntity = null;
        switch (this.data.method) {
            case "GET": {
                return new HttpGet(uri);
            }
            case "POST": {
                HttpPost httpPost = new HttpPost(uri);
                stringEntity = new StringEntity(body, "utf-8");
                stringEntity.setContentEncoding("UTF-8");
                stringEntity.setContentType("application/json");
                httpPost.setEntity((HttpEntity)stringEntity);
                if (this.isDetailed()) {
                    this.logDetailed(EntityUtils.toString((HttpEntity)httpPost.getEntity()));
                }
                return httpPost;
            }
            case "PUT": {
                HttpPut httpPut = new HttpPut(uri);
                stringEntity = new StringEntity(body, "utf-8");
                stringEntity.setContentEncoding("UTF-8");
                stringEntity.setContentType("application/json");
                httpPut.setEntity((HttpEntity)stringEntity);
                if (this.isDetailed()) {
                    this.logDetailed(EntityUtils.toString((HttpEntity)httpPut.getEntity()));
                }
                return httpPut;
            }
            case "DELETE": {
                return new HttpDelete(uri);
            }
        }
        throw new KettleException("Unknown HTTP method name: " + this.data.method);
    }
}

