/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v24.group.RDS_O13_ENCODING;
import ca.uhn.hl7v2.model.v24.group.RDS_O13_OBSERVATION;
import ca.uhn.hl7v2.model.v24.group.RDS_O13_ORDER_DETAIL;
import ca.uhn.hl7v2.model.v24.segment.FT1;
import ca.uhn.hl7v2.model.v24.segment.ORC;
import ca.uhn.hl7v2.model.v24.segment.RXC;
import ca.uhn.hl7v2.model.v24.segment.RXD;
import ca.uhn.hl7v2.model.v24.segment.RXR;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class RDS_O13_ORDER
extends AbstractGroup {
    public RDS_O13_ORDER(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ORC.class, true, false);
            this.add(RDS_O13_ORDER_DETAIL.class, false, false);
            this.add(RDS_O13_ENCODING.class, false, false);
            this.add(RXD.class, true, false);
            this.add(RXR.class, true, true);
            this.add(RXC.class, false, true);
            this.add(RDS_O13_OBSERVATION.class, false, true);
            this.add(FT1.class, false, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error creating RDS_O13_ORDER - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.4";
    }

    public ORC getORC() {
        ORC ret = null;
        try {
            ret = (ORC)this.get("ORC");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RDS_O13_ORDER_DETAIL getORDER_DETAIL() {
        RDS_O13_ORDER_DETAIL ret = null;
        try {
            ret = (RDS_O13_ORDER_DETAIL)this.get("ORDER_DETAIL");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RDS_O13_ENCODING getENCODING() {
        RDS_O13_ENCODING ret = null;
        try {
            ret = (RDS_O13_ENCODING)this.get("ENCODING");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RXD getRXD() {
        RXD ret = null;
        try {
            ret = (RXD)this.get("RXD");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RXR getRXR() {
        RXR ret = null;
        try {
            ret = (RXR)this.get("RXR");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RXR getRXR(int rep) {
        RXR ret = null;
        try {
            ret = (RXR)this.get("RXR", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getRXRReps() {
        int reps = -1;
        try {
            reps = this.getAll("RXR").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertRXR(RXR structure, int rep) throws HL7Exception {
        super.insertRepetition("RXR", (Structure)structure, rep);
    }

    public RXR insertRXR(int rep) throws HL7Exception {
        return (RXR)super.insertRepetition("RXR", rep);
    }

    public RXR removeRXR(int rep) throws HL7Exception {
        return (RXR)super.removeRepetition("RXR", rep);
    }

    public RXC getRXC() {
        RXC ret = null;
        try {
            ret = (RXC)this.get("RXC");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RXC getRXC(int rep) {
        RXC ret = null;
        try {
            ret = (RXC)this.get("RXC", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getRXCReps() {
        int reps = -1;
        try {
            reps = this.getAll("RXC").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertRXC(RXC structure, int rep) throws HL7Exception {
        super.insertRepetition("RXC", (Structure)structure, rep);
    }

    public RXC insertRXC(int rep) throws HL7Exception {
        return (RXC)super.insertRepetition("RXC", rep);
    }

    public RXC removeRXC(int rep) throws HL7Exception {
        return (RXC)super.removeRepetition("RXC", rep);
    }

    public RDS_O13_OBSERVATION getOBSERVATION() {
        RDS_O13_OBSERVATION ret = null;
        try {
            ret = (RDS_O13_OBSERVATION)this.get("OBSERVATION");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RDS_O13_OBSERVATION getOBSERVATION(int rep) {
        RDS_O13_OBSERVATION ret = null;
        try {
            ret = (RDS_O13_OBSERVATION)this.get("OBSERVATION", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getOBSERVATIONReps() {
        int reps = -1;
        try {
            reps = this.getAll("OBSERVATION").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertOBSERVATION(RDS_O13_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("OBSERVATION", (Structure)structure, rep);
    }

    public RDS_O13_OBSERVATION insertOBSERVATION(int rep) throws HL7Exception {
        return (RDS_O13_OBSERVATION)super.insertRepetition("OBSERVATION", rep);
    }

    public RDS_O13_OBSERVATION removeOBSERVATION(int rep) throws HL7Exception {
        return (RDS_O13_OBSERVATION)super.removeRepetition("OBSERVATION", rep);
    }

    public FT1 getFT1() {
        FT1 ret = null;
        try {
            ret = (FT1)this.get("FT1");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public FT1 getFT1(int rep) {
        FT1 ret = null;
        try {
            ret = (FT1)this.get("FT1", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getFT1Reps() {
        int reps = -1;
        try {
            reps = this.getAll("FT1").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertFT1(FT1 structure, int rep) throws HL7Exception {
        super.insertRepetition("FT1", (Structure)structure, rep);
    }

    public FT1 insertFT1(int rep) throws HL7Exception {
        return (FT1)super.insertRepetition("FT1", rep);
    }

    public FT1 removeFT1(int rep) throws HL7Exception {
        return (FT1)super.removeRepetition("FT1", rep);
    }
}

