/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v24.group.ORS_O06_ORDER;
import ca.uhn.hl7v2.model.v24.group.ORS_O06_PATIENT;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class ORS_O06_RSPONSE
extends AbstractGroup {
    public ORS_O06_RSPONSE(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ORS_O06_PATIENT.class, false, false);
            this.add(ORS_O06_ORDER.class, true, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error creating ORS_O06_RSPONSE - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.4";
    }

    public ORS_O06_PATIENT getPATIENT() {
        ORS_O06_PATIENT ret = null;
        try {
            ret = (ORS_O06_PATIENT)this.get("PATIENT");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ORS_O06_ORDER getORDER() {
        ORS_O06_ORDER ret = null;
        try {
            ret = (ORS_O06_ORDER)this.get("ORDER");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ORS_O06_ORDER getORDER(int rep) {
        ORS_O06_ORDER ret = null;
        try {
            ret = (ORS_O06_ORDER)this.get("ORDER", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getORDERReps() {
        int reps = -1;
        try {
            reps = this.getAll("ORDER").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertORDER(ORS_O06_ORDER structure, int rep) throws HL7Exception {
        super.insertRepetition("ORDER", (Structure)structure, rep);
    }

    public ORS_O06_ORDER insertORDER(int rep) throws HL7Exception {
        return (ORS_O06_ORDER)super.insertRepetition("ORDER", rep);
    }

    public ORS_O06_ORDER removeORDER(int rep) throws HL7Exception {
        return (ORS_O06_ORDER)super.removeRepetition("ORDER", rep);
    }
}

