/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.docbundle.metadata.writer;

import java.io.IOException;
import java.io.OutputStream;
import org.pentaho.reporting.libraries.docbundle.DocumentMetaData;
import org.pentaho.reporting.libraries.docbundle.metadata.BundleManifest;
import org.pentaho.reporting.libraries.docbundle.metadata.BundleMetaData;
import org.pentaho.reporting.libraries.docbundle.metadata.writer.BundleManifestXmlWriter;
import org.pentaho.reporting.libraries.docbundle.metadata.writer.BundleMetaDataXmlWriter;

public class DocumentMetaDataWriter {
    private BundleManifestWrapper manifestWrapper;
    private BundleMetaDataWrapper metaDataWrapper;

    public DocumentMetaDataWriter(DocumentMetaData documentMetaData) {
        if (documentMetaData == null) {
            throw new NullPointerException();
        }
        this.manifestWrapper = new BundleManifestWrapper(documentMetaData);
        this.metaDataWrapper = new BundleMetaDataWrapper(documentMetaData);
    }

    public void writeManifest(OutputStream out) throws IOException {
        BundleManifestXmlWriter xmlWriter = new BundleManifestXmlWriter(this.manifestWrapper);
        xmlWriter.write(out);
    }

    public void writeMetaData(OutputStream out) throws IOException {
        BundleMetaDataXmlWriter xmlWriter = new BundleMetaDataXmlWriter(this.metaDataWrapper);
        xmlWriter.write(out);
    }

    private static class BundleMetaDataWrapper
    implements BundleMetaData {
        private DocumentMetaData documentMetaData;

        private BundleMetaDataWrapper(DocumentMetaData documentMetaData) {
            if (documentMetaData == null) {
                throw new NullPointerException();
            }
            this.documentMetaData = documentMetaData;
        }

        @Override
        public Object getBundleAttribute(String namespace, String attributeName) {
            if (namespace == null) {
                throw new NullPointerException();
            }
            if (attributeName == null) {
                throw new NullPointerException();
            }
            return this.documentMetaData.getBundleAttribute(namespace, attributeName);
        }

        @Override
        public String[] getNamespaces() {
            return this.documentMetaData.getMetaDataNamespaces();
        }

        @Override
        public String[] getNames(String namespace) {
            if (namespace == null) {
                throw new NullPointerException();
            }
            return this.documentMetaData.getMetaDataNames(namespace);
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            throw new UnsupportedOperationException();
        }
    }

    private static class BundleManifestWrapper
    implements BundleManifest {
        private DocumentMetaData documentMetaData;

        private BundleManifestWrapper(DocumentMetaData documentMetaData) {
            if (documentMetaData == null) {
                throw new NullPointerException();
            }
            this.documentMetaData = documentMetaData;
        }

        @Override
        public String getMimeType(String entry) {
            if (entry == null) {
                throw new NullPointerException();
            }
            return this.documentMetaData.getEntryMimeType(entry);
        }

        @Override
        public String[] getEntries() {
            return this.documentMetaData.getManifestEntryNames();
        }

        @Override
        public String getAttribute(String entryName, String attributeName) {
            return this.documentMetaData.getEntryAttribute(entryName, attributeName);
        }

        @Override
        public String[] getAttributeNames(String entryName) {
            return this.documentMetaData.getEntryAttributeNames(entryName);
        }
    }
}

