/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.docbundle.metadata.writer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.pentaho.reporting.libraries.docbundle.LibDocBundleBoot;
import org.pentaho.reporting.libraries.docbundle.metadata.BundleMetaData;
import org.pentaho.reporting.libraries.docbundle.metadata.writer.BundleMetaDataEntryWriteHandler;
import org.pentaho.reporting.libraries.docbundle.metadata.writer.BundleMetaDataWriteHandlerFactory;
import org.pentaho.reporting.libraries.xmlns.common.AttributeList;
import org.pentaho.reporting.libraries.xmlns.writer.DefaultTagDescription;
import org.pentaho.reporting.libraries.xmlns.writer.NamespaceCollection;
import org.pentaho.reporting.libraries.xmlns.writer.TagDescription;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;

public class BundleMetaDataXmlWriter {
    private static final String OFFICE_NAMESPACE = "urn:oasis:names:tc:opendocument:xmlns:office:1.0";
    private static final String TAGDEF_CONFIG_PREFIX = "org.pentaho.reporting.libraries.docbundle.metadata.writer.metadata-tagdefinition.";
    private static final String HANDLER_CONFIG_PREFIX = "org.pentaho.reporting.libraries.docbundle.metadata.writer.metadata-writehandler.";
    private NamespaceCollection namespaceCollection;
    private BundleMetaData bundleMetaData;
    private BundleMetaDataWriteHandlerFactory writeHandlerFactory;

    public BundleMetaDataXmlWriter(BundleMetaData bundleMetaData) {
        if (bundleMetaData == null) {
            throw new NullPointerException();
        }
        this.bundleMetaData = bundleMetaData;
        this.writeHandlerFactory = new BundleMetaDataWriteHandlerFactory();
        this.writeHandlerFactory.configure(LibDocBundleBoot.getInstance().getGlobalConfig(), HANDLER_CONFIG_PREFIX);
    }

    public String getDefaultPrefix(String uri) {
        if (uri == null) {
            throw new NullPointerException();
        }
        if (this.namespaceCollection == null) {
            this.namespaceCollection = new NamespaceCollection();
            this.namespaceCollection.configure(LibDocBundleBoot.getInstance().getGlobalConfig(), "org.pentaho.reporting.libraries.docbundle.namespaces.");
        }
        return this.namespaceCollection.getPrefix(uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(OutputStream out) throws IOException {
        if (out == null) {
            throw new NullPointerException();
        }
        DefaultTagDescription tagDescription = new DefaultTagDescription();
        tagDescription.configure(LibDocBundleBoot.getInstance().getGlobalConfig(), TAGDEF_CONFIG_PREFIX);
        XmlWriter writer = new XmlWriter((Writer)new OutputStreamWriter(out, "UTF-8"), (TagDescription)tagDescription, "  ", "\n");
        writer.setAlwaysAddNamespace(true);
        writer.setWriteFinalLinebreak(true);
        try {
            writer.writeXmlDeclaration("UTF-8");
            AttributeList rootAttributes = new AttributeList();
            rootAttributes.addNamespaceDeclaration("office", OFFICE_NAMESPACE);
            rootAttributes.addNamespaceDeclaration("meta", "urn:oasis:names:tc:opendocument:xmlns:meta:1.0");
            rootAttributes.addNamespaceDeclaration("dc", "http://purl.org/dc/elements/1.1/");
            writer.writeTag(OFFICE_NAMESPACE, "document-meta", rootAttributes, false);
            writer.writeTag(OFFICE_NAMESPACE, "meta", false);
            for (String namespace : this.bundleMetaData.getNamespaces()) {
                for (String name : this.bundleMetaData.getNames(namespace)) {
                    BundleMetaDataEntryWriteHandler writeHandler;
                    Object value = this.bundleMetaData.getBundleAttribute(namespace, name);
                    if (value == null || (writeHandler = this.writeHandlerFactory.getHandler(namespace, name)) == null) continue;
                    writeHandler.write(this, writer, namespace, name, value);
                }
            }
            writer.writeCloseTag();
            writer.writeCloseTag();
        }
        finally {
            writer.flush();
        }
    }
}

