/*
 * Decompiled with CFR 0.152.
 */
package mondrian.server;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Util;
import mondrian.rolap.RolapUtil;
import mondrian.server.monitor.CellCacheSegmentCreateEvent;
import mondrian.server.monitor.CellCacheSegmentDeleteEvent;
import mondrian.server.monitor.ConnectionEndEvent;
import mondrian.server.monitor.ConnectionInfo;
import mondrian.server.monitor.ConnectionStartEvent;
import mondrian.server.monitor.Event;
import mondrian.server.monitor.ExecutionEndEvent;
import mondrian.server.monitor.ExecutionInfo;
import mondrian.server.monitor.ExecutionPhaseEvent;
import mondrian.server.monitor.ExecutionStartEvent;
import mondrian.server.monitor.Message;
import mondrian.server.monitor.Monitor;
import mondrian.server.monitor.MonitorMXBean;
import mondrian.server.monitor.ServerInfo;
import mondrian.server.monitor.SqlStatementEndEvent;
import mondrian.server.monitor.SqlStatementExecuteEvent;
import mondrian.server.monitor.SqlStatementInfo;
import mondrian.server.monitor.SqlStatementStartEvent;
import mondrian.server.monitor.StatementEndEvent;
import mondrian.server.monitor.StatementInfo;
import mondrian.server.monitor.StatementStartEvent;
import mondrian.server.monitor.Visitor;
import mondrian.util.BlockingHashMap;
import mondrian.util.MDCUtil;
import mondrian.util.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class MonitorImpl
implements Monitor,
MonitorMXBean {
    private static final Logger LOGGER = LogManager.getLogger(MonitorImpl.class);
    private final Handler handler = new Handler();
    protected static final Util.MemoryInfo MEMORY_INFO = Util.getMemoryInfo();
    private static final Actor ACTOR = new Actor();

    public void shutdown() {
    }

    @Override
    public void sendEvent(Event event) {
        try {
            if (Thread.interrupted()) {
                throw new AssertionError();
            }
            ACTOR.eventQueue.put(Pair.of(this.handler, event));
        }
        catch (InterruptedException e) {
            throw Util.newError(e, "Exception while sending event " + event);
        }
    }

    @Override
    public ServerInfo getServer() {
        return (ServerInfo)this.execute(new ServerCommand());
    }

    @Override
    public List<ConnectionInfo> getConnections() {
        return (List)this.execute(new ConnectionsCommand());
    }

    @Override
    public List<StatementInfo> getStatements() {
        return (List)this.execute(new StatementsCommand());
    }

    @Override
    public List<SqlStatementInfo> getSqlStatements() {
        return (List)this.execute(new SqlStatementsCommand());
    }

    private Object execute(Command command) {
        return ACTOR.execute(this.handler, command);
    }

    static {
        Thread thread = new Thread((Runnable)ACTOR, "Mondrian Monitor");
        thread.setDaemon(true);
        thread.start();
    }

    private static class Actor
    implements Runnable {
        private boolean running = true;
        private final BlockingQueue<Pair<Handler, Message>> eventQueue = new ArrayBlockingQueue<Pair<Handler, Message>>(1000);
        private final BlockingHashMap<Command, Object> responseMap = new BlockingHashMap(1000);

        private Actor() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            while (true) {
                try {
                    Message message;
                    do {
                        Pair<Handler, Message> entry = this.eventQueue.take();
                        Handler handler = (Handler)entry.left;
                        message = (Message)entry.right;
                        message.setContextMap();
                        Object result = message.accept(handler);
                        if (message instanceof Command) {
                            this.responseMap.put((Command)message, result);
                            continue;
                        }
                        RolapUtil.MONITOR_LOGGER.debug((Object)message);
                    } while (!(message instanceof ShutdownCommand));
                    LOGGER.debug("ShutdownCommand received. Monitor thread is shutting down.");
                    this.running = false;
                    return;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    LOGGER.warn("Monitor thread interrupted.", (Throwable)e);
                    this.running = false;
                    return;
                }
                catch (Throwable t) {
                    try {
                        LOGGER.error("Runtime error on the monitor thread.", t);
                        continue;
                    }
                    catch (Throwable throwable) {
                        this.running = false;
                        throw throwable;
                    }
                }
                break;
            }
        }

        public void shutdown() {
            if (this.running) {
                this.execute(null, new ShutdownCommand());
            }
        }

        Object execute(Handler handler, Command command) {
            try {
                this.eventQueue.put(Pair.of(handler, command));
            }
            catch (InterruptedException e) {
                throw Util.newError(e, "Interrupted while sending " + command);
            }
            try {
                return this.responseMap.get(command);
            }
            catch (InterruptedException e) {
                throw Util.newError(e, "Interrupted while awaiting " + command);
            }
        }
    }

    private static class Handler
    implements CommandVisitor<Object> {
        private final MutableServerInfo server = new MutableServerInfo(null);
        private final Map<Integer, MutableConnectionInfo> connectionMap;
        private final Map<Long, MutableSqlStatementInfo> sqlStatementMap;
        private final Map<Long, MutableStatementInfo> statementMap;
        private final Map<Long, MutableExecutionInfo> executionMap;
        private final Map<Long, MutableExecutionInfo> retiredExecutionMap;

        private Handler() {
            this.connectionMap = new LinkedHashMap<Integer, MutableConnectionInfo>(MondrianProperties.instance().ExecutionHistorySize.get(), 0.8f, false){
                private final int maxSize;
                private static final long serialVersionUID = 1L;
                {
                    super(arg0, arg1, arg2);
                    this.maxSize = MondrianProperties.instance().ExecutionHistorySize.get();
                }

                @Override
                protected boolean removeEldestEntry(Map.Entry<Integer, MutableConnectionInfo> e) {
                    if (this.size() > this.maxSize) {
                        if (RolapUtil.MONITOR_LOGGER.isTraceEnabled()) {
                            RolapUtil.MONITOR_LOGGER.trace("ConnectionInfo(" + e.getKey() + ") evicted. Stack is:" + Util.nl + e.getValue().stack);
                        }
                        return true;
                    }
                    return false;
                }
            };
            this.sqlStatementMap = new LinkedHashMap<Long, MutableSqlStatementInfo>(MondrianProperties.instance().ExecutionHistorySize.get(), 0.8f, false){
                private final int maxSize;
                private static final long serialVersionUID = 1L;
                {
                    super(arg0, arg1, arg2);
                    this.maxSize = MondrianProperties.instance().ExecutionHistorySize.get();
                }

                @Override
                protected boolean removeEldestEntry(Map.Entry<Long, MutableSqlStatementInfo> e) {
                    if (this.size() > this.maxSize) {
                        if (RolapUtil.MONITOR_LOGGER.isTraceEnabled()) {
                            RolapUtil.MONITOR_LOGGER.trace("StatementInfo(" + e.getKey() + ") evicted. Stack is:" + Util.nl + e.getValue().stack);
                        }
                        return true;
                    }
                    return false;
                }
            };
            this.statementMap = new LinkedHashMap<Long, MutableStatementInfo>(MondrianProperties.instance().ExecutionHistorySize.get(), 0.8f, false){
                private final int maxSize;
                private static final long serialVersionUID = 1L;
                {
                    super(arg0, arg1, arg2);
                    this.maxSize = MondrianProperties.instance().ExecutionHistorySize.get();
                }

                @Override
                protected boolean removeEldestEntry(Map.Entry<Long, MutableStatementInfo> e) {
                    if (this.size() > this.maxSize) {
                        if (RolapUtil.MONITOR_LOGGER.isTraceEnabled()) {
                            RolapUtil.MONITOR_LOGGER.trace("StatementInfo(" + e.getKey() + ") evicted. Stack is:" + Util.nl + e.getValue().stack);
                        }
                        return true;
                    }
                    return false;
                }
            };
            this.executionMap = new LinkedHashMap<Long, MutableExecutionInfo>(MondrianProperties.instance().ExecutionHistorySize.get(), 0.8f, false){
                private final int maxSize;
                private static final long serialVersionUID = 1L;
                {
                    super(arg0, arg1, arg2);
                    this.maxSize = MondrianProperties.instance().ExecutionHistorySize.get();
                }

                @Override
                protected boolean removeEldestEntry(Map.Entry<Long, MutableExecutionInfo> e) {
                    if (this.size() > this.maxSize) {
                        if (RolapUtil.MONITOR_LOGGER.isTraceEnabled()) {
                            RolapUtil.MONITOR_LOGGER.trace("ExecutionInfo(" + e.getKey() + ") evicted. Stack is:" + Util.nl + e.getValue().stack);
                        }
                        return true;
                    }
                    return false;
                }
            };
            this.retiredExecutionMap = new LinkedHashMap<Long, MutableExecutionInfo>(MondrianProperties.instance().ExecutionHistorySize.get(), 0.8f, false){
                private final int maxSize;
                private static final long serialVersionUID = 1L;
                {
                    super(arg0, arg1, arg2);
                    this.maxSize = MondrianProperties.instance().ExecutionHistorySize.get();
                }

                @Override
                protected boolean removeEldestEntry(Map.Entry<Long, MutableExecutionInfo> e) {
                    if (this.size() > this.maxSize) {
                        if (RolapUtil.MONITOR_LOGGER.isTraceEnabled()) {
                            RolapUtil.MONITOR_LOGGER.trace("Retired ExecutionInfo(" + e.getKey() + ") evicted. Stack is:" + Util.nl + e.getValue().stack);
                        }
                        return true;
                    }
                    return false;
                }
            };
        }

        private Object missing(Event event) {
            return null;
        }

        @Override
        public Object visit(ConnectionStartEvent event) {
            MutableConnectionInfo conn = new MutableConnectionInfo(event.stack);
            this.connectionMap.put(event.connectionId, conn);
            this.foo(conn, event);
            this.foo(this.server.aggConn, event);
            if (RolapUtil.MONITOR_LOGGER.isTraceEnabled()) {
                RolapUtil.MONITOR_LOGGER.trace("Connection(" + event.connectionId + ") created. stack is:" + Util.nl + event.stack);
            }
            return null;
        }

        private void foo(MutableConnectionInfo conn, ConnectionStartEvent event) {
            ++conn.startCount;
        }

        @Override
        public Object visit(ConnectionEndEvent event) {
            MutableConnectionInfo conn = this.connectionMap.remove(event.connectionId);
            if (conn == null) {
                return this.missing(event);
            }
            this.foo(conn, event);
            this.foo(this.server.aggConn, event);
            RolapUtil.MONITOR_LOGGER.debug((Object)conn.fix());
            return null;
        }

        private void foo(MutableConnectionInfo conn, ConnectionEndEvent event) {
            ++conn.endCount;
        }

        @Override
        public Object visit(StatementStartEvent event) {
            MutableConnectionInfo conn = this.connectionMap.get(event.connectionId);
            if (conn == null) {
                return this.missing(event);
            }
            MutableStatementInfo stmt = new MutableStatementInfo(conn, event.statementId, event.stack);
            this.statementMap.put(event.statementId, stmt);
            this.foo(stmt, event);
            this.foo(conn.aggStmt, event);
            this.foo(this.server.aggStmt, event);
            if (RolapUtil.MONITOR_LOGGER.isTraceEnabled()) {
                RolapUtil.MONITOR_LOGGER.trace("Statement(" + event.statementId + ") created. stack is:" + Util.nl + event.stack);
            }
            return null;
        }

        private void foo(MutableStatementInfo stmt, StatementStartEvent event) {
            ++stmt.startCount;
        }

        @Override
        public Object visit(StatementEndEvent event) {
            MutableStatementInfo stmt = this.statementMap.remove(event.statementId);
            if (stmt == null) {
                return this.missing(event);
            }
            this.foo(stmt, event);
            this.foo(stmt.conn.aggStmt, event);
            this.foo(this.server.aggStmt, event);
            RolapUtil.MONITOR_LOGGER.debug((Object)stmt.fix());
            return null;
        }

        private void foo(MutableStatementInfo stmt, StatementEndEvent event) {
            ++stmt.endCount;
        }

        @Override
        public Object visit(ExecutionStartEvent event) {
            MutableStatementInfo stmt = this.statementMap.get(event.statementId);
            if (stmt == null) {
                return this.missing(event);
            }
            MutableExecutionInfo exec = new MutableExecutionInfo(stmt, event.executionId, event.stack);
            this.executionMap.put(event.executionId, exec);
            this.foo(exec, event);
            this.foo(stmt.aggExec, event);
            this.foo(stmt.conn.aggExec, event);
            this.foo(this.server.aggExec, event);
            if (RolapUtil.MONITOR_LOGGER.isTraceEnabled()) {
                RolapUtil.MONITOR_LOGGER.trace("Execution(" + event.executionId + ") created. stack is:" + Util.nl + event.stack);
            }
            return null;
        }

        private void foo(MutableExecutionInfo exec, ExecutionStartEvent event) {
            ++exec.startCount;
        }

        @Override
        public Object visit(ExecutionPhaseEvent event) {
            MutableExecutionInfo exec = this.executionMap.get(event.executionId);
            if (exec == null) {
                return this.missing(event);
            }
            this.executionMap.put(event.executionId, exec);
            this.foo(exec, event);
            this.foo(exec.stmt.aggExec, event);
            this.foo(exec.stmt.conn.aggExec, event);
            this.foo(this.server.aggExec, event);
            return null;
        }

        private void foo(MutableExecutionInfo exec, ExecutionPhaseEvent event) {
            ++exec.phaseCount;
            exec.cellCacheHitCountDelta = event.hitCount;
            exec.cellCacheMissCountDelta = event.missCount;
            exec.cellCachePendingCountDelta = event.pendingCount;
        }

        @Override
        public Object visit(ExecutionEndEvent event) {
            MutableExecutionInfo exec = this.executionMap.remove(event.executionId);
            if (exec == null) {
                return this.missing(event);
            }
            this.retiredExecutionMap.put(exec.executionId, exec);
            this.foo(exec, event);
            this.foo(exec.stmt.aggExec, event);
            this.foo(exec.stmt.conn.aggExec, event);
            this.foo(this.server.aggExec, event);
            RolapUtil.MONITOR_LOGGER.debug((Object)exec.fix());
            return null;
        }

        private void foo(MutableExecutionInfo exec, ExecutionEndEvent event) {
            ++exec.endCount;
            ++exec.phaseCount;
            exec.cellCacheHitCount += event.cellCacheHitCount;
            exec.cellCacheMissCount += event.cellCacheMissCount;
            exec.cellCachePendingCount += event.cellCachePendingCount;
            exec.cellCacheRequestCount += event.cellCacheHitCount + event.cellCacheMissCount + event.cellCachePendingCount;
            exec.cellCacheHitCountDelta = 0;
            exec.cellCacheMissCountDelta = 0;
            exec.cellCachePendingCountDelta = 0;
            exec.expCacheHitCount += event.expCacheHitCount;
            exec.expCacheMissCount += event.expCacheMissCount;
        }

        @Override
        public Object visit(CellCacheSegmentCreateEvent event) {
            MutableExecutionInfo exec = this.executionMap.get(event.executionId);
            if (exec == null && (exec = this.retiredExecutionMap.get(event.executionId)) == null) {
                return this.missing(event);
            }
            this.foo(exec, event);
            this.foo(exec.stmt.aggExec, event);
            this.foo(exec.stmt.conn.aggExec, event);
            this.foo(this.server.aggExec, event);
            return null;
        }

        private void foo(MutableExecutionInfo exec, CellCacheSegmentCreateEvent event) {
            ++exec.cellCacheSegmentCreateCount;
            exec.cellCacheSegmentCoordinateSum += event.coordinateCount;
            exec.cellCacheSegmentCellCount += event.actualCellCount;
            switch (event.source) {
                case ROLLUP: {
                    ++exec.cellCacheSegmentCreateViaRollupCount;
                    break;
                }
                case EXTERNAL: {
                    ++exec.cellCacheSegmentCreateViaExternalCount;
                    break;
                }
                case SQL: {
                    ++exec.cellCacheSegmentCreateViaSqlCount;
                    break;
                }
                default: {
                    throw Util.unexpected(event.source);
                }
            }
        }

        @Override
        public Object visit(CellCacheSegmentDeleteEvent event) {
            MutableExecutionInfo exec = this.executionMap.get(event.executionId);
            if (exec == null) {
                return this.missing(event);
            }
            this.foo(exec, event);
            this.foo(exec.stmt.aggExec, event);
            this.foo(exec.stmt.conn.aggExec, event);
            this.foo(this.server.aggExec, event);
            return null;
        }

        private void foo(MutableExecutionInfo exec, CellCacheSegmentDeleteEvent event) {
            ++exec.cellCacheSegmentDeleteCount;
            exec.cellCacheSegmentCoordinateSum -= event.coordinateCount;
            switch (event.source) {
                case EXTERNAL: {
                    ++exec.cellCacheSegmentDeleteViaExternalCount;
                }
            }
        }

        @Override
        public Object visit(SqlStatementStartEvent event) {
            MutableStatementInfo stmt = this.statementMap.get(event.getStatementId());
            if (stmt == null) {
                return this.missing(event);
            }
            MutableSqlStatementInfo sql = new MutableSqlStatementInfo(stmt, event.sqlStatementId, event.sql, event.stack);
            this.sqlStatementMap.put(event.sqlStatementId, sql);
            this.foo(sql, event);
            this.foo(sql.stmt.aggSql, event);
            this.foo(this.server.aggSql, event);
            if (RolapUtil.MONITOR_LOGGER.isTraceEnabled()) {
                RolapUtil.MONITOR_LOGGER.trace("SqlStatement(" + event.sqlStatementId + ") created. stack is:" + Util.nl + event.stack);
            }
            return null;
        }

        private void foo(MutableSqlStatementInfo sql, SqlStatementStartEvent event) {
            ++sql.startCount;
            sql.cellRequestCount += event.cellRequestCount;
        }

        @Override
        public Object visit(SqlStatementExecuteEvent event) {
            MutableSqlStatementInfo sql = this.sqlStatementMap.get(event.sqlStatementId);
            if (sql == null) {
                return this.missing(event);
            }
            this.foo(sql, event);
            this.foo(sql.stmt.aggSql, event);
            this.foo(this.server.aggSql, event);
            return null;
        }

        private void foo(MutableSqlStatementInfo sql, SqlStatementExecuteEvent event) {
            ++sql.executeCount;
            sql.executeNanos += event.executeNanos;
        }

        @Override
        public Object visit(SqlStatementEndEvent event) {
            MutableSqlStatementInfo sql = this.sqlStatementMap.remove(event.sqlStatementId);
            if (sql == null) {
                return this.missing(event);
            }
            this.foo(sql, event);
            this.foo(sql.stmt.aggSql, event);
            this.foo(this.server.aggSql, event);
            RolapUtil.MONITOR_LOGGER.debug((Object)sql.fix());
            return null;
        }

        private void foo(MutableSqlStatementInfo sql, SqlStatementEndEvent event) {
            ++sql.endCount;
            sql.rowFetchCount += event.rowFetchCount;
        }

        @Override
        public Object visit(ConnectionsCommand connectionsCommand) {
            ArrayList<ConnectionInfo> list = new ArrayList<ConnectionInfo>();
            for (MutableConnectionInfo info : this.connectionMap.values()) {
                list.add(info.fix());
            }
            return list;
        }

        @Override
        public Object visit(ServerCommand serverCommand) {
            return this.server.fix();
        }

        @Override
        public Object visit(SqlStatementsCommand command) {
            ArrayList<SqlStatementInfo> list = new ArrayList<SqlStatementInfo>();
            for (MutableSqlStatementInfo info : this.sqlStatementMap.values()) {
                list.add(info.fix());
            }
            return list;
        }

        @Override
        public Object visit(StatementsCommand command) {
            ArrayList<StatementInfo> list = new ArrayList<StatementInfo>();
            for (MutableStatementInfo info : this.statementMap.values()) {
                list.add(info.fix());
            }
            return list;
        }

        @Override
        public Object visit(ShutdownCommand command) {
            return "Shutdown succeeded";
        }
    }

    private static class MutableSqlStatementInfo {
        private final MutableStatementInfo stmt;
        private final long sqlStatementId;
        private int startCount;
        private int executeCount;
        private int endCount;
        private int cellRequestCount;
        private long executeNanos;
        private long rowFetchCount;
        private final String stack;
        private final String sql;

        public MutableSqlStatementInfo(MutableStatementInfo stmt, long sqlStatementId, String sql, String stack) {
            this.sqlStatementId = sqlStatementId;
            this.stmt = stmt;
            this.sql = sql;
            this.stack = stack;
        }

        public SqlStatementInfo fix() {
            return new SqlStatementInfo(this.stack, this.sqlStatementId, this.sql);
        }
    }

    private static class MutableExecutionInfo {
        private final MutableStatementInfo stmt;
        private final long executionId;
        private final MutableSqlStatementInfo aggSql = new MutableSqlStatementInfo(null, -1L, null, null);
        private int startCount;
        private int phaseCount;
        private int endCount;
        private int cellCacheRequestCount;
        private int cellCacheHitCount;
        private int cellCacheMissCount;
        private int cellCachePendingCount;
        private int cellCacheHitCountDelta;
        private int cellCacheMissCountDelta;
        private int cellCachePendingCountDelta;
        private int cellCacheSegmentCreateCount;
        private int cellCacheSegmentCreateViaRollupCount;
        private int cellCacheSegmentCreateViaSqlCount;
        private int cellCacheSegmentCreateViaExternalCount;
        private int cellCacheSegmentDeleteViaExternalCount;
        private int cellCacheSegmentDeleteCount;
        private int cellCacheSegmentCoordinateSum;
        private int cellCacheSegmentCellCount;
        private final String stack;
        private int expCacheHitCount;
        private int expCacheMissCount;

        public MutableExecutionInfo(MutableStatementInfo stmt, long executionId, String stack) {
            this.stmt = stmt;
            this.executionId = executionId;
            this.stack = stack;
        }

        public ExecutionInfo fix() {
            return new ExecutionInfo(this.stack, this.executionId, this.phaseCount, this.cellCacheRequestCount, this.cellCacheHitCount, this.cellCacheMissCount, this.cellCachePendingCount, this.aggSql.startCount, this.aggSql.executeCount, this.aggSql.endCount, this.aggSql.rowFetchCount, this.aggSql.executeNanos, this.aggSql.cellRequestCount, this.expCacheHitCount, this.expCacheMissCount);
        }
    }

    private static class MutableStatementInfo {
        private final MutableConnectionInfo conn;
        private final long statementId;
        private final MutableExecutionInfo aggExec = new MutableExecutionInfo(null, -1L, null);
        private final MutableSqlStatementInfo aggSql = new MutableSqlStatementInfo(null, -1L, null, null);
        private int startCount;
        private int endCount;
        private final String stack;

        public MutableStatementInfo(MutableConnectionInfo conn, long statementId, String stack) {
            this.statementId = statementId;
            this.conn = conn;
            this.stack = stack;
        }

        public StatementInfo fix() {
            return new StatementInfo(this.stack, this.statementId, this.aggExec.startCount, this.aggExec.endCount, this.aggExec.phaseCount, this.aggExec.cellCacheRequestCount, this.aggExec.cellCacheHitCount, this.aggExec.cellCacheMissCount, this.aggExec.cellCachePendingCount, this.aggSql.startCount, this.aggSql.executeCount, this.aggSql.endCount, this.aggSql.rowFetchCount, this.aggSql.executeNanos, this.aggSql.cellRequestCount);
        }
    }

    private static class MutableConnectionInfo {
        private final MutableExecutionInfo aggExec = new MutableExecutionInfo(null, -1L, null);
        private final MutableStatementInfo aggStmt = new MutableStatementInfo(null, -1L, null);
        private int startCount;
        private int endCount;
        private final String stack;

        public MutableConnectionInfo(String stack) {
            this.stack = stack;
        }

        public ConnectionInfo fix() {
            return new ConnectionInfo(this.stack, this.aggExec.cellCacheHitCount, this.aggExec.cellCacheRequestCount, this.aggExec.cellCacheMissCount, this.aggExec.cellCachePendingCount, this.aggStmt.startCount, this.aggStmt.endCount, this.aggExec.startCount, this.aggExec.endCount);
        }
    }

    private static class MutableServerInfo {
        private final MutableSqlStatementInfo aggSql = new MutableSqlStatementInfo(null, -1L, null, null);
        private final MutableExecutionInfo aggExec = new MutableExecutionInfo(null, -1L, null);
        private final MutableStatementInfo aggStmt = new MutableStatementInfo(null, -1L, null);
        private final MutableConnectionInfo aggConn = new MutableConnectionInfo(null);
        private final String stack;

        public MutableServerInfo(String stack) {
            this.stack = stack;
        }

        public ServerInfo fix() {
            Util.MemoryInfo.Usage memoryUsage = MEMORY_INFO.get();
            return new ServerInfo(this.stack, this.aggConn.startCount, this.aggConn.endCount, this.aggStmt.startCount, this.aggStmt.endCount, this.aggSql.startCount, this.aggSql.executeCount, this.aggSql.endCount, this.aggSql.rowFetchCount, this.aggSql.executeNanos, this.aggSql.cellRequestCount, this.aggExec.cellCacheHitCount, this.aggExec.cellCacheRequestCount, this.aggExec.cellCacheMissCount, this.aggExec.cellCachePendingCount, this.aggExec.startCount, this.aggExec.endCount, memoryUsage.getUsed(), memoryUsage.getCommitted(), memoryUsage.getMax(), this.aggExec.cellCacheSegmentCreateCount - this.aggExec.cellCacheSegmentDeleteCount, this.aggExec.cellCacheSegmentCreateCount, this.aggExec.cellCacheSegmentCreateViaExternalCount, this.aggExec.cellCacheSegmentDeleteViaExternalCount, this.aggExec.cellCacheSegmentCreateViaRollupCount, this.aggExec.cellCacheSegmentCreateViaSqlCount, this.aggExec.cellCacheSegmentCellCount, this.aggExec.cellCacheSegmentCoordinateSum);
        }
    }

    static interface CommandVisitor<T>
    extends Visitor<T> {
        public T visit(ConnectionsCommand var1);

        public T visit(ServerCommand var1);

        public T visit(SqlStatementsCommand var1);

        public T visit(StatementsCommand var1);

        public T visit(ShutdownCommand var1);
    }

    static class ShutdownCommand
    extends Command {
        ShutdownCommand() {
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return ((CommandVisitor)visitor).visit(this);
        }
    }

    static class ServerCommand
    extends Command {
        ServerCommand() {
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return ((CommandVisitor)visitor).visit(this);
        }
    }

    static class ConnectionsCommand
    extends Command {
        ConnectionsCommand() {
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return ((CommandVisitor)visitor).visit(this);
        }
    }

    static class SqlStatementsCommand
    extends Command {
        SqlStatementsCommand() {
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return ((CommandVisitor)visitor).visit(this);
        }
    }

    static class StatementsCommand
    extends Command {
        StatementsCommand() {
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return ((CommandVisitor)visitor).visit(this);
        }
    }

    static abstract class Command
    implements Message {
        private final MDCUtil mdc = new MDCUtil();

        Command() {
        }

        @Override
        public void setContextMap() {
            this.mdc.setContextMap();
        }
    }
}

