/*
 * Decompiled with CFR 0.152.
 */
package mondrian.recorder;

import java.util.ArrayList;
import java.util.List;
import mondrian.recorder.MessageRecorder;
import mondrian.recorder.RecorderException;
import mondrian.resource.MondrianResource;
import org.apache.logging.log4j.Logger;

public abstract class AbstractRecorder
implements MessageRecorder {
    public static final int DEFAULT_MSG_LIMIT = 10;
    private final int errorMsgLimit;
    private final List<String> contexts;
    private int errorMsgCount;
    private int warningMsgCount;
    private int infoMsgCount;
    private String contextMsgCache;
    private long startTime;

    public static void logMessage(String context, String msg, MsgType msgType, Logger logger) {
        StringBuilder buf = new StringBuilder(64);
        buf.append(context);
        buf.append(": ");
        buf.append(msg);
        switch (msgType) {
            case INFO: {
                logger.info(buf.toString());
                break;
            }
            case WARN: {
                logger.warn(buf.toString());
                break;
            }
            case ERROR: {
                logger.error(buf.toString());
                break;
            }
            default: {
                logger.warn("Unknown message type enum \"" + (Object)((Object)msgType) + "\" for message: " + buf.toString());
            }
        }
    }

    protected AbstractRecorder() {
        this(10);
    }

    protected AbstractRecorder(int errorMsgLimit) {
        this.errorMsgLimit = errorMsgLimit;
        this.contexts = new ArrayList<String>();
        this.startTime = System.currentTimeMillis();
    }

    @Override
    public void clear() {
        this.errorMsgCount = 0;
        this.warningMsgCount = 0;
        this.infoMsgCount = 0;
        this.contextMsgCache = null;
        this.contexts.clear();
        this.startTime = System.currentTimeMillis();
    }

    @Override
    public long getStartTimeMillis() {
        return this.startTime;
    }

    @Override
    public long getRunTimeMillis() {
        return System.currentTimeMillis() - this.startTime;
    }

    @Override
    public boolean hasInformation() {
        return this.infoMsgCount > 0;
    }

    @Override
    public boolean hasWarnings() {
        return this.warningMsgCount > 0;
    }

    @Override
    public boolean hasErrors() {
        return this.errorMsgCount > 0;
    }

    public int getInfoCount() {
        return this.infoMsgCount;
    }

    public int getWarningCount() {
        return this.warningMsgCount;
    }

    public int getErrorCount() {
        return this.errorMsgCount;
    }

    @Override
    public String getContext() {
        if (this.contextMsgCache == null) {
            StringBuilder buf = new StringBuilder();
            int k = 0;
            for (String name : this.contexts) {
                if (k++ > 0) {
                    buf.append(':');
                }
                buf.append(name);
            }
            this.contextMsgCache = buf.toString();
        }
        return this.contextMsgCache;
    }

    @Override
    public void pushContextName(String name) {
        this.contexts.add(name);
        this.contextMsgCache = null;
    }

    @Override
    public void popContextName() {
        this.contexts.remove(this.contexts.size() - 1);
        this.contextMsgCache = null;
    }

    @Override
    public void throwRTException() throws RecorderException {
        if (this.hasErrors()) {
            String errorMsg = MondrianResource.instance().ForceMessageRecorderError.str(this.getContext(), this.errorMsgCount);
            throw new RecorderException(errorMsg);
        }
    }

    @Override
    public void reportError(Exception ex) throws RecorderException {
        this.reportError(ex, null);
    }

    @Override
    public void reportError(Exception ex, Object info) throws RecorderException {
        this.reportError(ex.toString(), info);
    }

    @Override
    public void reportError(String msg) throws RecorderException {
        this.reportError(msg, null);
    }

    @Override
    public void reportError(String msg, Object info) throws RecorderException {
        ++this.errorMsgCount;
        this.recordMessage(msg, info, MsgType.ERROR);
        if (this.errorMsgCount >= this.errorMsgLimit) {
            String errorMsg = MondrianResource.instance().TooManyMessageRecorderErrors.str(this.getContext(), this.errorMsgCount);
            throw new RecorderException(errorMsg);
        }
    }

    @Override
    public void reportWarning(String msg) {
        this.reportWarning(msg, null);
    }

    @Override
    public void reportWarning(String msg, Object info) {
        ++this.warningMsgCount;
        this.recordMessage(msg, info, MsgType.WARN);
    }

    @Override
    public void reportInfo(String msg) {
        this.reportInfo(msg, null);
    }

    @Override
    public void reportInfo(String msg, Object info) {
        ++this.infoMsgCount;
        this.recordMessage(msg, info, MsgType.INFO);
    }

    protected abstract void recordMessage(String var1, Object var2, MsgType var3);

    static enum MsgType {
        INFO,
        WARN,
        ERROR;

    }
}

