/*
 * Decompiled with CFR 0.152.
 */
package mondrian.mdx;

import java.io.PrintWriter;
import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.ParameterCompilable;
import mondrian.mdx.MdxVisitor;
import mondrian.mdx.QueryPrintWriter;
import mondrian.olap.Category;
import mondrian.olap.Exp;
import mondrian.olap.ExpBase;
import mondrian.olap.Parameter;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.type.SetType;
import mondrian.olap.type.Type;
import mondrian.olap.type.TypeUtil;

public class ParameterExpr
extends ExpBase {
    private Parameter parameter;

    public ParameterExpr(Parameter parameter) {
        this.parameter = parameter;
    }

    @Override
    public Type getType() {
        return this.parameter.getType();
    }

    @Override
    public int getCategory() {
        return TypeUtil.typeToCategory(this.parameter.getType());
    }

    @Override
    public Exp accept(Validator validator) {
        String parameterName = this.parameter.getName();
        SchemaReader schemaReader = validator.getQuery().getSchemaReader(false);
        Parameter p = schemaReader.getParameter(parameterName);
        this.parameter = p == null ? validator.createOrLookupParam(true, this.parameter.getName(), this.parameter.getType(), this.parameter.getDefaultExp(), this.parameter.getDescription()) : p;
        return this;
    }

    @Override
    public Calc accept(ExpCompiler compiler) {
        return ((ParameterCompilable)this.parameter).compile(compiler);
    }

    @Override
    public Object accept(MdxVisitor visitor) {
        return visitor.visit(this);
    }

    @Override
    public ParameterExpr clone() {
        return new ParameterExpr(this.parameter);
    }

    @Override
    public void unparse(PrintWriter pw) {
        boolean def = pw instanceof QueryPrintWriter && this.parameter.getScope() == Parameter.Scope.Statement ? ((QueryPrintWriter)pw).parameters.add(this.parameter) : false;
        String name = this.parameter.getName();
        Type type = this.parameter.getType();
        int category = TypeUtil.typeToCategory(type);
        if (def) {
            pw.print("Parameter(" + Util.quoteForMdx(name) + ", ");
            switch (category) {
                case 7: 
                case 9: {
                    pw.print(Category.instance.getName(category).toUpperCase());
                    break;
                }
                case 6: {
                    pw.print(this.uniqueName(type));
                    break;
                }
                case 8: {
                    Type elementType = ((SetType)type).getElementType();
                    pw.print(this.uniqueName(elementType));
                    break;
                }
                default: {
                    throw Category.instance.badValue(category);
                }
            }
            pw.print(", ");
            Object value = this.parameter.getValue();
            if (value == null) {
                this.parameter.getDefaultExp().unparse(pw);
            } else if (value instanceof String) {
                String s = (String)value;
                pw.print(Util.quoteForMdx(s));
            } else if (value instanceof List) {
                List list = (List)value;
                pw.print("{");
                int i = -1;
                for (Object o : list) {
                    if (++i > 0) {
                        pw.print(", ");
                    }
                    pw.print(o);
                }
                pw.print("}");
            } else {
                pw.print(value);
            }
            String description = this.parameter.getDescription();
            if (description != null) {
                pw.print(", " + Util.quoteForMdx(description));
            }
            pw.print(")");
        } else {
            pw.print("ParamRef(" + Util.quoteForMdx(name) + ")");
        }
    }

    private String uniqueName(Type type) {
        if (type.getLevel() != null) {
            return type.getLevel().getUniqueName();
        }
        if (type.getHierarchy() != null) {
            return type.getHierarchy().getUniqueName();
        }
        return type.getDimension().getUniqueName();
    }

    @Override
    public Object[] getChildren() {
        return null;
    }

    public boolean equals(Object other) {
        if (!(other instanceof ParameterExpr)) {
            return false;
        }
        ParameterExpr that = (ParameterExpr)other;
        return this.parameter == that.parameter;
    }

    public int hashCode() {
        return this.parameter.hashCode();
    }

    public boolean isModifiable() {
        return true;
    }

    public Parameter getParameter() {
        return this.parameter;
    }
}

