/*
 * Decompiled with CFR 0.152.
 */
package mondrian.i18n;

import java.io.InputStream;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Util;
import mondrian.spi.DynamicSchemaProcessor;
import mondrian.spi.impl.FilterDynamicSchemaProcessor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LocalizingDynamicSchemaProcessor
extends FilterDynamicSchemaProcessor
implements DynamicSchemaProcessor {
    private static final Logger LOGGER = LogManager.getLogger(LocalizingDynamicSchemaProcessor.class);
    private ResourceBundle bundle;
    private static final Pattern pattern = Pattern.compile("(%\\{.*?\\})");
    private String locale;

    void populate(String propFile) {
        if (propFile.endsWith(".properties")) {
            propFile = propFile.substring(0, propFile.length() - ".properties".length());
        }
        try {
            this.bundle = ResourceBundle.getBundle(propFile, Util.parseLocale(this.locale), this.getClass().getClassLoader());
        }
        catch (Exception e) {
            LOGGER.warn("Mondrian: Warning: no suitable locale file found for locale '" + this.locale + "'", (Throwable)e);
        }
    }

    private void loadProperties() {
        String propFile = MondrianProperties.instance().LocalePropFile.get();
        if (propFile != null) {
            this.populate(propFile);
        }
    }

    private void applyLocale(Util.PropertyList connectInfo) {
        this.setLocale(connectInfo.get("Locale") == null ? Locale.getDefault().toString() : connectInfo.get("Locale"));
    }

    private String applyReplacement(String content) {
        if (this.bundle != null) {
            content = this.doRegExReplacements(content);
        }
        LOGGER.debug(content);
        return content;
    }

    @Override
    public String filter(String schemaUrl, Util.PropertyList connectInfo, InputStream stream) throws Exception {
        this.applyLocale(connectInfo);
        this.loadProperties();
        return this.applyReplacement(super.filter(schemaUrl, connectInfo, stream));
    }

    @Override
    public String filter(String catalog, Util.PropertyList connectInfo) {
        this.applyLocale(connectInfo);
        this.loadProperties();
        return this.applyReplacement(catalog);
    }

    private String doRegExReplacements(String schema) {
        StringBuffer intlSchema = new StringBuffer();
        Matcher match = pattern.matcher(schema);
        while (match.find()) {
            String key = this.extractKey(match.group());
            int start = match.start();
            int end = match.end();
            try {
                String intlProperty = this.bundle.getString(key);
                if (intlProperty == null) continue;
                match.appendReplacement(intlSchema, intlProperty);
            }
            catch (MissingResourceException e) {
                LOGGER.error("Missing resource for key [" + key + "]", (Throwable)e);
            }
            catch (NullPointerException e) {
                LOGGER.error("missing resource key at substring(" + start + "," + end + ")", (Throwable)e);
            }
        }
        match.appendTail(intlSchema);
        return intlSchema.toString();
    }

    private String extractKey(String group) {
        return group.substring(2, group.length() - 1);
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }
}

