/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.util;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import mondrian.olap.Dimension;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.Position;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.util.MemberAddingStrategy;

public class SortedMemberAddingStrategy
implements MemberAddingStrategy {
    private TreeSet<Member> set;

    public SortedMemberAddingStrategy(List<Position> positions) {
        this.set = new TreeSet<Member>(new MemberComparator(positions));
    }

    @Override
    public void add(Member m) {
        this.set.add(m);
    }

    @Override
    public Collection<Member> values() {
        return this.set;
    }

    private static class MemberComparator
    implements Comparator<Member> {
        private Map<Dimension, Integer> dimensionOrder;

        public MemberComparator(List<Position> positions) {
            LinkedHashSet<Dimension> dimensionInOrder = new LinkedHashSet<Dimension>();
            for (Position position : positions) {
                for (Member member : position) {
                    dimensionInOrder.add(member.getDimension());
                }
            }
            this.dimensionOrder = new HashMap<Dimension, Integer>();
            for (Dimension dimension : dimensionInOrder) {
                this.dimensionOrder.put(dimension, this.dimensionOrder.size());
            }
        }

        private int getDimensionPositionOnAxis(Dimension d) {
            Integer integer = this.dimensionOrder.get(d);
            if (integer != null) {
                return integer;
            }
            return -1;
        }

        @Override
        public int compare(Member o1, Member o2) {
            Dimension d1 = o1.getLevel().getDimension();
            Dimension d2 = o2.getLevel().getDimension();
            int dimOrder = Integer.compare(this.getDimensionPositionOnAxis(d1), this.getDimensionPositionOnAxis(d2));
            if (dimOrder != 0) {
                return dimOrder;
            }
            Hierarchy h1 = o1.getHierarchy();
            Hierarchy h2 = o2.getHierarchy();
            int hierarchyOrder = h1.getName().compareTo(h2.getName());
            if (hierarchyOrder != 0) {
                return hierarchyOrder;
            }
            Level level1 = o1.getLevel();
            Level level2 = o2.getLevel();
            int levelOrder = Integer.compare(level1.getDepth(), level2.getDepth());
            if (levelOrder != 0) {
                return levelOrder;
            }
            return o1.getLevel().getUniqueName().compareTo(o2.getLevel().getUniqueName());
        }
    }
}

