/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.parser;

import java.util.Map;
import java.util.Properties;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.common.PasswordPropertiesReadHandler;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.DataSourceProvider;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.DriverDataSourceProvider;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.parser.DataSourceProviderReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.AbstractXmlReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.StringReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DriverDataSourceProviderReadHandler
extends AbstractXmlReadHandler
implements DataSourceProviderReadHandler {
    private StringReadHandler driverReadHandler;
    private StringReadHandler urlReadHandler;
    private PasswordPropertiesReadHandler propertiesReadHandler;
    private DriverDataSourceProvider driverConnectionProvider;

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        if (!this.isSameNamespace(uri)) {
            return null;
        }
        if ("driver".equals(tagName)) {
            this.driverReadHandler = new StringReadHandler();
            return this.driverReadHandler;
        }
        if ("url".equals(tagName)) {
            this.urlReadHandler = new StringReadHandler();
            return this.urlReadHandler;
        }
        if ("properties".equals(tagName)) {
            this.propertiesReadHandler = new PasswordPropertiesReadHandler();
            return this.propertiesReadHandler;
        }
        return null;
    }

    protected void doneParsing() throws SAXException {
        DriverDataSourceProvider provider = new DriverDataSourceProvider();
        if (this.driverReadHandler != null) {
            provider.setDriver(this.driverReadHandler.getResult());
        }
        if (this.urlReadHandler != null) {
            provider.setUrl(this.urlReadHandler.getResult());
        }
        if (this.propertiesReadHandler != null) {
            Properties p = (Properties)this.propertiesReadHandler.getObject();
            for (Map.Entry<Object, Object> entry : p.entrySet()) {
                provider.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
        this.driverConnectionProvider = provider;
    }

    public Object getObject() throws SAXException {
        return this.driverConnectionProvider;
    }

    @Override
    public DataSourceProvider getProvider() {
        return this.driverConnectionProvider;
    }
}

