/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.wizard.parser;

import org.pentaho.reporting.engine.classic.core.modules.parser.base.compat.CompatibilityMapperUtil;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanException;
import org.pentaho.reporting.engine.classic.core.util.beans.ConverterRegistry;
import org.pentaho.reporting.engine.classic.core.wizard.MetaSelector;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.xmlns.parser.AbstractXmlReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class MetaSelectorReadHandler
extends AbstractXmlReadHandler {
    private String domain;
    private String name;
    private Object value;

    protected void startParsing(Attributes attrs) throws SAXException {
        this.domain = attrs.getValue(this.getUri(), "domain");
        if (this.domain == null) {
            throw new ParseException("Required attribute 'domain' is missing.", this.getLocator());
        }
        this.name = attrs.getValue(this.getUri(), "name");
        if (this.name == null) {
            throw new ParseException("Required attribute 'name' is missing.", this.getLocator());
        }
        String type = attrs.getValue(this.getUri(), "type");
        String rawValue = attrs.getValue(this.getUri(), "value");
        if (rawValue == null) {
            this.value = null;
        } else if (type == null) {
            this.value = rawValue;
        } else {
            try {
                ClassLoader loader = ObjectUtilities.getClassLoader(MetaSelectorReadHandler.class);
                Class<?> aClass = Class.forName(CompatibilityMapperUtil.mapClassName(type), false, loader);
                this.value = ConverterRegistry.toPropertyValue(rawValue, aClass);
            }
            catch (ClassNotFoundException e) {
                throw new ParseException("Required attribute 'type' is invalid.", (Exception)e, this.getLocator());
            }
            catch (BeanException e) {
                throw new ParseException("Required attribute 'value' is invalid.", (Exception)e, this.getLocator());
            }
        }
    }

    public Object getObject() throws SAXException {
        return new MetaSelector(this.domain, this.name, this.value);
    }
}

