/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.wizard;

import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.wizard.DataSchemaDefinition;
import org.pentaho.reporting.engine.classic.core.wizard.DefaultDataSchemaDefinition;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKeyCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class DataSchemaUtility {
    private static final Log logger = LogFactory.getLog(DataSchemaUtility.class);
    private static DataSchemaDefinition cachedDataSchema;

    private DataSchemaUtility() {
    }

    public static void clearCachedDataSchema() {
        cachedDataSchema = null;
    }

    public static DataSchemaDefinition parseDefaults(ResourceManager manager) {
        if (manager == null) {
            throw new NullPointerException();
        }
        DataSchemaDefinition fromCache = cachedDataSchema;
        if (fromCache != null) {
            return (DataSchemaDefinition)fromCache.clone();
        }
        Configuration configuration = ClassicEngineBoot.getInstance().getGlobalConfig();
        Iterator sources = configuration.findPropertyKeys("org.pentaho.reporting.engine.classic.core.DataSchemaDefinition");
        DefaultDataSchemaDefinition definition = new DefaultDataSchemaDefinition();
        while (sources.hasNext()) {
            String sourceKey = configuration.getConfigProperty((String)sources.next());
            try {
                logger.debug((Object)("Loading data-schema " + sourceKey));
                Resource resource = manager.createDirectly((Object)sourceKey, DataSchemaDefinition.class);
                DataSchemaDefinition fromResource = (DataSchemaDefinition)resource.getResource();
                definition.merge(fromResource);
            }
            catch (ResourceKeyCreationException e) {
                logger.debug((Object)("Unable to create key for schema " + sourceKey), (Throwable)e);
            }
            catch (ResourceLoadingException e) {
                logger.debug((Object)("Unable to load data for key for schema " + sourceKey), (Throwable)e);
            }
            catch (ResourceException e) {
                logger.debug((Object)"Unable to load data-schema definition", (Throwable)e);
            }
        }
        cachedDataSchema = (DataSchemaDefinition)definition.clone();
        return definition;
    }
}

