/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.style.css;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.css.CSSCounterRule;
import org.pentaho.reporting.engine.classic.core.style.css.DocumentContext;
import org.pentaho.reporting.engine.classic.core.style.css.ElementStyleDefinition;
import org.pentaho.reporting.engine.classic.core.style.css.ElementStyleRule;
import org.pentaho.reporting.engine.classic.core.style.css.StyleRuleMatcher;
import org.pentaho.reporting.engine.classic.core.style.css.namespaces.NamespaceCollection;
import org.pentaho.reporting.engine.classic.core.style.css.namespaces.NamespaceDefinition;
import org.pentaho.reporting.engine.classic.core.style.css.selector.CSSSelector;
import org.pentaho.reporting.engine.classic.core.style.css.selector.SelectorWeight;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanException;
import org.pentaho.reporting.engine.classic.core.util.beans.ConverterRegistry;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceKeyCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.w3c.css.sac.AttributeCondition;
import org.w3c.css.sac.CombinatorCondition;
import org.w3c.css.sac.Condition;
import org.w3c.css.sac.ConditionalSelector;
import org.w3c.css.sac.DescendantSelector;
import org.w3c.css.sac.ElementSelector;
import org.w3c.css.sac.NegativeCondition;
import org.w3c.css.sac.NegativeSelector;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SiblingSelector;
import org.w3c.css.sac.SimpleSelector;

public class SimpleStyleRuleMatcher
implements StyleRuleMatcher {
    private ResourceManager resourceManager;
    private ElementStyleRule[] activeStyleRules;
    private ElementStyleRule[] activePseudoStyleRules;
    private NamespaceCollection namespaces;
    private DocumentContext context;

    @Override
    public void initialize(DocumentContext layoutProcess) {
        if (layoutProcess == null) {
            throw new NullPointerException();
        }
        this.context = layoutProcess;
        this.resourceManager = layoutProcess.getResourceManager();
        ArrayList<CSSCounterRule> counterRules = new ArrayList<CSSCounterRule>();
        ArrayList<ElementStyleRule> styleRules = new ArrayList<ElementStyleRule>();
        DocumentContext dc = this.context;
        this.namespaces = dc.getNamespaces();
        if (dc.getStyleResource() != null) {
            this.handleLinkNode(dc.getStyleResource(), styleRules, counterRules);
        }
        if (dc.getStyleDefinition() != null) {
            this.handleStyleNode(dc.getStyleDefinition(), styleRules, counterRules);
        }
        this.activeStyleRules = styleRules.toArray(new ElementStyleRule[styleRules.size()]);
        styleRules.clear();
        for (int i = 0; i < this.activeStyleRules.length; ++i) {
            ElementStyleRule activeStyleRule = this.activeStyleRules[i];
            if (!this.isPseudoElementRule(activeStyleRule)) continue;
            styleRules.add(activeStyleRule);
        }
        this.activePseudoStyleRules = styleRules.toArray(new ElementStyleRule[styleRules.size()]);
    }

    private void handleLinkNode(Object styleResource, ArrayList<ElementStyleRule> styleRules, ArrayList<CSSCounterRule> counterRules) {
        try {
            String href = (String)styleResource;
            ResourceKey baseKey = this.context.getContextKey();
            ResourceKey derivedKey = baseKey == null ? this.resourceManager.createKey((Object)href) : this.resourceManager.deriveKey(baseKey, String.valueOf(href));
            ElementStyleDefinition styleSheet = this.parseStyleSheet(derivedKey, null);
            if (styleSheet == null) {
                return;
            }
            this.addStyleRules(styleSheet, styleRules);
            this.addCounterRules(styleSheet, counterRules);
        }
        catch (ResourceKeyCreationException e) {
            e.printStackTrace();
        }
    }

    private void handleStyleNode(ElementStyleDefinition node, ArrayList<ElementStyleRule> styleRules, ArrayList<CSSCounterRule> counterRules) {
        this.addStyleRules(node, styleRules);
        this.addCounterRules(node, counterRules);
    }

    private void addCounterRules(ElementStyleDefinition styleSheet, ArrayList<CSSCounterRule> rules) {
        int sc = styleSheet.getStyleSheetCount();
        for (int i = 0; i < sc; ++i) {
            this.addCounterRules(styleSheet.getStyleSheet(i), rules);
        }
        int rc = styleSheet.getRuleCount();
        for (int i = 0; i < rc; ++i) {
            ElementStyleSheet rule = styleSheet.getRule(i);
            if (!(rule instanceof CSSCounterRule)) continue;
            CSSCounterRule drule = (CSSCounterRule)rule;
            rules.add(drule);
        }
    }

    private void addStyleRules(ElementStyleDefinition styleSheet, ArrayList<ElementStyleRule> activeStyleRules) {
        int sc = styleSheet.getStyleSheetCount();
        for (int i = 0; i < sc; ++i) {
            this.addStyleRules(styleSheet.getStyleSheet(i), activeStyleRules);
        }
        int rc = styleSheet.getRuleCount();
        for (int i = 0; i < rc; ++i) {
            ElementStyleSheet rule = styleSheet.getRule(i);
            if (!(rule instanceof ElementStyleRule)) continue;
            ElementStyleRule drule = (ElementStyleRule)rule;
            activeStyleRules.add(drule);
        }
    }

    private ElementStyleDefinition parseStyleSheet(ResourceKey key, ResourceKey context) {
        try {
            Resource resource = this.resourceManager.create(key, context, ElementStyleDefinition.class);
            return (ElementStyleDefinition)resource.getResource();
        }
        catch (ResourceException resourceException) {
            return null;
        }
    }

    private boolean isPseudoElementRule(ElementStyleRule rule) {
        List<CSSSelector> selectorList = rule.getSelectorList();
        for (int i = 0; i < selectorList.size(); ++i) {
            ConditionalSelector cs;
            Condition condition;
            CSSSelector selector = selectorList.get(i);
            if (selector == null || selector.getSelectorType() != 0 || (condition = (cs = (ConditionalSelector)selector).getCondition()).getConditionType() != 10) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isMatchingPseudoElement(ReportElement element, String pseudo) {
        for (int i = 0; i < this.activePseudoStyleRules.length; ++i) {
            ElementStyleRule activeStyleRule = this.activePseudoStyleRules[i];
            List<CSSSelector> selectorList = activeStyleRule.getSelectorList();
            for (int x = 0; x < selectorList.size(); ++x) {
                SimpleSelector simpleSelector;
                ConditionalSelector cs;
                Condition condition;
                AttributeCondition ac;
                CSSSelector selector = selectorList.get(x);
                if (!(selector instanceof ConditionalSelector) || !ObjectUtilities.equal((Object)(ac = (AttributeCondition)(condition = (cs = (ConditionalSelector)selector).getCondition())).getValue(), (Object)pseudo) || !this.isMatch(element, (Selector)(simpleSelector = cs.getSimpleSelector()))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public StyleRuleMatcher deriveInstance() {
        return this;
    }

    @Override
    public StyleRuleMatcher.MatcherResult[] getMatchingRules(ReportElement element) {
        ArrayList<StyleRuleMatcher.MatcherResult> retvals = new ArrayList<StyleRuleMatcher.MatcherResult>();
        for (int i = 0; i < this.activeStyleRules.length; ++i) {
            ElementStyleRule activeStyleRule = this.activeStyleRules[i];
            List<CSSSelector> selectorList = activeStyleRule.getSelectorList();
            SelectorWeight weight = null;
            for (int x = 0; x < selectorList.size(); ++x) {
                CSSSelector selector = selectorList.get(x);
                if (selector == null || !this.isMatch(element, selector)) continue;
                if (weight == null) {
                    weight = selector.getWeight();
                    continue;
                }
                if (weight.compareTo(selector.getWeight()) >= 0) continue;
                weight = selector.getWeight();
            }
            if (weight == null) continue;
            retvals.add(new StyleRuleMatcher.MatcherResult(weight, activeStyleRule));
        }
        return retvals.toArray(new StyleRuleMatcher.MatcherResult[retvals.size()]);
    }

    private boolean isMatch(ReportElement node, Selector selector) {
        short selectorType = selector.getSelectorType();
        switch (selectorType) {
            case 1: {
                return true;
            }
            case 2: {
                return node.getParentSection() == null;
            }
            case 3: {
                NegativeSelector negativeSelector = (NegativeSelector)selector;
                return !this.isMatch(node, (Selector)negativeSelector);
            }
            case 12: {
                SiblingSelector silbSelect = (SiblingSelector)selector;
                return this.isSilblingMatch(node, silbSelect);
            }
            case 9: {
                return false;
            }
            case 4: {
                String namespace;
                ElementSelector es = (ElementSelector)selector;
                String localName = es.getLocalName();
                if (localName != null && !localName.equals(this.getTagName(node))) {
                    return false;
                }
                String namespaceURI = es.getNamespaceURI();
                return namespaceURI == null || namespaceURI.equals(namespace = this.getNamespace(node));
            }
            case 11: {
                DescendantSelector ds = (DescendantSelector)selector;
                if (!this.isMatch(node, (Selector)ds.getSimpleSelector())) {
                    return false;
                }
                Section parent = node.getParentSection();
                return this.isMatch(parent, ds.getAncestorSelector());
            }
            case 10: {
                DescendantSelector ds = (DescendantSelector)selector;
                if (!this.isMatch(node, (Selector)ds.getSimpleSelector())) {
                    return false;
                }
                return this.isDescendantMatch(node, ds.getAncestorSelector());
            }
            case 0: {
                ConditionalSelector cs = (ConditionalSelector)selector;
                if (!this.evaluateCondition(node, cs.getCondition())) {
                    return false;
                }
                return this.isMatch(node, (Selector)cs.getSimpleSelector());
            }
        }
        return false;
    }

    private boolean evaluateCondition(ReportElement node, Condition condition) {
        switch (condition.getConditionType()) {
            case 0: {
                CombinatorCondition cc = (CombinatorCondition)condition;
                return this.evaluateCondition(node, cc.getFirstCondition()) && this.evaluateCondition(node, cc.getSecondCondition());
            }
            case 1: {
                CombinatorCondition cc = (CombinatorCondition)condition;
                return this.evaluateCondition(node, cc.getFirstCondition()) || this.evaluateCondition(node, cc.getSecondCondition());
            }
            case 4: {
                AttributeCondition ac = (AttributeCondition)condition;
                Object attr = this.queryAttribute(node, ac);
                if (ac.getValue() == null) {
                    return attr != null;
                }
                return ObjectUtilities.equal((Object)attr, (Object)ac.getValue());
            }
            case 9: {
                AttributeCondition ac = (AttributeCondition)condition;
                String namespace = this.getNamespace(node);
                if (namespace == null) {
                    namespace = this.namespaces.getDefaultNamespaceURI();
                }
                if (namespace == null) {
                    return false;
                }
                NamespaceDefinition ndef = this.namespaces.getDefinition(namespace);
                if (ndef == null) {
                    return false;
                }
                String[] classAttribute = ndef.getClassAttribute(this.getTagName(node));
                for (int i = 0; i < classAttribute.length; ++i) {
                    String attr = classAttribute[i];
                    String htmlAttr = (String)node.getAttribute(namespace, attr);
                    if (!this.isOneOfAttributes(htmlAttr, ac.getValue())) continue;
                    return true;
                }
                return false;
            }
            case 5: {
                AttributeCondition ac = (AttributeCondition)condition;
                Object id = node.getAttribute("http://www.w3.org/XML/1998/namespace", "id");
                return ObjectUtilities.equal((Object)ac.getValue(), (Object)id);
            }
            case 6: {
                AttributeCondition ac = (AttributeCondition)condition;
                Locale locale = this.getLanguage(node);
                String lang = locale.getLanguage();
                return this.isBeginHyphenAttribute(lang, ac.getValue());
            }
            case 2: {
                NegativeCondition nc = (NegativeCondition)condition;
                return !this.evaluateCondition(node, nc.getCondition());
            }
            case 7: {
                AttributeCondition ac = (AttributeCondition)condition;
                Object o = this.queryAttribute(node, ac);
                if (o == null) {
                    return false;
                }
                try {
                    String attr = ConverterRegistry.toAttributeValue(o);
                    return this.isOneOfAttributes(attr, ac.getValue());
                }
                catch (BeanException e) {
                    return false;
                }
            }
            case 10: {
                AttributeCondition ac = (AttributeCondition)condition;
                String pseudoClass = this.getPseudoElement(node);
                if (pseudoClass == null) {
                    return false;
                }
                return pseudoClass.equals(ac.getValue());
            }
        }
        return false;
    }

    private Object queryAttribute(ReportElement node, AttributeCondition ac) {
        String namespaceURI = ac.getNamespaceURI();
        Object attr = namespaceURI == null ? node.getFirstAttribute(ac.getLocalName()) : node.getAttribute(namespaceURI, ac.getLocalName());
        return attr;
    }

    private String getPseudoElement(ReportElement node) {
        return null;
    }

    private String getNamespace(ReportElement node) {
        return "http://reporting.pentaho.org/namespaces/engine/attributes/core";
    }

    private String getTagName(ReportElement node) {
        return node.getElementType().getMetaData().getName();
    }

    private Locale getLanguage(ReportElement node) {
        return null;
    }

    private boolean isOneOfAttributes(String attrValue, String value) {
        if (attrValue == null) {
            return false;
        }
        if (attrValue.equals(value)) {
            return true;
        }
        StringTokenizer strTok = new StringTokenizer(attrValue);
        while (strTok.hasMoreTokens()) {
            String token = strTok.nextToken();
            if (!token.equals(value)) continue;
            return true;
        }
        return false;
    }

    private boolean isBeginHyphenAttribute(String attrValue, String value) {
        if (attrValue == null) {
            return false;
        }
        if (value == null) {
            return false;
        }
        return attrValue.startsWith(value);
    }

    private boolean isDescendantMatch(ReportElement node, Selector selector) {
        for (Section parent = node.getParentSection(); parent != null; parent = parent.getParentSection()) {
            if (!this.isMatch(parent, selector)) continue;
            return true;
        }
        return false;
    }

    private boolean isSilblingMatch(ReportElement node, SiblingSelector select) {
        ReportElement pred = this.getPreviousReportElement(node);
        while (pred != null) {
            if (this.isMatch(pred, (Selector)select)) {
                return true;
            }
            pred = this.getPreviousReportElement(pred);
        }
        return false;
    }

    private ReportElement getPreviousReportElement(ReportElement e) {
        Section parentSection = e.getParentSection();
        if (parentSection == null) {
            return null;
        }
        int count = parentSection.getElementCount();
        for (int i = 0; i < count; ++i) {
            Element element = parentSection.getElement(i);
            if (e != element) continue;
            if (i == 0) {
                return null;
            }
            return parentSection.getElement(i - 1);
        }
        return null;
    }
}

