/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.style;

import java.awt.Stroke;
import java.io.ObjectStreamException;
import java.io.Serializable;
import org.pentaho.reporting.engine.classic.core.util.ObjectStreamResolveException;
import org.pentaho.reporting.engine.classic.core.util.StrokeUtility;

public class BorderStyle
implements Serializable {
    public static final BorderStyle NONE = new BorderStyle("none", 5);
    public static final BorderStyle HIDDEN = new BorderStyle("hidden", 5);
    public static final BorderStyle DOTTED = new BorderStyle("dotted", 2);
    public static final BorderStyle DASHED = new BorderStyle("dashed", 1);
    public static final BorderStyle SOLID = new BorderStyle("solid", 0);
    public static final BorderStyle DOUBLE = new BorderStyle("double", -1);
    public static final BorderStyle DOT_DASH = new BorderStyle("dot-dash", 3);
    public static final BorderStyle DOT_DOT_DASH = new BorderStyle("dot-dot-dash", 4);
    public static final BorderStyle WAVE = new BorderStyle("wave", -1);
    public static final BorderStyle GROOVE = new BorderStyle("groove", -1);
    public static final BorderStyle RIDGE = new BorderStyle("ridge", -1);
    public static final BorderStyle INSET = new BorderStyle("inset", -1);
    public static final BorderStyle OUTSET = new BorderStyle("outset", -1);
    private String type;
    private int strokeType;

    private BorderStyle(String type, int strokeType) {
        this.type = type;
        this.strokeType = strokeType;
    }

    public int getStrokeType() {
        return this.strokeType;
    }

    public Stroke createStroke(float width) {
        return StrokeUtility.createStroke(this.strokeType, width);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BorderStyle that = (BorderStyle)o;
        return !(this.type != null ? !this.type.equals(that.type) : that.type != null);
    }

    public int hashCode() {
        return this.type != null ? this.type.hashCode() : 0;
    }

    public String toString() {
        return this.type;
    }

    public static final BorderStyle getBorderStyle(String type) {
        if (type == null) {
            return null;
        }
        if (type.equals(BorderStyle.NONE.type)) {
            return NONE;
        }
        if (type.equals(BorderStyle.DASHED.type)) {
            return DASHED;
        }
        if (type.equals(BorderStyle.DOT_DASH.type)) {
            return DOT_DASH;
        }
        if (type.equals(BorderStyle.DOT_DOT_DASH.type)) {
            return DOT_DOT_DASH;
        }
        if (type.equals(BorderStyle.DOTTED.type)) {
            return DOTTED;
        }
        if (type.equals(BorderStyle.DOUBLE.type)) {
            return DOUBLE;
        }
        if (type.equals(BorderStyle.GROOVE.type)) {
            return GROOVE;
        }
        if (type.equals(BorderStyle.HIDDEN.type)) {
            return HIDDEN;
        }
        if (type.equals(BorderStyle.INSET.type)) {
            return INSET;
        }
        if (type.equals(BorderStyle.NONE.type)) {
            return NONE;
        }
        if (type.equals(BorderStyle.OUTSET.type)) {
            return OUTSET;
        }
        if (type.equals(BorderStyle.RIDGE.type)) {
            return RIDGE;
        }
        if (type.equals(BorderStyle.SOLID.type)) {
            return SOLID;
        }
        if (type.equals(BorderStyle.WAVE.type)) {
            return WAVE;
        }
        return null;
    }

    protected Object readResolve() throws ObjectStreamException {
        BorderStyle style = BorderStyle.getBorderStyle(this.type);
        if (style != null) {
            return style;
        }
        throw new ObjectStreamResolveException();
    }
}

